#include "Spi_example.h"
#include "csl_uhpi.h"
#include "csl_chip.h"
#include "csl_emif.h"
#include "csl_intc.h"
#include "csl_rti.h"
#include "csl_rtiAux.h"
#include "csl_mcasp.h"
#include "cslr_mcasp.h"
#include "csl_dmax.h"

Uint16  Read_One_Word(Uint32);
/* Global Handles for the mcasp1 instance*/
CSL_McaspHandle          hMcasp;
CSL_McaspObj             mcaspObj; 
/* Global Handles for the dmax instance*/
CSL_DmaxObj                     dmaxEvent;
CSL_DmaxHandle                  hDmax;
CSL_DmaxHwSetup                 hwSetup;

CSL_IntcHandle              hIntc;
CSL_IntcEventEnableState    eventStat;
CSL_IntcDispatcherContext   intcDispatcherContext;

Uint32                    flag,response;
Uint32                    srcdata[NUM_RCV_SERIALIZER];
Uint32                    dstdata[NUM_RCV_SERIALIZER];
Uint32                    length = NUM_RCV_SERIALIZER;
/*
 * =============================================================================
 *  @func   main
 *
 *  @desc
 *     This is the test main
 *
 *  @arg
 *      NONE
 *  
 *  @return
 *      NONE
 * =============================================================================
*/
void main (void)
{                   
	Uint32  j=0; 
    CSL_sysInit();
	DELAY_NUS (_3US);
	CSL_intcSetVectorPtr (0x10000000);  
	DELAY_NUS (_3US);
	pll_configer ();
	DELAY_NUS (_3US);
	fillMem ((Uint32) srcdata,length, SRC_DATA_DEFAULT, FILL_INC);
	DELAY_NUS (_3US);
    fillMem ((Uint32) dstdata,length, DST_DATA_DEFAULT, FILL_CONST); 
    DELAY_NUS (_3US);  	 	
	dmax_configer ();
    DELAY_NUS (_3US);
    DELAY_NUS (_3US);
    setup_Interrupts();
	DELAY_NUS (_3US);
	mcasp1_configer();      
	DELAY_NUS (_3US);								                                                 	    			     	                 	  	
    while(1)
	{
		 flag = hMcasp->regs->SRCTL1;
		 if((flag&0x00000011)==0x00000011)
		 {
				dstdata[j] = hMcasp->regs->XBUF1;
				DELAY_NUS (1000);
				j++;
				if(j==8)
					j=0;
		 }
		 DELAY_NUS (_3US);
		 DELAY_NUS (1000);
		 hDmax->regs->DEER = 0xffffffff;
		 DELAY_NUS (_3US);
		 DELAY_NUS (1000);
	} 			  	      
}

void intr08 ()
{
	CSL_Status  status; 
    status = status; 
    hDmax->regs->DEDR = 0xffffffff; 	
	status = CSL_dmaxHwControl(hDmax,CSL_DMAX_CMD_CLEARTCC,NULL);	
	/* Getting the TCC bit value */
    status = CSL_dmaxGetHwStatus (hDmax, CSL_DMAX_QUERY_GET_TCC, (void *) &response);
    /* Checking the value of the TCC bit i.e cleared or not */
    if (response != 0) 
    {
        printf ("Clear TCC Bit failed!\n");
    }
    else 
    {
        printf ("Clear TCC bit Passed!\n");
    }	
	return;	
}

void intr07 ()
{
	printf ("dmax transfer failed!\n");
	return;
}

