/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */

/** ============================================================================
 *   @file  Spi_example.c
 *
 *
 *   @desc  Example of SPI CSL module
 *
 *
 * =============================================================================
 *   @n <b> Test Description </b>
 *   @n The example shows how to use SPI csl.
 * =============================================================================
 *   @n <b> Test Description </b>
 *   @n The example shows how to test the SPI CSL
 *      1. Intialize the PLLC module    
 *      2. Intialize SPI with required setup for the test
 *      3. Transmit and receive the data in polling mode
 *      4. Verify data received
 *      5. Close the module
 *==============================================================================
 *      
 *   <b> Test Procedure </b>
 *   @verbatim
 *      1. Configure the CCS setup to work with the emulator being used.
 *         Refer CCS manual for setup configuration.
 *      2. Load required GEL file depending on the board used.
 *      3. Launch CCS window.
 *      4. Open project spi_example.pjt
 *      5. Build the project and load the .out file of the project.
 *      6. The test can be executed from the main().
 *          
 *   @endverbatim
 *       
 *   
 * =============================================================================
 */

/* =============================================================================
 *  Revision History
 *  ===============
 *  07-Mar-2005 GaneshK  File created.
 *
 * =============================================================================
 */

#include "Spi_example.h"
#include "csl_uhpi.h"
#include "csl_chip.h"
#include "csl_emif.h"
#include "csl_intc.h"
#include "csl_rti.h"
#include "csl_rtiAux.h"
#include "csl_mcasp.h"
#include "csl_dmax.h"

Uint16  Read_One_Word(Uint32);

/* Handle for the SPI1 instance */
CSL_SpiHandle            hSpi;
CSL_SpiObj               spiObj;
/* Handle for the SPI0 instance */
CSL_SpiHandle            hSpi0;
CSL_SpiObj               spiObj0;
/* Handle for the uhpi instance */
CSL_UhpiHandle           hUhpi = (CSL_UhpiHandle) NULL;
CSL_UhpiObj              uhpiObj;
/* Handle for the emif instance */
CSL_EmifHandle           hEmif = NULL;
CSL_EmifObj              emifObj;
/* Handle for the timer instance */
CSL_RtiHandle            hRti;
CSL_RtiObj               rtiObj;

/* Global Handles for the mcasp0 instance*/
CSL_McaspHandle          hMcasp0;
CSL_McaspObj             mcaspObj0;

/* Global Handles for the mcasp1 instance*/
CSL_McaspHandle          hMcasp;
CSL_McaspObj             mcaspObj; 

/* Global Handles for the mcasp2 instance*/
CSL_McaspHandle          hMcasp2;
CSL_McaspObj             mcaspObj2; 

/* Global Handles for the dmax instance*/
CSL_DmaxObj                     dmaxEvent;
CSL_DmaxHandle                  hDmax;

CSL_IntcHandle              hIntc;
CSL_IntcEventEnableState    eventStat;
CSL_IntcDispatcherContext   intcDispatcherContext;


Uint32                      mainflag;              //0.5ms ʱжϱ־
Uint32                      count5502 = 0;         //5502ʼ
Uint32                      res5502 = 0;           //5502һ
Uint32                      intr_value1553 = 0;      //1553BC 


Uint32                      count422 = 0;          //422ʼ          
Uint32                      res422 = 0;            //422һ
Uint32                      tran422 = 0x0;          //422


Uint32                      tranfifo = 0x00;          //fifo

Uint32                      count1553 = 0;          //1553ʼ          
Uint32                      res1553 = 0;            //1553һ
Uint32 *                    ptr_bootram = ( Uint32 * )0x10021000 ;
Uint32 *                    ptr_subram = 0x00; 
Uint32                      flag1553 = 0;
//Uint32                      rec1553dat;


//test//////////////////////////////////
Uint32               count_main = 0;
//422
Uint32               compute422 =0;
Uint32               count_intr6 = 1;
Uint32               erro422 = 0;
//ad
Int16               Ad0[101] = {0};
Int16               Ad1[101] = {0};
Int16               Ad2[101] = {0};
Int16               Ad3[101] = {0};
Uint32               count_ad = 0; 
Uint32               ad_flag = 0;               

Int32               ad0_trans = 0;
Int32               ad1_trans = 0;
Int32               ad2_trans = 0;
Int32               ad3_trans = 0;
Int32               ad0_show = 0;
Int32               ad1_show = 0;
Int32               ad2_show = 0;
Int32               ad3_show = 0;

Int32               tem0 = 0;
Int32               tem1 = 0;


float               ad0,ad1,ad2,ad3;
float               da;
Int32               da_show;

//
Uint32               power24 = 0; 
Uint32               power31 = 0;
Uint32               poweractive = 0;
Uint32               powerb = 0;

//1553
Uint32               erro1553 = 0;
Uint32               compute1553 = 0;        
//5502
Uint32               erro5502 = 0;
Uint32               compute5502 = 0;
Uint32               startdata = 0;
Uint32               enddata = 0;


Uint32               uhpi_io;      


float                ad0_offset, ad0_gain, ad1_offset, ad1_gain, ad2_offset, ad2_gain, ad3_offset, ad3_gain, da_offset, da_gain;

//Uint32               alt;
//Uint32               *ptr153 = (Uint32 *) 0x10022100;
//Uint32               dat[10];
//Uint32               cot=0;
/*
 * =============================================================================
 *  @func   main
 *
 *  @desc
 *     This is the test main
 *
 *  @arg
 *      NONE
 *  
 *  @return
 *      NONE
 * =============================================================================
*/
void
main (
    void
)
{   

      

	Uint32                  * ptr;
	Uint32                    value;
	Uint32                    switchflag;               //־
	Uint32                    flag;                
    Uint32                    i,k,j = 0;                

    Uint32                    test_num;
    Uint32                    c;
    Uint32                    countda = 0;


    CSL_sysInit();

///////////////////////////////////////////////////


    pll_configer ();

	uhpi_configer ();

    UHPI_GPIO_DAT1 = 0x26000000;    //UHPI[29]1553,  UHPI[26]flash,  UHPI[25]fpga ֹѡͨ

    mcasp0_io_configer();

    emif_configer ();

    timer_configer ();

	//spi1_configer ();

	//mcasp2_io_configer ();                                                  
                                                               
   // mcasp1_5502_configer ();

    CSL_intcSetVectorPtr (0x10000000);

    setup_Interrupts ();
     
    dmax_configer ();  

    com1553_rt_configer ();
    
     

    printf ("pro: instance... Passed.\n");
             

      //λFPGA
	  DELAY_NUS (240);
	  UHPI_GPIO_DAT1 = ( UHPI_GPIO_DAT1 | 0x80000000 );   //UHPI[31]	 
	  DELAY_NUS (240);
      
      UHPI_GPIO_DAT1 = ( UHPI_GPIO_DAT1 & 0xfdffffff );   //select fpga    
      DELAY_NUS (3);

	  //ʱ׼
	  TIMER_OPEN = 0x55;        	  
	  DELAY_NUS (_3US);		  

	  //ضʱ׼		 
//	  TIMER_CLOSE = 0x55;       	  
//	  DELAY_NUS (_3US);		  

	
      value = 0x00000000;
      CSL_chipWriteReg (CSL_CHIP_REG_AMR, value);
            
     // while(1);

      test_num = 0x00007e7e;
	  ptr = (Uint32 *) 0x90001180;

	  UHPI_GPIO_DAT1 = ( UHPI_GPIO_DAT1 | 0x02000000 );       //clear select fpga
	  DELAY_NUS(3);    
      UHPI_GPIO_DAT1 = ( UHPI_GPIO_DAT1 & 0xdfffffff );       //select 1553    
      DELAY_NUS(3);
      UHPI_GPIO_DAT1 = ( UHPI_GPIO_DAT1 | 0x10000000 );       //select MEM 
      DELAY_NUS(3); 
      

	  do {                                       //0.5msʱ
	        flag = mainflag;
	         	     
      * ptr = test_num;
               
      test_num = test_num + 0x0001;
 
      DELAY_NUS(_1US); 

	  }

	  while(flag != 0x00000001);

	  mainflag = 0x00;

	  UHPI_GPIO_DAT1 = ( UHPI_GPIO_DAT1 | 0x20000000 );       //clear select 1553 
      DELAY_NUS (3);
      UHPI_GPIO_DAT1 = ( UHPI_GPIO_DAT1 & 0xfdffffff );   //select fpga
	  DELAY_NUS(3);

      EXRESET_DIS_CLOSE = 0x55;             //ⲿλر 
      DELAY_NUS(7);
       
    //  EXRESET_DIS_OPEN = 0x55;             //ⲿλ 
      DELAY_NUS(7);
	 //while(1);
	 
while( 1 )

{

 //sample  8 CHANNEL ADC//////////////////////////////////////////////////////////////////     
    
  if( ad_flag != 1){                               //ad_flag  
     
                   
	 Ad0[j] = AD_CHANNEL0_READ;                    // ͨ0
     DELAY_NUS(7); 
	 Ad1[j] = AD_CHANNEL1_READ;                    // ͨ1
 	 DELAY_NUS(7);
	 Ad2[j] = AD_CHANNEL2_READ;                    // ͨ2
 	 DELAY_NUS(7);
	 Ad3[j] = AD_CHANNEL3_READ;                    // ͨ3
	 DELAY_NUS(7);

     if( count_ad < 100 )  {  

      count_ad++;
	  j++;
  
     }

	 else{ 
	    
		  count_ad = 0;
		  j = 0;
		  
		  for( k=1;k<101;k++)
		  {  
		      ad0_trans = ad0_trans + Ad0[k];
			  ad1_trans = ad1_trans + Ad1[k];
			  ad2_trans = ad2_trans + Ad2[k];
			  ad3_trans = ad3_trans + Ad3[k];
		  }
		   
          ad0_trans = ad0_trans/100;
		  ad1_trans = ad1_trans/100;
		  ad2_trans = ad2_trans/100;
		  ad3_trans = ad3_trans/100;
                        
						/*
          ad0_trans = AD_CHANNEL0_READ;
		  ad1_trans = AD_CHANNEL1_READ;
		  ad2_trans = AD_CHANNEL2_READ;
		  ad3_trans = AD_CHANNEL3_READ;
         */
		  ad_flag = 1;
	  
	 }

     
   }

        //ɼ¶
        tem0 = TEM_CHANNEL0_READ ;
		  DELAY_NUS(7); 
		  DELAY_NUS(7); 
		tem1 = TEM_CHANNEL1_READ ;
      DELAY_NUS(7); 
//⿪ examine io ports	 
      
     switchflag = UHPI_GPIO_DAT1 & 0x00000100;      // UHPI[8]
     if(switchflag != 0){
     	toff();
     }        
      
     
     switchflag = UHPI_GPIO_DAT1 & 0x00000200;      // UHPI[9]
     if(switchflag != 0){ 
     	yxqd();
     } 
      
      
     switchflag = UHPI_GPIO_DAT1 & 0x00000800;     //Լ UHPI[11]
     if(switchflag != 0){
     	yxzjjg();
     } 
      
      
     switchflag = UHPI_GPIO_DAT1 & 0x00000400;     //ȫװԼ UHPI[10]
     if(switchflag != 0){
     	zzzj();
     } 
      
            
     switchflag = UHPI_GPIO_DAT1 & 0x00000020;    //24Դ UHPI[5]
     if(switchflag != 0){
	    power24 = 0x0000FFFF;
     	power_24();
      }
        
      
     switchflag = UHPI_GPIO_DAT1 & 0x00000040;     //31Դ UHPI[6]
     if(switchflag != 0){
	    power31 = 0x0000FFFF;
     	power_31();
     } 
      

     switchflag = UHPI_GPIO_DAT1 & 0x00000010;     //ϵؼ UHPI[4]
     if(switchflag != 0){
	    poweractive = 0x0000FFFF;
     	power_active();
     } 


     switchflag = UHPI_GPIO_DAT1 & 0x00000080;     //BԴ UHPI[7]
     if(switchflag != 0){
	    powerb = 0x0000FFFF;
     	power_b();
     }
	 
                 

     if( countda >= 140000 ) c=10;
	 else c = countda / 14000 ;
   
     switch( c )
	 {   
                                                   
	   case 0 :    DA_OUTPUT = 0x7ff00000 ;break;  // 5v
	   case 1 :    DA_OUTPUT = 0x60000000 ;break;  // 3.75v
	   case 2 :    DA_OUTPUT = 0x40000000 ;break;  // 2.5v
	   case 3 :    DA_OUTPUT = 0x20000000 ;break;  // 1.25v
       case 4 :    DA_OUTPUT = 0x10000000 ;break;  // 0.625v
	   case 5 :    DA_OUTPUT = 0x00000000 ;break;  // 0v
       case 6 :    DA_OUTPUT = 0xf0000000 ;break;  // -0.625v
	   case 7 :    DA_OUTPUT = 0xe0000000 ;break;  // -1.25v
	   case 8 :    DA_OUTPUT = 0xc0000000 ;break;  // -2.5v
	   case 9 :    DA_OUTPUT = 0xa0000000 ;break;  // -3.75v
	   case 10 :    DA_OUTPUT = 0x80000000 ;break;  // -5v

	  }
	   	   
	   countda++;

      if(countda > 154000 ){ countda = 0; }

	 DELAY_NUS(10);

//fifoѭ send_fifo
     
  		FIFO_WRITE = 0xff00007e;                //FIFO write

        DELAY_NUS (2);

     for(i=0;i<8;i++){

	//	FIFO_WRITE = tranfifo;                //FIFO write
		FIFO_WRITE = 0xffffffff;
        DELAY_NUS (2);

        tranfifo++;
	 	
	 }
      
  		FIFO_WRITE = 0x007e7e7e;                //FIFO write

        DELAY_NUS (2);


     tranfifo = tranfifo;

	 FIFO_TRANS = 0x55;                      //FIFO transfer
     
	 DELAY_NUS (_1US);

//send_422

	HDLC_WRITE = 0x52520050;                //422״ַ̬
	
	DELAY_NUS (_1US);
	           
    for(i=0;i<20;i++){                      //ѭ432λ       
           
		tran422++;

    	HDLC_WRITE = tran422;
     
        DELAY_NUS (_1US);

     
		 
    } 
    

	HDLC_TRANS = 0x55;                     //422
     
    DELAY_NUS (_1US);  
     
    
     if(count_main < 0x000927c0)   //0x000927c0
	 { 
	    compute422++ ;
        count_main++ ;

     }




     do {                             //0.5msʱ
     	  flag = mainflag; }

     while(flag!=0x00000001);

     mainflag = 0x00;

  }                                  ////while(1)  

   
}




















