/*
 *  ======== main.c ========
 */

#include <xdc/std.h>

#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>

#include <ti/sysbios/BIOS.h>

#include <ti/sysbios/knl/Task.h>
#include "ti/platform/platform.h"
#include "ti/platform/resource_mgr.h"
/*
 *  ======== taskFxn ========
 */
Void taskFxn(UArg a0, UArg a1)
{
    System_printf("enter taskFxn()\n");

    Task_sleep(10);

    System_printf("exit taskFxn()\n");
    platform_init_flags  sFlags;
    	 platform_init_config sConfig;
    	    /* Status of the call to initialize the platform */
    	    Int32 pform_status;
    	    int coreId = 0;
    	    /* Platform Information - we will read it form the Platform Library */
    	    platform_info    sPlatformInfo;

    	    /*
    	     * You can choose what to initialize on the platform by setting the following
    	     * flags. We will initialize everything.
    	     */
    	    memset( (void *) &sFlags,  0, sizeof(platform_init_flags));
    	    memset( (void *) &sConfig, 0, sizeof(platform_init_config));

    	    sFlags.pll  = 0;    /* PLLs for clocking      */
    	    sFlags.ddr  = 0;    /* External memory         */
    	    sFlags.tcsl = 1;    /* Time stamp counter     */
    		sFlags.phy  = 1;    /* Ethernet             */
    	    sFlags.ecc  = 0;    /* Memory ECC             */

    	    sConfig.pllm = 0;    /* Use libraries default clock divisor */
    	    pform_status = platform_init(&sFlags, &sConfig);

    	    coreId = platform_get_coreid ();


    	    platform_led(0, PLATFORM_LED_ON, PLATFORM_USER_LED_CLASS);
    	    platform_led(1, PLATFORM_LED_ON, PLATFORM_USER_LED_CLASS);
    	    platform_led(2, PLATFORM_LED_ON, PLATFORM_USER_LED_CLASS);
    	    platform_led(3, PLATFORM_LED_ON, PLATFORM_USER_LED_CLASS);
    	    if (pform_status == Platform_EOK && coreId == 0)
    	    {
    	    	platform_get_info(&sPlatformInfo);
    	    	platform_led(0, PLATFORM_LED_OFF, PLATFORM_USER_LED_CLASS);
    	    	platform_led(1, PLATFORM_LED_OFF, PLATFORM_USER_LED_CLASS);
    	    	platform_led(2, PLATFORM_LED_OFF, PLATFORM_USER_LED_CLASS);
    	    	platform_led(3, PLATFORM_LED_OFF, PLATFORM_USER_LED_CLASS);

    			while (1)
    			{
    				(void) platform_led(0, PLATFORM_LED_ON, PLATFORM_USER_LED_CLASS);
    				(void) platform_delay(10000000);
    				(void) platform_led(0, PLATFORM_LED_OFF, PLATFORM_USER_LED_CLASS);
    				(void) platform_delay(10000000);
    			};
    	    }
    	    else
    	    {
    	    	; // Slave core do nothing
    }
}

/*
 *  ======== main ========
 */
Int main()
{ 
    Task_Handle task;
    Error_Block eb;

    System_printf("enter main()\n");

    Error_init(&eb);
    task = Task_create(taskFxn, NULL, &eb);
    if (task == NULL) {
        System_printf("Task_create() failed!\n");
        BIOS_exit(0);
    }

    BIOS_start();    /* does not return */
    return(0);
}
