/****************************************************************************/
/*                                                                          */
/*              ݴӿƼ޹˾                                    */
/*                                                                          */
/*              Copyright (C) 2015 Tronlong Electronic Technology Co.,Ltd   */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*              ٸҶ任 / ٸҶ任ʵ׼           */
/*                                                                          */
/*              20151231                                              */
/*                                                                          */
/****************************************************************************/
#include <stdio.h>                  // C Ա׼
#include <math.h>                   // C ѧ

#include <c6x.h>

#include "mathlib.h"                // DSP ѧ
#include "dsplib.h"                 // DSP 

#include "KeyStone_common.h"

/****************************************************************************/
/*                                                                          */
/*              궨                                                      */
/*                                                                          */
/****************************************************************************/
// ϵ
#define SW_BREAKPOINT     asm(" SWBP 0 ");

// ģʽ
#define SIMULATION
#define DEBUGPRINT        printf

// ٸҶ任
// ԿٸҶ任
// ע:TI DSP ֧һԼ 256K ʵ FFT
#define N  262144 // 256K

// ٸҶ任
//   Сֵ
#define PI                3.141592654
#define F_TOL             (1e-06)

/****************************************************************************/
/*                                                                          */
/*              ȫֱ                                                    */
/*                                                                          */
/****************************************************************************/
unsigned int CycleOverHead;

// ź
#pragma DATA_ALIGN(Input, 8);
float Input[2 * N];

#pragma DATA_ALIGN(InputOrig, 8);
float InputOrig[2 * N];

// FFT 
#pragma DATA_ALIGN(FFT_Out, 8);
float FFT_Out[2 * N];
// IFFT 
#pragma DATA_ALIGN(IFFT_Out, 8);
float IFFT_Out[2 * N];

// ת
#pragma DATA_ALIGN(W, 8);
float W[2 * N];

// ģ
#pragma DATA_ALIGN(Mo, 8);
float Mo[N];

// λת
#pragma DATA_ALIGN (brev, 8);
unsigned char brev[64] =
{
	0x00, 0x20, 0x10, 0x30, 0x08, 0x28, 0x18, 0x38,
	0x04, 0x24, 0x14, 0x34, 0x0c, 0x2c, 0x1c, 0x3c,
	0x02, 0x22, 0x12, 0x32, 0x0a, 0x2a, 0x1a, 0x3a,
	0x06, 0x26, 0x16, 0x36, 0x0e, 0x2e, 0x1e, 0x3e,
	0x01, 0x21, 0x11, 0x31, 0x09, 0x29, 0x19, 0x39,
	0x05, 0x25, 0x15, 0x35, 0x0d, 0x2d, 0x1d, 0x3d,
	0x03, 0x23, 0x13, 0x33, 0x0b, 0x2b, 0x1b, 0x3b,
	0x07, 0x27, 0x17, 0x37, 0x0f, 0x2f, 0x1f, 0x3f
};

/****************************************************************************/
/*                                                                          */
/*                                                                  */
/*                                                                          */
/****************************************************************************/

/****************************************************************************/
/*                                                                          */
/*              ٸҶ任                                          */
/*                                                                          */
/****************************************************************************/
// ת
void tw_gen(float *w, int n)
{
    int i, j, k;

    for(i = 1, k = 0; i < n >> 2; i++)
    {
        w[k    ] = sin(2 * PI * i / n);
        w[k + 1] = cos(2 * PI * i / n);

        k += 2;
    }

    for(j = 1; j <= n >> 3; j = j << 2)
    {
        for(i = 0; i < n >> 3; i += j)
        {
            w[k]     = (float)sin( 4 * PI * i / n);
            w[k + 1] = (float)cos( 4 * PI * i / n);
            w[k + 2] = (float)sin( 8 * PI * i / n);
            w[k + 3] = (float)cos( 8 * PI * i / n);
            w[k + 4] = (float)sin(12 * PI * i / n);
            w[k + 5] = (float)cos(12 * PI * i / n);

            k += 6;
        }
    }
}

void tw_geni(float *w, int n)
{
    int i, j, k;

    for(i = 1, k = 0; i < n >> 2; i++)
    {
        w[k    ] =  sin(2 * PI * i / n);
        w[k + 1] = -cos(2 * PI * i / n);

        k += 2;
    }

    for(j = 1; j <= n >> 3; j = j << 2)
    {
        for(i = 0; i < n >> 3; i += j)
        {
            w[k]     = (float)-sin( 4 * PI * i / n);
            w[k + 1] = (float) cos( 4 * PI * i / n);
            w[k + 2] = (float)-sin( 8 * PI * i / n);
            w[k + 3] = (float) cos( 8 * PI * i / n);
            w[k + 4] = (float)-sin(12 * PI * i / n);
            w[k + 5] = (float) cos(12 * PI * i / n);

            k += 6;
        }
    }
}

// ٸҶ任
void FFT(float fs, unsigned int n, unsigned char rad)
{
	// ת
	tw_gen(W, n);

	// FFT 
	long long tBefore, tAfter, tOverhead;

	tBefore = _itoll(TSCH, TSCL);
	DSPF_sp_fftSPxSP_r2c(n, Input, W, FFT_Out, brev, rad, 0, n);
	tAfter = _itoll(TSCH, TSCL);
	tOverhead = tAfter - tBefore - CycleOverHead;

	DEBUGPRINT("-Forward Transformation Execution Cycle is %lld \n", tOverhead);
	DEBUGPRINT("-Forward Transformation Execution Time is %5.7f us (CPU Frequency:1000MHz)\n", tOverhead / 1000.0);
}

// ٸҶ任
void IFFT(unsigned int n, unsigned char rad)
{
	// ת
	tw_geni(W, n);

	// IFFT 
	long long tBefore, tAfter, tOverhead;

	tBefore = _itoll(TSCH, TSCL);
	DSPF_sp_ifftSPxSP_c2r(n, FFT_Out, W, IFFT_Out, brev, rad, 0, n);
	tAfter = _itoll(TSCH, TSCL);
	tOverhead = tAfter - tBefore - CycleOverHead;

	DEBUGPRINT("-Inverse Transformation Execution Cycle is %lld \n", tOverhead);
	DEBUGPRINT("-Inverse Transformation Execution Time is %5.7f us (CPU Frequency:1000MHz)\n", tOverhead / 1000.0);
}

// ٸҶ任 / ٸҶ任 
void FFTTest(unsigned char index, float fs, unsigned int n, unsigned char rad)
{
	// ź
	unsigned int i;
	for (i = 0; i < N; i++)
	{
		Input[i] = 2 + 3 * cossp(2 * PI * 50 * (i / fs) - PI * 30 / 180) + 1.5 * cossp(2 * PI * 75 * (i / fs) + PI * 90 / 180);
	}

	// һźŸ
	memcpy(InputOrig, Input, 2 * N * sizeof(float));

	unsigned int f;
	f = fs;

	DEBUGPRINT("----------------------------------------------------------------------\n");
	DEBUGPRINT("%d: %d Point FFT Test \n-Sampling Period:1s Sampling Frequency:%dHz Frequency Resolution:1Hz\n", index, n, f);

	// ٸҶ任
	FFT(fs, n, rad);

	// 
	for(i = 0; i < n; i++)
	{
		Mo[i] = sqrtsp(powsp(FFT_Out[2 * i], 2) + powsp(FFT_Out[2 * i +1 ], 2));

		if(i == 0)
		{
			Mo[i] = Mo[i] / n;
		}
		else
		{
			Mo[i] = Mo[i] * 2 / n;
		}

		if(Mo[i] < F_TOL)
		{
			Mo[i] = 0;
		}
	}

	// ٸҶ任
	IFFT(n, rad);

	DEBUGPRINT("%d Point FFT Test End\r\n", n);
}

/****************************************************************************/
/*                                                                          */
/*                                                                    */
/*                                                                          */
/****************************************************************************/
int main(void)
{
	short i;
#ifndef SIMULATION
	CSL_CgemRegs *C66xCorePacRegs;
	C66xCorePacRegs = (CSL_CgemRegs *)CSL_CGEM0_5_REG_BASE_ADDRESS_REGS;

	CACHE_invAllL1p(CACHE_WAIT);
	CACHE_wbInvAllL1d(CACHE_WAIT);
	CACHE_wbInvAllL2(CACHE_WAIT);
	CSL_XMC_invalidatePrefetchBuffer();
	_mfence();
	_mfence();

	//  DDR3 ڴΪɱͲԤȡ
	for(i = 128; i < 256; i++)
	{
		C66xCorePacRegs->MAR[i] = 0;
	}
#endif

	// ܼ
	long long tBefore, tAfter;

	TSCL = 0;

	tBefore = _itoll(TSCH, TSCL);
	tAfter = _itoll(TSCH, TSCL);
	CycleOverHead = tAfter - tBefore;

	// ӡ˵
	DEBUGPRINT("\r\nTest signal\n-Include 2V DC Component \n-Include 3V AC Component,Frequency:50Hz Phase:-30 Degree\n-Include 1.5V AC Component,Frequency:75Hz Phase:90 Degree\n-Formula:y=2+3cos(2pi*50t-(30/180)pi)+1.5cos(2pi*75t+*(90/180)pi)\n");
	DEBUGPRINT("--------------------------- Cache Disabled ---------------------------\n");

	// ٸҶ任 / ٸҶ任 
	FFTTest(1,      16.0,     16, 2);
	FFTTest(2,      32.0,     32, 2);
	FFTTest(3,      64.0,     64, 4);
	FFTTest(4,     128.0,    128, 2);
	FFTTest(5,     256.0,    256, 4);
	FFTTest(6,     512.0,    512, 2);
	FFTTest(7,    1024.0,   1024, 4);
	FFTTest(8,    2048.0,   2048, 2);
	FFTTest(9,    4096.0,   4096, 4);
	FFTTest(10,   8192.0,   8192, 2);
	FFTTest(11,  16384.0,  16384, 4);
	FFTTest(12,  32768.0,  32768, 2);
	FFTTest(13,  65536.0,  65536, 4);
	FFTTest(14, 131072.0, 131072, 2);
	FFTTest(15, 262144.0, 262144, 4);

#ifndef SIMULATION
	DEBUGPRINT("--------------------------- Cache Enabled ----------------------------\n");

	// ʹܻ L1  L2
    CACHE_setL1PSize(CACHE_L1_32KCACHE);
    CACHE_setL1DSize(CACHE_L1_32KCACHE);
    CACHE_setL2Size(CACHE_1024KCACHE);
	CACHE_invAllL1p(CACHE_WAIT);
	CACHE_wbInvAllL1d(CACHE_WAIT);
	CSL_XMC_invalidatePrefetchBuffer();
	_mfence();
	_mfence();

	//  DDR3 ڴΪɱͿԤȡ
	for(i = 128; i < 256; i++)
	{
		C66xCorePacRegs->MAR[i] = 1 | (1 << CSL_CGEM_MAR0_PFX_SHIFT);
	}

	// ٸҶ任 / ٸҶ任 
	FFTTest(1,      16.0,     16, 2);
	FFTTest(2,      32.0,     32, 2);
	FFTTest(3,      64.0,     64, 4);
	FFTTest(4,     128.0,    128, 2);
	FFTTest(5,     256.0,    256, 4);
	FFTTest(6,     512.0,    512, 2);
	FFTTest(7,    1024.0,   1024, 4);
	FFTTest(8,    2048.0,   2048, 2);
	FFTTest(9,    4096.0,   4096, 4);
	FFTTest(10,   8192.0,   8192, 2);
	FFTTest(11,  16384.0,  16384, 4);
	FFTTest(12,  32768.0,  32768, 2);
	FFTTest(13,  65536.0,  65536, 4);
	FFTTest(14, 131072.0, 131072, 2);
	FFTTest(15, 262144.0, 262144, 4);
#endif

	DEBUGPRINT("Test Finished!\n");

	// ϵ
	SW_BREAKPOINT;
}
