/* ======================================================================== */
/*  TEXAS INSTRUMENTS, INC.                                                 */
/*                                                                          */
/* ======================================================================== */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "bmp.h"
/****************************************************************************/
/*     ļbmp                    */
/****************************************************************************/
uint8_t ** read_bmp(char *const filename,bmpfile_header_t *pbf,bmpfile_dib_header_t *pbi,uint8_t **imgdata)
{
	FILE *fp;
	long linebytes = 0;
    long i,j;

	//assert( (filename != NULL) && (pbf != NULL) && (pbi != NULL) );
	if(imgdata != NULL)
	{
		free(imgdata);
		imgdata = NULL;
	}
	fp = fopen("1.bmp","rb");
    if(fp == NULL)
	{
        printf("Open file  error!\n");
        return NULL;
    }

	//ȡϢͷļͷ
    fread(pbf, sizeof(bmpfile_header_t),1,fp); //ָfpָļͷϢдbfַ
    fread(pbi, sizeof(bmpfile_dib_header_t),1,fp);

	//Ϊ24λͼݷ ָռ
    imgdata = (unsigned char**)malloc((sizeof(unsigned char*)) * (pbi->image_height));

    if(pbi->bits_per_pixel == 24)	//24λɫ
	{
		linebytes = (pbi->image_width * 3 + 3)/4 * 4;   //һеֽӦ4
		for ( i=0; i < pbi->image_height; i++)
		{
			imgdata[i] = (unsigned char*)malloc(sizeof(unsigned char) * linebytes);
		}
		for ( i=0;i < pbi->image_height; i++ )  //bmpͼλͼֽڵĶά
		{
			for(j=0; j < linebytes; j++)
			{
				fread( &imgdata[i][j], sizeof(unsigned char),1,fp);	//ÿֻȡһֽڣ
			}
		}
	}
	fclose(fp);   //رļ
	return imgdata;
}

/****************************************************************************/
/*     bmpҶȴͼ                ֵͷļ͡     */
/****************************************************************************/
jicheng to_gray(bmpfile_header_t *pbf,bmpfile_dib_header_t *pbi,unsigned char **imgdata)
{
	FILE* fp;            //ļָ
	bmpfile_header_t bf; //BMPļͷṹ
	bmpfile_dib_header_t bi; //BMPϢͷṹ
	bmp_color_table_t *ipRGB;	     //Ҷͼĵɫ 256
	//bmpfile_header_t *CJC;
	unsigned char *gray_data = NULL;//
	long i,j;
	long newlinebytes = 0;
	long imagsize = 0;
	long line_start = 0;

	//һļдҶͼ
	if ((fp=fopen("bmp_gray.bmp","wb")) == NULL)
	{
		printf("Open file mybmp.bmp error!");
		exit(0);
	}
#ifdef _DEBUG_BMP
	printf("\nҶͼļ bmp_gray.bmp 򿪳ɹ\n");
#endif

	newlinebytes = ( (pbi->image_width+ 3)/4 ) * 4;     //Ҷͼÿֽ4
	imagsize = newlinebytes * pbi->image_height;         //ҶͼС
	memcpy( &bi, pbi, sizeof(bmpfile_dib_header_t) );  //λͼϢͷ
	bi.bits_per_pixel = 8;							   //Ҷͼļ
	bi.image_size = imagsize;				       //ҶͼС
	bf.signature[1]=0x4D;
	bf.signature[0]=0x42;
	bf.reserved1 = bf.reserved2 = 0;
	bf.bitmap_offset = sizeof(bf) + sizeof(bmpfile_dib_header_t) + 256*sizeof(bmp_color_table_t);
	bf.file_size = pbf->bitmap_offset + imagsize;      //ҶͼļС

	fwrite(&bf, sizeof(bmpfile_header_t),1,fp);   //дҶͼļͷ
	fwrite(&bi, sizeof(bmpfile_dib_header_t),1,fp);   //дҶͼϢͷ

#ifdef _DEBUG_BMP
	printf("ҶͼļͷϢͷдɣ\n");
#endif
	//ɫ壬ʼ дҶͼļ
	ipRGB = (bmp_color_table_t *)malloc(256 * sizeof(bmp_color_table_t));
	for ( i = 0; i < 256; i++ )
		ipRGB[i].red = ipRGB[i].green = ipRGB[i].blue = (unsigned char)i;
    fwrite(ipRGB,sizeof(bmp_color_table_t),256,fp);		  //дҶͼĵɫ
#ifdef _DEBUG_BMP
	printf("Ҷͼɫдɣ\n");
#endif
	gray_data = (unsigned char*)malloc(sizeof(unsigned char) * imagsize);
	for ( i=0; i < pbi->image_height; i++ )
	{
		line_start = newlinebytes * i;      //ά鷽ʽiеλ
		for ( j = 0; j < newlinebytes; j++ ) //Ҷͼֵ
		{
			gray_data[line_start + j]= (int)( (float)imgdata[i][3 * j] * 0.114 + \
				(float)imgdata[i][3 * j + 1] * 0.587 + \
				(float)imgdata[i][3 * j + 2] * 0.299 );
		}
	}
    fwrite(gray_data, imagsize, 1, fp);	  //дҶͼͼ
#ifdef _DEBUG_BMP
	printf("Ҷͼдɣ\n");
#endif
	fclose(fp);
	return myTRUE;
}


