#ifndef _GGHWCFG_H
#define _GGHWCFG_H
/******************************************************************************
 * FILE PURPOSE: HAL build time configuration file
 ******************************************************************************
 * FILE NAME: gghwcfg.h
 *
 * DESCRIPTION: Build time configuration for hardware related setting
 *
 * TABS: None
 *
 * Copywrite (C) 2002, Texas Instruments Incorporated.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#define HAL_C64X 64

/* CPU CORE TYPE */
#define HAL_CONFIG_CPU_CORE             HAL_C64X

/* Device type. Used in ggcfg.c to setup secondary core boot */
#define GG_C6608

/*******************************************************************************
 * MAC configuration
 *******************************************************************************/
#define GG_GMAC_HEAP_BUF_ALIGN   3   /* 32 bit alignments */

/*****************************************************************************
 * Cache build time configuration
 *****************************************************************************/
#define HAL_L1P_CACHE_0K               0x0
#define HAL_L1P_CACHE_4K               0x1
#define HAL_L1P_CACHE_8K               0x2
#define HAL_L1P_CACHE_16K              0x3
#define HAL_L1P_CACHE_32K              0x4

#define HAL_L1P_CACHE_MODE             HAL_L1P_CACHE_32K

#define HAL_L1D_CACHE_0K               0x0
#define HAL_L1D_CACHE_4K               0x1
#define HAL_L1D_CACHE_8K               0x2
#define HAL_L1D_CACHE_16K              0x3
#define HAL_L1D_CACHE_32K              0x4

#define HAL_L1D_CACHE_MODE             HAL_L1D_CACHE_32K

#define HAL_L2_CACHE_0K                0x0
#define HAL_L2_CACHE_32K               0x1
#define HAL_L2_CACHE_64K               0x2
#define HAL_L2_CACHE_128K              0x3
#define HAL_L2_CACHE_256K              0x4
#define HAL_L2_CACHE_512K              0x5
#define HAL_L2_CACHE_1024K             0x6   /* Not supported at Shannon */
#define HAL_L2_CACHE_ALL               0x7   /* The same as 512K at Shannon */

#define HAL_L2_CACHE_MODE              HAL_L2_CACHE_64K

/* External memory cache configuration */
/* There are  256 MAR registers. Instead of specifying them all, a -1 terminated list of
 * mar registers and a corresponding list of values is specified. Any values not
 * specified are left unchanged.
 *
 *  A value of 0xD indicates cacheable and pre-fetch, 0x4 non-cachable and no-pre-fetch
 *
 *  MAR: 0x80000000 - 0x8fffffff
 */
/* HAL_MAR_REGS and HAL_MAR_VALS: for Video Application are defined in ggmemdef.bec. These can be
   different based on active build among gg_supported_builds */

/* HAL_MAR_DYNAMIC_CFG is used in hal\csl\cache\c64x\tomahawk\icache.c */
#define HAL_MAR_DYNAMIC_CFG

/******************************************************************************
 *                     External Memory Setup                                  *
 ******************************************************************************
 * The structures used to configure the XMC, SES, and SMS MPAX units is defined
 * in hal/csl/mpax/c64x/shannon/mpaxutil.h.
 *
 * The memory's physical addresses are 36 bits where the DDR is at
 * 0x8 0000 0000.
 *
 * There are 3 relevant MPAX units:
 * XMC (Located in the XMC which is part of each corepac)
 *   - this maps 32-bit addresses generated by the CPU into 36 bit physical
 *     addresses used by the memory.
 * SES, SMS: (Located in the MSMC).
 *   - this maps 32-bit addresses generated by the other masters (peripherals,
 *     DMAs) into 36 bit physical memory addreses.
 *
 * On a Shannon device, there are a total of 10 MPAX units.  Each corepac has
 * one in its XMC, and the MSMC has one SMS and one SES.  All 3 must be
 * considered when interfacing with peripherals or other cores.
 *
 * The details of the XMC, SES, and SMS mpax units are in the device
 * documentation.
 *
 * IMPORTANT: the segments "execute" in reverse order (row 15 to row 0).
 * The first match wins.  The tables in HAL_MPAX_*_TBL execute in
 * forward order.  Consider both orders to make sure that the program
 * setting the MPAX table doesn't block its own access.  Low numbers
 * like 0/1 are "catch all" entries.
 *
 * The strategy below is to avoid the reset defaults and explicitly
 * program all the registers
 */


/* ======================= HAL_MPAX_XMC_TBL ===================================
 * The value of HAL_MPAX_XMC_TBL below creates the following configuration of
 * the memory for each CPU.
 *
 * Index 0: Force back to reset value to see low 2GB of address space
 * { 0,  0, 0, 0, 0x00000000,                0x0, 0x00000000, 31, 0x77}
 *
 * Index 1: Catch all for DDR.
 * Initial value to enable all of DDR
 * { 1,  0, 0, 0, 0x80000000,                0x8, 0x00000000, 31, 0x77}
 *
 * Index 2: Access to DDR MMRs
 * { 2,  0, 0, 0, CSL_DDR3_EMIF_CONFIG_REGS, 0x1, 0x00000000, 12, 0x77}
 *
 * Index 3: Map 0x0C300000 to 0xFC300000
 * { 3,  0, 0, 0, 0xFC300000,                0x0, 0x0C300000, 20, 0x77}
 * The logical addresses created are
 *   0xFC30 0000 to
 *   0xFC3F FFFF
 * shared by all cores (1MB = 2^20)
 *
 * The cachebilty of the memory mapped by the MPAX is independently controlled
 * by the MAR registers which are defined in HAL_MAR_REGS and HAL_MAR_VALS.
 * Each MAR covers 16MB.
 *
 * ======================= HAL_MPAX_XMC_TBL ==================================*/
#define HAL_MPAX_XMC_TBL                                                    \
    {                                                                       \
      { 0,  0, 0, 0, 0x00000000,                0x0, 0x00000000, 31, 0x77}, \
      { 1,  0, 0, 0, 0x80000000,                0x8, 0x00000000, 31, 0x77}, \
      { 2,  0, 0, 0, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      { 3,  0, 0, 0, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      { 4,  0, 0, 0, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      { 5,  0, 0, 0, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      { 6,  0, 0, 0, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      { 7,  0, 0, 0, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      { 8,  0, 0, 0, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      { 9,  0, 0, 0, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      {10,  0, 0, 0, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      {11,  0, 0, 0, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      {12,  0, 0, 0, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      {13,  0, 0, 0, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      {14,  0, 0, 0, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      {15,  0, 0, 0, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      { 2,  0, 0, 0, CSL_DDR3_EMIF_CONFIG_REGS, 0x1, 0x00000000, 12, 0x77}  \
    }

/* ======================= HAL_MPAX_SES_TBL ===================================
 * The value of HAL_MPAX_SES_TBL below creates the following configuration of
 * the memory for each CPU.
 *
 * Index 0: Default direct map to all DDR (allowed)
 * {0, 16, 0, 0x80000000,                0x8, 0x00000000, 31, 0x77}, \
 *
 * ======================= HAL_MPAX_SES_TBL ==================================*/
#define HAL_MPAX_SES_TBL                                                   \
    {                                                                      \
      {0, 0, 0, 15, 0x80000000,                0x8, 0x00000000, 31, 0x77}, \
      {1, 0, 0, 15, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      {2, 0, 0, 15, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      {3, 0, 0, 15, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      {4, 0, 0, 15, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      {5, 0, 0, 15, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      {6, 0, 0, 15, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      {7, 0, 0, 15, 0x00000000,                0x0, 0x00000000, 0,  0x00}  \
    }

/* ======================= HAL_MPAX_SMS_TBL ===================================
 * The value of HAL_MPAX_SMS_TBL below creates the following configuration of
 * the memory for each CPU.
 *
 * Index 0: Default direct map to all MSMC RAM (allowed)
 * {0, 16, 0, 0x0C000000,                0x0, 0x0C000000, 24, 0x77}
 * ======================= HAL_MPAX_SMS_TBL ==================================*/

#define HAL_MPAX_SMS_TBL                                                   \
    {                                                                      \
      {0, 0, 0, 15, 0x0C000000,                0x0, 0x0C000000, 24, 0x77}, \
      {1, 0, 0, 15, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      {2, 0, 0, 15, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      {3, 0, 0, 15, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      {4, 0, 0, 15, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      {5, 0, 0, 15, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      {6, 0, 0, 15, 0x00000000,                0x0, 0x00000000, 0,  0x00}, \
      {7, 0, 0, 15, 0x00000000,                0x0, 0x00000000, 0,  0x00}  \
    }

/*******************************************************************************
 * Interrupt Configuration
 *******************************************************************************/

/* Vector 4 unassigned */

/* Vector 5 unassigned */

/* Vector 6 unassigned */

/* Vector 7 unassigned */

/* Vector 8 unassigned */

/* Vector 9 unassigned */

/* Vector 10 unassigned */

/* Vector 11 unassigned */

/* Vector 12 unassigned */

/* Vector 13 unassigned */

/* Vector 14 unassigned */

/* Vector 15 assigned for timer 8*/
#define GG_HWCFG_VEC15_ENABLED
#define CSL_DEVICE_ISR_TIMER_8  66
#define GG_HWCFG_VEC15_SOURCE   CSL_DEVICE_ISR_TIMER_8


/**********************************************************************************
 * EDMA configuration
 **********************************************************************************/
#define GG_DMA_INSTANCE_ARRAY       {1, 1, 1, 1, 2, 2, 2, 2}   /* Use EDMA instance 1 for core 0-3, instance 2 for core 4-7  */
#define GG_DMA_QUEUE_ARRAY          {0, 0, 0, 0, 0, 0, 0, 0}   /* Use EDMA TC (Queue) 0 for all the cores */

#endif

