#ifndef _GGSWCFG_H
#define _GGSWCFG_H
/******************************************************************************
 * FILE PURPOSE: Golden Gateway Software Specific Configuration
 ******************************************************************************
 * FILE NAME: ggswcfg.h
 *
 * DESCRIPTION: Template file for defining options available for a specific
 *              build of Golden Gateway DSP software.
 *
 *              Simply comment out those options not required for your specific
 *              build, and change "##" to "#" for those options that are
 *              required in order to tailor this file.
 *
 *
 * (C) Copyright 2003, Texas Instruments Incorporated.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

/* System level header files */
#include "types.h"

#ifndef max
#define max(x,y) ((x) > (y) ? (x):(y))
#endif

/******************************************************************/
/* Miscellaneous parameters                                       */
/******************************************************************/
/* Number of channels per DSP core */
/* GG_MAX_NUM_CHANNELS is provided by the makegg via mkrel/makefile */
#define GG_MAX_AUX_PCM_CHANNELS 0

/******************************************************************/
/* Network encap                                                  */
/******************************************************************/
#define GG_INCLUDE_NET_ENCAP
#define GG_INCLUDE_NEU_UDPIP       /* Only Required for RTP */
#define GG_INCLUDE_NEU_ETHERNET    /* Only Required for RTP */

#define GG_NV_ECO_BUFF_NUM       4  /* MSG + BULK + HLT + TRACE */

#define GG_SHARED_MEM_DATA_ALLOCATION

/******************************************************************/
/* Buffered Serial Port (BSP) parameters                          */
/******************************************************************/
#define GG_TDM_PORTS_USED    0

#define GG_HAL_HEAP_START_ADDR       ((void*)0x86B950)
#define GG_HAL_HEAP_END_ADDR         ((void*)0x86CB10)


/* The below lengths are in dprwords, and tells how many messages (dprwords
   can be allocated in a FIFO  */
#define GG_NDU_MSG_NORMAL_FIFO_L          8
#define GG_NDU_MSG_HIGH_FIFO_L            0
#define GG_NDU_MSG_LOW_FIFO_L             0

/* Physical utopia device requirements */
#define GG_UTOPIA_PORTS_USED              0
#define GG_GMAC_PORTS_USED                0

#define GG_GMAC_TX_BUFSIZE_WORDS         160,320   /* Comma seperated list of tx buffer sizes */
#define GG_GMAC_RX_BUFSIZE_WORDS         160,320   /* Comma seperated list of rx buffer sizes */
#define GG_GMAC_RX_ASSEMSIZE_WORDS       1600,1600  /* Comma seperated list of rx assembly sizes */

#define GG_NEU_UDP_CORE_ID_MASK   0x001C
#define GG_INCLUDE_NEU_PORTMAP  1
#define GG_NEU_MAX_PORTMAP_CHANNELS (GG_MAX_NUM_CHANNELS+3)

/******************************************************************/
/* Health check feature                                           */
/******************************************************************/
#define GG_INCLUDE_HEALTH_CHECK
#define GG_INCLUDE_KEEP_ALIVE_NDU    /* enable keep alive cells   */

/**************************************************************************
 * CPPI and QM buffers
 **************************************************************************/
/* The following is configuration for Tx/Rx control and packet linked buffers.
   The total number of buffers per core must be 2^x (e.g.,128, 256,...).
   The size needs to be multiple of Cache line size (CACHE_L2_LINESIZE=128)  */
/* Rx control */
#define GG_QM_RX_LINKED_BUF_1_SIZE            384
#define GG_QM_RX_LINKED_BUF_1_NBUFS_PER_CORE  10
#define GG_QM_RX_LINKED_BUF_1_NBUFS           (GG_QM_RX_LINKED_BUF_1_NBUFS_PER_CORE*CPU_NCORES)

/* Tx control */
#define GG_QM_TX_LINKED_BUF_1_SIZE            384
#define GG_QM_TX_LINKED_BUF_1_NBUFS_PER_CORE  10
#define GG_QM_TX_LINKED_BUF_1_NBUFS           (GG_QM_TX_LINKED_BUF_1_NBUFS_PER_CORE*CPU_NCORES)

/* Rx packet */
#define GG_QM_RX_LINKED_BUF_2_SIZE            (((1516+127)/128)*128)
#define GG_QM_RX_LINKED_BUF_2_NBUFS_PER_CORE  54
#define GG_QM_RX_LINKED_BUF_2_NBUFS           (GG_QM_RX_LINKED_BUF_2_NBUFS_PER_CORE*CPU_NCORES)

/* Tx packet */
#define GG_QM_TX_LINKED_BUF_2_SIZE            (((1516+127)/128)*128)
#define GG_QM_TX_LINKED_BUF_2_NBUFS_PER_CORE  54
#define GG_QM_TX_LINKED_BUF_2_NBUFS           (GG_QM_TX_LINKED_BUF_2_NBUFS_PER_CORE*CPU_NCORES)

/* QM */
#define GG_QM_NUM_DESCS_PER_CORE              (GG_QM_RX_LINKED_BUF_1_NBUFS_PER_CORE + \
                                               GG_QM_TX_LINKED_BUF_1_NBUFS_PER_CORE + \
                                               GG_QM_RX_LINKED_BUF_2_NBUFS_PER_CORE + \
                                               GG_QM_TX_LINKED_BUF_2_NBUFS_PER_CORE) /* Would need to be  2^x */
#define GG_QM_NUM_DESCS                       (GG_QM_NUM_DESCS_PER_CORE*CPU_NCORES)
#define GG_QM_DESC_SIZE                       128

/******************************************************************/
/* Internal ECO related #define(s) are created from features.     */
/* DO NOT MOVE THESE DIRECTIVES FROM THE END OF THIS FILE OR YOU  */
/* WILL DEFEAT THEIR PURPOSE!!                                    */
/******************************************************************/
#include "ggfeature2eco.h"
/* DSP Bitmap configuration */
#include "ggbitmap.h"

#endif  /* _GGSWCFG_H */

/* nothing past this point */

