/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

/******************************************************************************
 * Linker.cmd -  COMMAND FILE FOR LINKING VIDEO INFRASTRUCTURE DEMO APP
 *               ON C6678
/*****************************************************************************
 * All symbols in the command file are specified in their COFF format (which
 * has an extra _ compared to C).  The following (forward looking) aliases
 * allow linking for EABI (which doesn't add the leading _ in C).  The aliases
 * are defined for both EABI and COFF so the same command file can be used
 * for either.  One of the pair simply doesn't get used.
 *
 * Symbols defined in the same context don't need aliases at all.  This
 * means symbols defined in ASM can be used in ASM without aliases; likewise
 * symbols defined in C can be used in C without aliases.
 ****************************************************************************/
ggvmmbuf                       = _ggvmmbuf;
_lcf_cppi_drv_start            = __lcf_cppi_drv_start;
_lcf_cppi_drv_end              = __lcf_cppi_drv_end;
_lcf_qmss_drv_start            = __lcf_qmss_drv_start;
_lcf_qmss_drv_end              = __lcf_qmss_drv_end;
_lcf_pktlib_local_start        = __lcf_pktlib_local_start;
_lcf_pktlib_local_end          = __lcf_pktlib_local_end;
_lcf_pktlib_global_start       = __lcf_pktlib_global_start;
_lcf_pktlib_global_end         = __lcf_pktlib_global_end;

/*****************************************************************************
 * END of EABI/COFF aliases 
 *****************************************************************************/

-u=dsiuNwGlobInitConsts
--symbol_map dsiuNwGlobInit=dsiuNwGlobInitConsts

/******************************END OF FILE INCLUSION*************************/

/* Default flags */
-c                                         /* ROM autoinitialization module */
-a                                         /* LINK USING C CONVENTIONS      */

--generate_dead_funcs_list
--undef_sym=siuVctDiagAppMem

-x

/* SPECIFY THE SYSTEM MEMORY MAP */

MEMORY
{      
  /**************************************************************************
   *                 C6678 MEMORY MAP
   *
   * Local L2:  0x0080_0000
   *            0x0087_FFFF  (512K)
   *
   * MSMC SRAM: 0x0C00_0000
   *            0x0C3F_FFFF  (4M)
   *
   * DDR:       0x8000_0000
   *            0x9FFF_FFFF  (512M) 
   *
   *            
   ***************************************************************************/
   /************ Local L2: 0x00800000-0x0087FFFF *************/
  PAGE 0:
    /*LL2               : origin = 0x800000,   length = 0x6B000*/ /* Remeber this is defined in the provided custom C6678 platform */
    DATA_SCRATCH        : origin = 0x86B000,   length = 0x00620   /* Remember to change ggmemmap.h */
    MSG_FIFOS           : origin = 0x86B620,   length = 0x00010   /* Remember to change ggmemmap.h */    
    DATA_GMP0           : origin = 0x86B630,   length = 0x00320   /* Remember to change ggmemmap.h */
    DATA_HALHEAP        : origin = 0x86B950,   length = 0x011C0   /* Remember to change ggmemmap.h & ggswcfg.h; */
    GMAC_NEU_BUFFERS    : origin = 0x86CB10,   length = 0x00500   /* Remember to change ggmemmap.h */
    NEU_SCRATCH         : origin = 0x86D010,   length = 0x00800   /* Remember to change ggmemmap.h */
    DATA_CH1            : origin = 0x86D810,   length = 0x00CC0   /* Remember to change ggmemmap.h */
    DATA_CH2            : origin = 0x86E4D0,   length = 0x00CC0   /* Remember to change ggmemmap.h */
    LL2_HOLE            : origin = 0x86F190,   length = 0x00E70
    /*LL2_CACHE         : origin = 0x870000,   length = 0x10000*/ /* 64 kb cache */

   /************ MSMC SRAM: 0xC000000-0xC3FFFFF *************/
  PAGE 0:
    DIAG_APP            : origin = 0xC000000, length = 0x000100
    /*MSMC              : origin = 0xC000100, length = 0x3FFF00*/ /* Remeber this is defined in the provided custom C6678 platform */
  PAGE 2:
    DIAG_APP_VCT        : origin = 0xC000000, length = 0x000100   /* Alias of DIAG_APP to populate diagAppMem data */
    
   /************ External DDR:  0x80000000-0x9FFFFFFF *************/
  PAGE 0:
    /*DDR               : origin = 0x80000000,length = 0x20000000*/ /* Remeber this is defined in the provided custom C6678 platform */

   /************ Dummy PCIe (x86) Shared Memory (0x60000000-0x60FFFFFF) *************/
  PAGE 0:
    DUMMY_X86           : origin = 0x60000000, length = 0x10000000   
}

/* SPECIFY THE SECTIONS ALLOCATION INTO MEMORY */

SECTIONS
{   
/* Sections in Local L2 */
  .ipc_context > LL2 PAGE 0
  .gg_nonshared_bufs > LL2 PAGE 0
  .testCodecIntMem > LL2 PAGE 0
  .far_siuinst: fill = 0x00 >   LL2
  {
    *(.siuinst)
  } PAGE 0

  .pktLibLocalMemory > LL2 START(__lcf_pktlib_local_start)  END(__lcf_pktlib_local_end) PAGE 0
  .boot_config > LL2 PAGE 0 type = NOINIT fill = 0xABCDABCD

  .l2HostSymbols > LL2 PAGE 0
  .shared_mem_L2 > LL2 PAGE 0 fill = 0x00

  .gg_scratch      >  DATA_SCRATCH   PAGE 0
  .gg_ndu_msg_fifos>  MSG_FIFOS      PAGE 0
  .gg_gmp0         >  DATA_GMP0      PAGE 0    
  .gg_halheap      >  DATA_HALHEAP   PAGE 0
  .gg_neu_scratch  >  NEU_SCRATCH    PAGE 0
  .gg_gmndu_neu    >  GMAC_NEU_BUFFERS PAGE 0
  .gg_ch1     >  DATA_CH1 PAGE 0
  .gg_ch2     >  DATA_CH2 PAGE 0

/* Sections in MSMC */
  .diagApp          > DIAG_APP PAGE 0
  .siuVctDiagAppMem > DIAG_APP_VCT PAGE 2
  .pktLibSharedMemory > MSMC START(__lcf_pktlib_global_start) END(__lcf_pktlib_global_end) PAGE 0 type = NOINIT

  .cabactables > MSMC  PAGE 0
  .constTables > MSMC  PAGE 0
  .qpTable_shared_dtcm2 > MSMC  PAGE 0

  .shared_mem_SL2           > MSMC PAGE 0 fill = 0x00
  .shared_mem_SL2_uncached  > MSMC PAGE 0 fill = 0x00

  .switch >  MSMC  PAGE 0

  .text >> MSMC
  {
    * (.initProg)
    * (.controlProg)
    * (.pkt2tdmProg)
    * (.tdm2pktProg)
    * (.tdm2pktpkt2tdmProg)
  } PAGE 0

  .const_vmmcomp   > DDR
  {
      _ggvmmbuf = .; /* Not used unless compression is used -- placeholder */
  } PAGE 0
  .const  > DDR
  {
    *(.const)
  } PAGE 0

  .cinit  >  DDR
  {
    __core_cinit = .;
  } PAGE 0

/* Sections in DDR */
  .siuNumCoreInit > DDR PAGE 0
  .siuVctGmpSim > DDR PAGE 0
  .siuVctPktHeader >  DDR  PAGE 0
  .siuVctParseBuf > DDR PAGE 0
  .siuVctFileReadBuffer > DDR PAGE 0
  .siuVctFileWriteBuffer > DDR PAGE 0
  .siuVctParseMap > DDR PAGE 0

  .codec_input  : align(0x100) > DDR PAGE 0
  .codec_output : align(0x100) > DDR PAGE 0
  .transcode_yuv > DDR PAGE 0

  .testCodecExtMem > DDR PAGE 0
  .testCodecExtMemSecond> DDR PAGE 0

  /* NWAL related sections */
  .dsiuNwGlobContext  > DDR   PAGE 0
  .nwalInstMem   > DDR PAGE 0 type = NOINIT
  .nwalHandleMem > DDR PAGE 0 type = NOINIT
  .paBuf0        > DDR PAGE 0 type = NOINIT
  .paBuf1        > DDR PAGE 0 type = NOINIT
  .paBuf2        > DDR PAGE 0 type = NOINIT
  .QMemDescRam > DDR PAGE 0 type = NOINIT    
  .cppiMemRXLinkRamQ1 > DDR PAGE 0 type = NOINIT
  .cppiMemTXLinkRamQ1 > DDR PAGE 0 type = NOINIT
  .cppiMemRXLinkRamQ2 > DDR PAGE 0 type = NOINIT
  .cppiMemTXLinkRamQ2 > DDR PAGE 0 type = NOINIT
  .cppi               > DDR START(__lcf_cppi_drv_start) END(__lcf_cppi_drv_end) PAGE 0 type = NOINIT
  .qmss               > DDR START(__lcf_qmss_drv_start) END(__lcf_qmss_drv_end) PAGE 0 type = NOINIT

  /* Fill the GLOB_INIT with fixed random value. Should match to DSIU_NW_GLOB_INIT_STATE_MAGIC1 */
  .dsiuNwGlobInit     > DDR  PAGE 0  fill = 0x167eb0e7

  .dbgPrintfCached               > DDR      PAGE 0 fill = 0x00
  .shared_mem_DDR_cached         > DDR      PAGE 0 fill = 0x00
  .shared_mem_C2C_cached         > DDR      PAGE 0 fill = 0x00
  .shared_mem_C2C_uncached       > DDR      PAGE 0 fill = 0x00
  .shared_mem_DDR_uncached       > DDR      PAGE 0 fill = 0x00
  
  .shared_mem_x86                > DUMMY_X86      PAGE 0 type = NOINIT
  .siuVidMcStats                 > DUMMY_X86      PAGE 0 type = NOINIT 
  .x86SharedMemory               > DUMMY_X86      PAGE 0 type = NOINIT

}
/* nothing past this point */
