/****************************************************************************
 * FILE PURPOSE: Allocation tables with addresses for memory buffers and heap
 ****************************************************************************
 * FILE NAME:  ggMBuf.bec
 *
 * DESCRIPTION:  This file contains the allocation table for all ECO memory
 *               buffers and voice/FAX heap for each channel. The allocation
 *               tables are constructed using the data structures defined in
 *               ggmbuf.h and the memory map data in ggmemmap.h.  The
 *               allocation tables are global variables.  It is crucial that
 *               SIU checks the number of buffers for each ECO in the
 *               memory allocation table with the number actually requested
 *               by the ECO.  As a rule, when the buffer address is NULL SIU
 *               allocations the memory buffer from the heap.
 *
 * TABS: NONE
 *
 * $Id: ggmbuf.c 1.00 2002/05/12 K Aravindhan Exp $
 *
 * REVISION HISTORY:
 *
 * $Log: ggmbuf.c $
 *
 * (C) Copyright 2002, Texas Instruments
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#include "ggChBufDesc.h"
#include "ggmemmap.h"
#include "ggcfg.h"
#include "ggswcfg.h"

const ggchBuffDesc_t ggchBuffDesc[GG_MAX_NUM_SLOTS]=
{
  /* NUMSL is passed through mkrel/makefile and is visible to blockexpn.pl.
   * It is used by makegg to define GG_MAX_NUM_CHANNELS 
   */
  /* Expanding $ch = 1 */

  /*=======================================================================*/
  /* Channel 1 */
  /*=======================================================================*/
#ifdef GG_INCLUDE_RTP
  GG_NUM_RCU_BUFF,                                                   /* RCU Buffers */

  (word *)GG_RCU_B0_C1_START,         GG_RCU_B0_C1_L,          /* C1 B0 */
  (word *)GG_RCU_B1_C1_START,         GG_RCU_B1_C1_L,          /* C1 B1 */
  (word *)GG_RCU_B2_C1_START,         GG_RCU_B2_C1_L,          /* C1 B2 */
#endif

#ifdef GG_INCLUDE_NET_ENCAP

  GG_NUM_NEU_BUFF,                                                   /* NEU Buffers */
#ifndef GG_NEU_C1_HEAP_ALLOC
  (word *)GG_NEU_B0_C1_START,         GG_NEU_B0_C1_L,          /* C1 B0 */
  (word *)GG_NEU_B1_C1_START,         GG_NEU_B1_C1_L,          /* C1 B1 */
  (word *)GG_NEU_B2_C1_START,         GG_NEU_B2_C1_L,          /* C1 B2 */
  (word *)GG_NEU_B3_C1_START,         GG_NEU_B3_C1_L,          /* C1 B3 */
  (word *)GG_NEU_B4_C1_START,         GG_NEU_B4_C1_L,          /* C1 B4 */
#else
  0,0, 0,0, 0,0, 0,0, 0,0,
#endif
#endif

  GG_NUM_TFTP_BUFF,                                           /* TFTP Buffers */
#ifndef GG_TFTP_C1_HEAP_ALLOC
  (word *)GG_TFTP_B0_C1_START,        GG_TFTP_B0_C1_L,  /* C1 B0 */
#else
  0,0,
#endif

  /* End expansion $ch = 1 */
/* Expanding $ch = 2 */

  /*=======================================================================*/
  /* Channel 2 */
  /*=======================================================================*/
#ifdef GG_INCLUDE_RTP
  GG_NUM_RCU_BUFF,                                                   /* RCU Buffers */

  (word *)GG_RCU_B0_C2_START,         GG_RCU_B0_C2_L,          /* C2 B0 */
  (word *)GG_RCU_B1_C2_START,         GG_RCU_B1_C2_L,          /* C2 B1 */
  (word *)GG_RCU_B2_C2_START,         GG_RCU_B2_C2_L,          /* C2 B2 */
#endif

#ifdef GG_INCLUDE_NET_ENCAP

  GG_NUM_NEU_BUFF,                                                   /* NEU Buffers */
#ifndef GG_NEU_C2_HEAP_ALLOC
  (word *)GG_NEU_B0_C2_START,         GG_NEU_B0_C2_L,          /* C2 B0 */
  (word *)GG_NEU_B1_C2_START,         GG_NEU_B1_C2_L,          /* C2 B1 */
  (word *)GG_NEU_B2_C2_START,         GG_NEU_B2_C2_L,          /* C2 B2 */
  (word *)GG_NEU_B3_C2_START,         GG_NEU_B3_C2_L,          /* C2 B3 */
  (word *)GG_NEU_B4_C2_START,         GG_NEU_B4_C2_L,          /* C2 B4 */
#else
  0,0, 0,0, 0,0, 0,0, 0,0,
#endif
#endif

  GG_NUM_TFTP_BUFF,                                           /* TFTP Buffers */
#ifndef GG_TFTP_C2_HEAP_ALLOC
  (word *)GG_TFTP_B0_C2_START,        GG_TFTP_B0_C2_L,  /* C2 B0 */
#else
  0,0,
#endif

  /* End expansion $ch = 2 */
 
};

/* nothing past this point */
