/****************************************************************************
 * FILE PURPOSE: Storage of internal memory buffers
 ****************************************************************************
 * FILE NAME:  ggmemdef.c
 *
 * DESCRIPTION: This file is used to create sections in the linker file
 *              for simulating memory map defined in ggmemmap.h
 *
 * TABS: NONE
 *
 * (C) Copyright 2003, Texas Instruments Incorporated.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#include "ggswcfg.h"
#include "gghwcfg.h"
#include "ggmemmap.h"
#include "ggmbuf.h"
#include "ggcfg.h"
#include "diagapp.h"

/****************************************************************************
 * Define memory buffer section names
 ***************************************************************************/
#pragma DATA_SECTION(gg_scratch, ".gg_scratch")
  char gg_scratch[GG_COMMON_SCRATCH_USED];

#pragma DATA_SECTION(gg_halheap, ".gg_halheap")
  char gg_halheap[GG_HAL_HEAP_END - GG_HAL_HEAP_START];

#pragma DATA_SECTION(gg_ndu_msg_fifos, ".gg_ndu_msg_fifos")
  char gg_ndu_msg_fifos[GG_GMNDU_MSG_FIFOS_USED];

#pragma DATA_SECTION(gg_neu_scratch, ".gg_neu_scratch");
  char gg_neu_scratch[GG_NEU_SCRATCH_USED];

#pragma DATA_SECTION(gg_gmndu_neu, ".gg_gmndu_neu");
  char gg_gmndu_neu[GG_GMNDU_NEU_USED];

#pragma DATA_SECTION(gg_ch1_buf, ".gg_ch1")
  char gg_ch1_buf[GG_CH1_USED];
#pragma DATA_SECTION(gg_ch2_buf, ".gg_ch2")
  char gg_ch2_buf[GG_CH2_USED];

#pragma DATA_SECTION(gg_gmp0, ".gg_gmp0")
  char gg_gmp0[GG_DATA_GMP0_END - GG_DATA_GMP0_START];

#pragma DATA_SECTION(diagAppMem, ".diagApp")
diagApp_t diagAppMem;

#define GG_NULL_POOL_BUILD0 {                    \
    /* Range starting address */                 \
    (word *)0,                                   \
    /* Range length */                           \
    (word *)0,                                   \
    /* Chunk Size */                             \
    (tulong)0                                    \
}

#define GG_NULL_SCRATCH_BUILD0 {                 \
    /* Range starting address */                 \
    (word *)0,                                   \
    /* Range length */                           \
    (word *)0                                    \
}

/* Build definitions */
vigdkMemoryContext_t gg_supported_builds[] =
{
   /* QCIF/CIF Build */
   {
     GG_NULL_POOL_BUILD0,
     GG_NULL_POOL_BUILD0,
     GG_NULL_POOL_BUILD0,
     GG_NULL_POOL_BUILD0,
     GG_NULL_POOL_BUILD0,
     GG_NULL_POOL_BUILD0,
     GG_NULL_POOL_BUILD0,
     GG_NULL_POOL_BUILD0,
     GG_NULL_POOL_BUILD0,
     GG_NULL_POOL_BUILD0,
     GG_NULL_POOL_BUILD0,
     GG_NULL_POOL_BUILD0,
     GG_NULL_SCRATCH_BUILD0,
     GG_NULL_SCRATCH_BUILD0,
     GG_NULL_SCRATCH_BUILD0,
     GG_NULL_SCRATCH_BUILD0,
     GG_NULL_SCRATCH_BUILD0,
     { 0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F, 
	   0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F, 
	   0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF, 
	   0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,
	   0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0xFC, -1 },
     {  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD, 
	    0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,
	    0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD, 
	    0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,  0xD,
	    0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4,  0x4, 0xD, 0}
   }
};

/* nothing past this point */
