/****************************************************************************
 * FILE PURPOSE: Allocation tables with addresses for memory buffers and heap
 ****************************************************************************
 * FILE NAME:  ggmheap.bec
 *
 * DESCRIPTION:  This file contains the allocation table for all ECO memory
 *               heaps and video heap for each channel.
 *
 * TABS: NONE
 *
 * (C) Copyright 2003, Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#include "ggmbuf.h"
#include "ggmemmap.h"
#include "ggcfg.h"
#include "ggswcfg.h"
#include "ggChBufDesc.h"

word * relocQualifier ggchVideoHeapStartAddr[GG_MAX_NUM_SLOTS+GG_MAX_AUX_PCM_CHANNELS] =
{                      
   /* Expanding $ch = 1 */
   (word *)GG_VIDEO_HEAP_C1_START,      /* Channel 1 Video memory heap */
   /* End expansion $ch = 1 */
/* Expanding $ch = 2 */
   (word *)GG_VIDEO_HEAP_C2_START,      /* Channel 2 Video memory heap */
   /* End expansion $ch = 2 */
};
relocQualifier tuint ggchVideoHeapSize = GG_VIDEO_HEAP_L;

relocQualifier tuint ggchVideoAuxHeapSize =  GG_VIDEO_AUX_HEAP_L;

relocQualifier gghalHeapDesc_t halHeapDesc =
{
  (word *)GG_HAL_HEAP_START,(word *)GG_HAL_HEAP_END, GG_HAL_HEAP_L
};

#ifdef GG_MEM_BUF_RELOC 
 relocQualifier tulong ggmbufStartAddrInPRAM = (tulong)ggchBuffDesc;
#else
 extern word ggvmmbuf[];
 relocQualifier tulong ggmbufStartAddrInPRAM = (tulong)ggvmmbuf;
#endif
relocQualifier tint   PrGGMBufScratchSize   = PRGGMBUF_SCRATCH_L;

/****************************************************************************
 * SIU non-bss instance buffers on channel space
 ***************************************************************************/
#ifndef SIU_MULTICORE_SHARED_DATA
relocQualifier 
#endif

#pragma DATA_SECTION (gg_siuheap_inst, ".gg_siuheap_inst")
word *gg_siuheap_inst[GG_MAX_NUM_SLOTS] = {
                     
  /* Expanding $ch = 1 */
  (void *)GG_SIUHEAP_INST_C1_START,
  /* End expansion $ch = 1 */
/* Expanding $ch = 2 */
  (void *)GG_SIUHEAP_INST_C2_START,
  /* End expansion $ch = 2 */
 
};
/* Length of each SIU non-bss STATS buffer. Same accross all channels */
const tuint gg_siuheap_inst_len = GG_SIUHEAP_INST_L;

#pragma DATA_SECTION (gg_siuheap_inst_ext, ".gg_siuheap_inst_ext")
word *gg_siuheap_inst_ext[GG_MAX_NUM_SLOTS] = {
                     
  /* Expanding $ch = 1 */
  (void *)GG_SIUHEAP_INST_EXT_C1_START,
  /* End expansion $ch = 1 */
/* Expanding $ch = 2 */
  (void *)GG_SIUHEAP_INST_EXT_C2_START,
  /* End expansion $ch = 2 */
 
};
/* Length of each SIU non-bss STATS buffer. Same accross all channels */
const tuint gg_siuheap_inst_ext_len = {
  GG_SIUHEAP_INST_EXT_L
};

#ifdef GG_INCLUDE_COMPOUND_MSG
/* Base address of compound scratch buffer for DSP->Micro used for compound message creation */
relocQualifier word *gg_compound_scratch = (word *)GG_COMPOUND_MSG_SCRATCH_START;
#endif

#ifdef SIUTBLPRG
const word *gg_msg_call_table_scratch = (word *)GG_MSG_CALL_TABLE_SCRATCH_START;
#endif

/* Number of GMP dedicated memory segments/areass: */
const tuint gg_gmp_no_segments = GG_GMP_AREAS;

#ifdef NDU_GMAC
/* Eco usage for non-video channels (using NEU for messaging */
const ggNvEcoBuffDesc_t ggNvBuffDesc[GG_NV_ECO_BUFF_NUM] = 
{

  /* Buffers for high priority messages */
  GG_NUM_NEU_BUFF,                                                   /* NEU Buffers */
  (word *)GG_GMNDU_NEU_MSG_INST_START,			    GG_GMNDU_NEU_INST_L,
  (word *)0x0000000,                                0,
  (word *)GG_GMNDU_NEU_MSG_TX_SCRATCH_START,        GG_GMNDU_NEU_TX_SCRATCH_L,
  (word *)GG_GMNDU_NEU_MSG_TX_HEADER_START,		    GG_GMNDU_NEU_TX_HEADER_L,
  (word *)GG_GMNDU_NEU_MSG_RX_PKTASSEM_START,  	    GG_GMNDU_NEU_RX_PKTASSEM_L,

  /* Buffers for keep alives */
  GG_NUM_NEU_BUFF,
  (word *)GG_GMNDU_NEU_HLT_INST_START,				GG_GMNDU_NEU_INST_L,
  (word *)0x0000000,                                0,
  (word *)GG_GMNDU_NEU_HLT_TX_SCRATCH_START,	    GG_GMNDU_NEU_TX_SCRATCH_L,
  (word *)GG_GMNDU_NEU_HLT_TX_HEADER_START,		    GG_GMNDU_NEU_HLT_HEADER_L,
  (word *)GG_GMNDU_NEU_HLT_RX_PKTASSEM_START,	    GG_GMNDU_NEU_HLT_RX_PKTASSEM_L,

};
#endif

/* Gmac NDU buffers */
#ifdef NDU_GMAC

const gggmNduDesc_t gmacNduHeapDesc = 
{ GG_NUM_MAC_NDU_BUFF,
  (word *)GG_GMNDU_MSG_HIGH_START,       GG_NDU_MSG_HIGH_FIFO_L,
  (word *)GG_GMNDU_MSG_NORMAL_START,     GG_NDU_MSG_NORMAL_FIFO_L,
  (word *)GG_GMNDU_MSG_LOW_START,        GG_NDU_MSG_LOW_FIFO_L
};
#endif

#if (GG_RTTRACE_BUFSIZE)
/* RTTRACE buffers */
#pragma DATA_SECTION (gg_rttrace_enable, ".rttrace");
#pragma DATA_SECTION (gg_rttrace_buffer0, ".rttrace");
#pragma DATA_SECTION (gg_rttrace_buffer1, ".rttrace");
#pragma DATA_SECTION (gg_rttrace_buffers, ".rttrace");
/* Channel enable bitfields */
utlRtTraceEnable_t gg_rttrace_enable[GG_MAX_NUM_CHANNELS + GG_MAX_PKT2PKT_CHANNELS];

/* Message buffers */
word gg_rttrace_buffer0[GG_RTTRACE_BUFSIZE];
word gg_rttrace_buffer1[GG_RTTRACE_BUFSIZE];
word *gg_rttrace_buffers[] = { gg_rttrace_buffer0, gg_rttrace_buffer1 };
#endif

/* QM buffers */
#if (GG_QM_RX_LINKED_BUF_1_SIZE) 
  #pragma DATA_SECTION(rxlinkramQ1, ".cppiMemRXLinkRamQ1")
  #pragma DATA_ALIGN(rxlinkramQ1, 128)
  word rxlinkramQ1[GG_QM_RX_LINKED_BUF_1_SIZE * GG_QM_RX_LINKED_BUF_1_NBUFS];
#endif

#if (GG_QM_RX_LINKED_BUF_2_SIZE) 
  #pragma DATA_SECTION(rxlinkramQ2, ".cppiMemRXLinkRamQ2")
  #pragma DATA_ALIGN(rxlinkramQ2, 128)
  word rxlinkramQ2[GG_QM_RX_LINKED_BUF_2_SIZE * GG_QM_RX_LINKED_BUF_2_NBUFS];
#endif

#if (GG_QM_RX_LINKED_BUF_3_SIZE) 
  #pragma DATA_SECTION(rxlinkramQ3, ".cppiMemRXLinkRamQ3")
  #pragma DATA_ALIGN(rxlinkramQ3, 128)
  word rxlinkramQ3[GG_QM_RX_LINKED_BUF_3_SIZE * GG_QM_RX_LINKED_BUF_3_NBUFS];
#endif

#if (GG_QM_RX_LINKED_BUF_4_SIZE) 
  #pragma DATA_SECTION(rxlinkramQ4, ".cppiMemRXLinkRamQ4")
  #pragma DATA_ALIGN(rxlinkramQ4, 128)
  word rxlinkramQ4[GG_QM_RX_LINKED_BUF_4_SIZE * GG_QM_RX_LINKED_BUF_4_NBUFS];
#endif

#if (GG_QM_TX_LINKED_BUF_1_SIZE) 
  #pragma DATA_SECTION(txlinkramQ1, ".cppiMemTXLinkRamQ1")
  #pragma DATA_ALIGN(txlinkramQ1, 128)
  word txlinkramQ1[GG_QM_TX_LINKED_BUF_1_SIZE * GG_QM_TX_LINKED_BUF_1_NBUFS];
#endif

#if (GG_QM_TX_LINKED_BUF_2_SIZE) 
  #pragma DATA_SECTION(txlinkramQ2, ".cppiMemTXLinkRamQ2")
  #pragma DATA_ALIGN(txlinkramQ2, 128)
  word txlinkramQ2[GG_QM_TX_LINKED_BUF_2_SIZE * GG_QM_TX_LINKED_BUF_2_NBUFS];
#endif

#if (GG_QM_TX_LINKED_BUF_3_SIZE) 
  #pragma DATA_SECTION(txlinkramQ3, ".cppiMemTXLinkRamQ3")
  #pragma DATA_ALIGN(txlinkramQ3, 128)
  word txlinkramQ3[GG_QM_TX_LINKED_BUF_3_SIZE * GG_QM_TX_LINKED_BUF_3_NBUFS];
#endif

#if (GG_QM_TX_LINKED_BUF_4_SIZE) 
  #pragma DATA_SECTION(txlinkramQ4, ".cppiMemTXLinkRamQ4")
  #pragma DATA_ALIGN(txlinkramQ4, 128)
  word txlinkramQ4[GG_QM_TX_LINKED_BUF_4_SIZE * GG_QM_TX_LINKED_BUF_4_NBUFS];
#endif

#if (GG_QM_DESC_SIZE)
  #pragma DATA_SECTION(QMemDescRam, ".QMemDescRam")
  #pragma DATA_ALIGN(QMemDescRam, 128)
  word QMemDescRam[GG_QM_DESC_SIZE * GG_QM_NUM_DESCS];
#endif

/* nothing past this point */
