/******************************************************************************
* FILE PURPOSE: Video transcoding demo task
******************************************************************************
* FILE NAME:   videoTranscodeRun.c
*
* DESCRIPTION: Contains routines that run video transcoding demo
*
* TABS: NONE
*
*
* (C) Copyright 2010, Texas Instruments Incorporated
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#include "siuVctParse.h"
#include "siuVctNeu.h"
#include "ividmc/siuVidMc.h"
#include "osal/siuOsal.h"
#include "osal/siuIpcOsal.h"
#include "common/siuloc.h"
#include <stdio.h>
#include <string.h>

int CORE_TEAM_MAPPING[MAX_NUM_CORE_IN_TEAM];

extern XDAS_Int32 videoTranscode (const char* decCodecname,
                                  const char* encCodecname,
                                  tulong framesToEncode);
siuVctParams_t *siuVctRunParams;

/******************************************************************************
* FUNCTION PURPOSE: videoTranscodeRunTask
******************************************************************************
* DESCRIPTION: videoTranscodeRunTask is created for demonstrating video
*              transcode. It reads network and app configuration, 
*              configures network channels, and then calls video transcode
*              function.
*
* void videoTranscodeRunTask(
*         void
* )
*****************************************************************************/
void videoTranscodeRunTask(void)
{
    char *tftpCfgFile = "..\\testVecs\\config\\tftp.cfg";
    char *codecCfgFile = "..\\testVecs\\config\\codecParams.cfg";
    char *testFile   = "..\\testVecs\\config\\multiClip.cfg";
    FILE *ftest;
    int first_time = 1;
    siuInst_t *inst;

    /* Record multi-core information in siuInst[0] */
    siuContext.current_working_chnum = 0;  /* Apply to SIU instance 0 */
    inst = SIUINSTp(siuContext.current_working_chnum);
    inst->mcInst.nCores = 1;
    inst->mcInst.coreTeamMapping[0] = SIU_VCT_GLOBAL_CORE_ID;    

    ftest = fopen(testFile,"r");
    if (ftest == NULL) {
       printf("File cannot be opened \n");
    }

    printf("Read tftp config file \n");
    siuVctReadParamFile(tftpCfgFile);

    if(siuContext.netChanConfigFlag)
    {
        /* set up Rx channel*/
        siuVctOpenChannel(&siuVctNetChanParams);
        siuVctNetConfig(&siuVctNetChanParams);
        siuVctVideoMode(&siuVctNetChanParams);

        /* set up Tx channel*/
        siuVctNetChanParams.chNum++;
        siuVctOpenChannel(&siuVctNetChanParams);
        siuVctNetChanParams.srcUdpPort +=2;
        siuVctNetChanParams.dstUdpPort +=2;
        siuVctNetConfig(&siuVctNetChanParams);
        siuVctVideoMode(&siuVctNetChanParams);

        siuContext.netChanConfigFlag = 0;
    }

    while(!feof(ftest))
    {
    	siuVidMc3GlobalInit(SIU_VCT_GLOBAL_CORE_ID);

        /* Parse Config file and fill structure siuVctParams */
    	siuVctRunParams = siuVctReadParamFile(codecCfgFile);
        fscanf(ftest,"%s",&siuVctRunParams->tftpGetFilename[0]);
        fscanf(ftest,"%s",&siuVctRunParams->tftpPuFilename[0]);
        fscanf(ftest,"%d",&siuVctRunParams->framesToEncode);

        if ((strlen((const char *)(&siuVctRunParams->tftpGetFilename[0])) == 0) ||
            (strlen((const char *)(&siuVctRunParams->tftpPuFilename[0])) == 0) ||
            (siuVctRunParams->framesToEncode <= 0)) {
          break;
        }

        if(first_time)
        {
            /* Configure NEU TX header and EMAC port. */
            siuVctConfigureNeu( (const char *)siuVctRunParams->serverMacAddress,
                            (const char *)siuVctRunParams->serverIpAddress,
                            (const char *)siuVctRunParams->localMacAddress,
                            (const char *)siuVctRunParams->localIpAddress);

            first_time = 0;
        }

        /* Demonstrate Video Transcode  */
        videoTranscode( (const char *)siuVctRunParams->decCodecName,
                        (const char *)siuVctRunParams->encCodecName,
                                      siuVctRunParams->framesToEncode );
    }
    fclose(ftest);
    printf("End of Program \n");
}

void siuVctRun(void)
{
  siu_ipc_osal_start(&(siuContext.ipcContext));

  siu_ipc_osal_create_gate();
  siu_ipc_osal_create_share(sizeof(SIUVID_MC_SHMEM_MemTab), (void**)&siuContext.ipcContext.codecShm);
  
  memset(siuContext.ipcContext.codecShm,0,sizeof(SIUVID_MC_SHMEM_MemTab));
  siu_osal_wbinv_cache((tword *)siuContext.ipcContext.codecShm, sizeof(SIUVID_MC_SHMEM_MemTab), TRUE);

  siu_osal_start();
}
/* nothing after this point */
