/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v1/include/dsk6455.h                             $
* $Revision:: 1                                                               $
* $Date:: 4/11/06 9:45a                                                       $
*
* DESCRIPTION: This file contains DSK6455 board initialization and CPLD 
*              register access functions.
*
* 
* NOTES :  BSL Version# 3.20 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#ifndef DSK6455_
#define DSK6455_

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <std.h>
#include <sys.h>

/*
 *  Note:  Bit definitions for each register field
 *         needs to be supplied here for the CPLD
 *         and other board periperals.
 */

/* CPLD address definitions */
#define DSK6455_CPLD_BASE       0xA0000000 // CE2

/* CPLD Register Indices */
#define DSK6455_USER_REG     0
#define DSK6455_DC_REG       1
#define DSK6455_VERSION      4
#define DSK6455_MISC         6
#define DSK6455_FLASHPAGE    7 // Placeholder

/* CPLD Register Bits */
#define DC_DET               0x80
#define DC_STAT1             0x20
#define DC_STAT0             0x10
#define DC_CNTL1             0x02
#define DC_CNTL0             0x01

#define TIN1SEL              0x08
#define TIN0SEL              0x04
#define MCBSP2SEL            0x02
#define MCBSP1SEL            0x01

/* Initialize all board APIs */
void DSK6455_init();

Uint32 Himalaya_PLL1_Init (Uint32 multi_val);

/* Read an 8-bit value from a CPLD register */
Uint8 DSK6455_rget(Int16 regnum);

/* Write an 8-bit value to a CPLD register */
void DSK6455_rset(Int16 regnum, Uint8 regval);

/* Spin in a delay loop for delay iterations */
void DSK6455_wait(Uint32 delay);

/* Spin in a delay loop for delay microseconds */
void DSK6455_waitusec(Uint32 delay);

#ifdef __cplusplus
}
#endif

#endif
