/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v1/include/dsk6455_aic23.h                       $
* $Revision:: 1                                                               $
* $Date:: 4/11/06 9:45a                                                       $
*
* DESCRIPTION:  Codec interface for AIC23 on the DSK6455 board.
*
* 
* NOTES :  BSL Version# 3.20 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#ifndef DSK6455_AIC23_
#define DSK6455_AIC23_

#ifdef __cplusplus
extern "C" {
#endif

/* Codec module definitions */
#define DSK6455_AIC23_NUMREGS         10
#define DSK6455_AIC23_LEFTINVOL       0
#define DSK6455_AIC23_RIGHTINVOL      1
#define DSK6455_AIC23_LEFTHPVOL       2
#define DSK6455_AIC23_RIGHTHPVOL      3
#define DSK6455_AIC23_ANAPATH         4
#define DSK6455_AIC23_DIGPATH         5
#define DSK6455_AIC23_POWERDOWN       6
#define DSK6455_AIC23_DIGIF           7
#define DSK6455_AIC23_SAMPLERATE      8
#define DSK6455_AIC23_DIGACT          9
#define DSK6455_AIC23_RESET           15
#define DSK6455_AIC23_I2CADDR         0x1A
#define DSK6455_AIC23_INPUT           1
#define DSK6455_AIC23_OUTPUT          2

/* Frequency Definitions */
#define DSK6455_AIC23_FREQ_8KHZ       1
#define DSK6455_AIC23_FREQ_16KHZ      2
#define DSK6455_AIC23_FREQ_24KHZ      3
#define DSK6455_AIC23_FREQ_32KHZ      4
#define DSK6455_AIC23_FREQ_44KHZ      5
#define DSK6455_AIC23_FREQ_48KHZ      6
#define DSK6455_AIC23_FREQ_96KHZ      7

/* Codec Handle */
typedef int DSK6455_AIC23_CodecHandle;

/* Parameter Structure for the DSK6455 AIC23 Codec */
typedef struct DSK6455_AIC23_Config {
    int regs[DSK6455_AIC23_NUMREGS];
} DSK6455_AIC23_Config;

#define DSK6455_AIC23_DEFAULTCONFIG { \
    0x0017, /* Set-Up Reg 0       Left line input channel volume control */  \
            /* LRS     0          simultaneous left/right volume: disabled */\
            /* LIM     0          left line input mute: disabled */          \
            /* XX      00         reserved */                                \
            /* LIV     10111      left line input volume: 0 dB */            \
                                                                             \
    0x0017, /* Set-Up Reg 1       Right line input channel volume control */ \
            /* RLS     0          simultaneous right/left volume: disabled */\
            /* RIM     0          right line input mute: disabled */         \
            /* XX      00         reserved */                                \
            /* RIV     10111      right line input volume: 0 dB */           \
                                                                             \
    0x00d8, /* Set-Up Reg 2       Left channel headphone volume control */   \
            /* LRS     1          simultaneous left/right volume: enabled */ \
            /* LZC     1          left channel zero-cross detect: enabled */ \
            /* LHV     1111001    left headphone volume: 0 dB */             \
                                                                             \
    0x00d8, /* Set-Up Reg 3       Right channel headphone volume control */  \
            /* RLS     1          simultaneous right/left volume: enabled */ \
            /* RZC     1          right channel zero-cross detect: enabled */\
            /* RHV     1111001    right headphone volume: 0 dB */            \
                                                                             \
    0x0011, /* Set-Up Reg 4       Analog audio path control */               \
            /* X       0          reserved */                                \
            /* STA     00         sidetone attenuation: -6 dB */             \
            /* STE     0          sidetone: disabled */                      \
            /* DAC     1          DAC: selected */                           \
            /* BYP     0          bypass: off */                             \
            /* INSEL   0          input select for ADC: line */              \
            /* MICM    0          microphone mute: disabled */               \
            /* MICB    1          microphone boost: enabled */               \
                                                                             \
    0x0000, /* Set-Up Reg 5       Digital audio path control */              \
            /* XXXXX   00000      reserved */                                \
            /* DACM    0          DAC soft mute: disabled */                 \
            /* DEEMP   00         deemphasis control: disabled */            \
            /* ADCHP   0          ADC high-pass filter: disabled */          \
                                                                             \
    0x0000, /* Set-Up Reg 6       Power down control */                      \
            /* X       0          reserved */                                \
            /* OFF     0          device power: on (i.e. not off) */         \
            /* CLK     0          clock: on */                               \
            /* OSC     0          oscillator: on */                          \
            /* OUT     0          outputs: on */                             \
            /* DAC     0          DAC: on */                                 \
            /* ADC     0          ADC: on */                                 \
            /* MIC     0          microphone: on */                          \
            /* LINE    0          line input: on */                          \
                                                                             \
    0x0043, /* Set-Up Reg 7       Digital audio interface format */          \
            /* XX      00         reserved */                                \
            /* MS      1          master/slave mode: master */               \
            /* LRSWAP  0          DAC left/right swap: disabled */           \
            /* LRP     0          DAC lrp: MSB on 1st BCLK */                \
            /* IWL     00         input bit length: 16 bit */                \
            /* FOR     11         data format: DSP format */                 \
                                                                             \
    0x0082, /* Set-Up Reg 8       Sample rate control */                     \
            /* X       0          reserved */                                \
            /* CLKOUT  1          clock output divider: 2 (MCLK/2) */        \
            /* CLKIN   0          clock input divider: 1 (MCLK) */           \
            /* SR,BOSR 00001      sampling rate: ADC  48 kHz DAC  48 kHz */  \
            /* USB/N   0          clock mode select (USB/normal): USB */     \
                                                                             \
    0x0001  /* Set-Up Reg 9       Digital interface activation */            \
            /* XX..X   00000000   reserved */                                \
            /* ACT     1          active */                                  \
}

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  MCBSP Controller                                                        *
 *                                                                          *
 * ------------------------------------------------------------------------ */
#define MCBSP_BASE          0x02900000
#define MCBSP_DRR_32BIT     *( volatile Uint32* )( MCBSP_BASE + 0x00 )
#define MCBSP_DRR_16BIT     *( volatile Uint16* )( MCBSP_BASE + 0x00 )
#define MCBSP_DXR_32BIT     *( volatile Uint32* )( MCBSP_BASE + 0x04 )
#define MCBSP_DXR_16BIT     *( volatile Uint16* )( MCBSP_BASE + 0x04 )
#define MCBSP_SPCR          *( volatile Uint32* )( MCBSP_BASE + 0x08 )
#define MCBSP_RCR           *( volatile Uint32* )( MCBSP_BASE + 0x0C )
#define MCBSP_XCR           *( volatile Uint32* )( MCBSP_BASE + 0x10 )
#define MCBSP_SRGR          *( volatile Uint32* )( MCBSP_BASE + 0x14 )
#define MCBSP_MCR           *( volatile Uint32* )( MCBSP_BASE + 0x18 )
#define MCBSP_PCR           *( volatile Uint32* )( MCBSP_BASE + 0x24 )

#define MCBSP_SPCR_FREE                     0x02000000
#define MCBSP_SPCR_SOFT                     0x01000000
#define MCBSP_SPCR_FRST                     0x00800000
#define MCBSP_SPCR_GRST                     0x00400000
#define MCBSP_SPCR_XSYNCERR                 0x00080000
#define MCBSP_SPCR_XEMPTY                   0x00040000
#define MCBSP_SPCR_XRDY                     0x00020000
#define MCBSP_SPCR_XRST                     0x00010000
#define MCBSP_SPCR_DLB                      0x00008000
#define MCBSP_SPCR_DXENA                    0x00000020
#define MCBSP_SPCR_ABIS                     0x00000010
#define MCBSP_SPCR_RSYNCERR                 0x00000008
#define MCBSP_SPCR_RFULL                    0x00000004
#define MCBSP_SPCR_RRDY                     0x00000002
#define MCBSP_SPCR_RRST                     0x00000001

/* Set codec register regnum to value regval */
void DSK6455_AIC23_rset(DSK6455_AIC23_CodecHandle hCodec, Uint16 regnum, Uint16 regval);

/* Return value of codec register regnum */
Uint16 DSK6455_AIC23_rget(DSK6455_AIC23_CodecHandle hCodec, Uint16 regnum);

/* Open the codec with id and return handle */
DSK6455_AIC23_CodecHandle DSK6455_AIC23_openCodec(Int16 id, DSK6455_AIC23_Config *Config);

/* Close the codec */
void DSK6455_AIC23_closeCodec(DSK6455_AIC23_CodecHandle hCodec);

/* Configure the codec register values */
void DSK6455_AIC23_config(DSK6455_AIC23_CodecHandle hCodec, DSK6455_AIC23_Config *Config);

/* Write a 32-bit value to the codec */
Int16 DSK6455_AIC23_write32(DSK6455_AIC23_CodecHandle hCodec, Uint32 val);

/* Read a 32-bit value from the codec */
Int16 DSK6455_AIC23_read32(DSK6455_AIC23_CodecHandle hCodec, Uint32 *val);

/* Set the codec output gain */
void DSK6455_AIC23_outGain(DSK6455_AIC23_CodecHandle hCodec, Uint16 outGain);

/* Set the codec loopback mode */
void DSK6455_AIC23_loopback(DSK6455_AIC23_CodecHandle hCodec, Int16 mode);

/* Enable/disable codec mute mode */
void DSK6455_AIC23_mute(DSK6455_AIC23_CodecHandle hCodec, Int16 mode);

/* Enable/disable codec powerdown modes for DAC, ADC */
void DSK6455_AIC23_powerDown(DSK6455_AIC23_CodecHandle hCodec, Uint16 sect);

/* Set the codec sample rate frequency */
void DSK6455_AIC23_setFreq(DSK6455_AIC23_CodecHandle hCodec, Uint32 freq);

#ifdef __cplusplus
}
#endif

#endif

