/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v1/include/dsk6455_eeprom.h                      $
* $Revision:: 1                                                               $
* $Date:: 4/11/06 9:45a                                                       $
*
* DESCRIPTION: Controls the I2C EEPROM 16 Kbytes - 24WC256
*      Automatically handles page divisons
*
* 
* NOTES :  BSL Version# 3.20 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#ifndef EEPROM_
#define EEPROM_

#ifdef __cplusplus
extern "C" {
#endif

#include "dsk6455_i2c.h"

/* I2C Address */
#define EEPROM_I2C_ADDR             0x50

/* EEPROM specific settings */
#define EEPROM_PAGE_SIZE            64
#define EEPROM_PAGE_SIZE_POW2       6
#define EEPROM_MAX_BURST_LEN        EEPROM_PAGE_SIZE

/* ------------------------------------------------------------------------ *
 *  EEPROM Prototypes                                                       *
 * ------------------------------------------------------------------------ */
Int16 DSK6455_EEPROM_init ( );
Int16 DSK6455_EEPROM_read ( Uint32 src, Uint32 dst, Uint32 length );
Int16 DSK6455_EEPROM_write( Uint32 src, Uint32 dst, Uint32 length );

#ifdef __cplusplus
}
#endif

#endif
