/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v1/include/dsk6455_flash.h                       $
* $Revision:: 1                                                               $
* $Date:: 4/11/06 9:45a                                                       $
*
* DESCRIPTION: Interface for the AMD29LV033C Flash on the DSK6455 board
* 
* NOTES :  BSL Version# 3.20 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#ifndef DSK6455_FLASH_
#define DSK6455_FLASH_

#ifdef __cplusplus
extern "C" {
#endif

/* Flash address definitions */
#define DSK6455_FLASH_BASE          (Uint32)0xB0000000  // CE3
#define DSK6455_FLASH_SECTORSIZE    (Uint32)0x010000
#define DSK6455_FLASH_SECTORS       (Uint32)0x40
#define DSK6455_FLASH_PAGES         (Uint32)0x1
#define DSK6455_FLASH_PAGESIZE      (Uint32)0x400000
#define DSK6455_FLASH_SIZE          (Uint32)0x400000
#define DSK6455_FLASH_CTL555        (Uint32)(DSK6455_FLASH_BASE + 0x555)
#define DSK6455_FLASH_CTLAAA        (Uint32)(DSK6455_FLASH_BASE + 0xaaa)
#define DSK6455_FLASH_SUPPORT       1

/* Calculate the checksum of a data range in Flash */
Uint32 DSK6455_FLASH_checksum(Uint32 start, Uint32 length);

/* Erase a segment of Flash memory */
void DSK6455_FLASH_erase(Uint32 start, Uint32 length);

/* Read data from a range in Flash */
void DSK6455_FLASH_read(Uint32 src, Uint32 dst, Uint32 length);

/* Write data to a data range in Flash */
void DSK6455_FLASH_write(Uint32 src, Uint32 dst, Uint32 length);

#ifdef __cplusplus
}
#endif

#endif

