/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v1/include/dsk6455_i2c.h                         $
* $Revision:: 1                                                               $
* $Date:: 4/11/06 9:45a                                                       $
*
* DESCRIPTION: I2C header file
* 
* NOTES :  BSL Version# 3.20 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#ifndef I2C_
#define I2C_

#ifdef __cplusplus
extern "C" {
#endif

#include "dsk6455.h"

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  I2C Controller                                                          *
 *                                                                          *
 * ------------------------------------------------------------------------ */
#define I2C_BASE            0x02B04000
#define I2C_OAR             *( volatile Uint32* )( I2C_BASE + 0x00 )
#define I2C_ICIMR           *( volatile Uint32* )( I2C_BASE + 0x04 )
#define I2C_ICSTR           *( volatile Uint32* )( I2C_BASE + 0x08 )
#define I2C_ICCLKL          *( volatile Uint32* )( I2C_BASE + 0x0C )
#define I2C_ICCLKH          *( volatile Uint32* )( I2C_BASE + 0x10 )
#define I2C_ICCNT           *( volatile Uint32* )( I2C_BASE + 0x14 )
#define I2C_ICDRR           *( volatile Uint32* )( I2C_BASE + 0x18 )
#define I2C_ICSAR           *( volatile Uint32* )( I2C_BASE + 0x1C )
#define I2C_ICDXR           *( volatile Uint32* )( I2C_BASE + 0x20 )
#define I2C_ICMDR           *( volatile Uint32* )( I2C_BASE + 0x24 )
#define I2C_ICIVR           *( volatile Uint32* )( I2C_BASE + 0x28 )
#define I2C_ICEMDR          *( volatile Uint32* )( I2C_BASE + 0x2C )
#define I2C_ICPSC           *( volatile Uint32* )( I2C_BASE + 0x30 )
#define I2C_ICPFUNC         *( volatile Uint32* )( I2C_BASE + 0x48 )
#define I2C_ICPDIR          *( volatile Uint32* )( I2C_BASE + 0x4C )
#define I2C_ICPDIN          *( volatile Uint32* )( I2C_BASE + 0x50 )
#define I2C_ICPDOUT         *( volatile Uint32* )( I2C_BASE + 0x54 )
#define I2C_ICPDSET         *( volatile Uint32* )( I2C_BASE + 0x58 )
#define I2C_ICPDCLR         *( volatile Uint32* )( I2C_BASE + 0x5C )

/* I2C Field Definitions */
#define ICOAR_MASK_7        0x007F
#define ICOAR_MASK_10       0x03FF
#define ICSAR_MASK_7        0x007F
#define ICSAR_MASK_10       0x03FF
#define ICOAR_OADDR         0x007f
#define ICSAR_SADDR         0x0050

#define ICSTR_BB            0x1000
#define ICSTR_RSFULL        0x0800
#define ICSTR_XSMT          0x0400
#define ICSTR_AAS           0x0200
#define ICSTR_AD0           0x0100
#define ICSTR_ICXRDY        0x0010
#define ICSTR_ICRRDY        0x0008
#define ICSTR_ARDY          0x0004
#define ICSTR_NACK          0x0002
#define ICSTR_AL            0x0001

#define ICMDR_FREE          0x4000
#define ICMDR_STT           0x2000
#define ICMDR_IDLEEN        0x1000
#define ICMDR_STP           0x0800
#define ICMDR_MST           0x0400
#define ICMDR_TRX           0x0200
#define ICMDR_XA            0x0100
#define ICMDR_RM            0x0080
#define ICMDR_DLB           0x0040
#define ICMDR_IRS           0x0020
#define ICMDR_STB           0x0010
#define ICMDR_FDF           0x0008
#define ICMDR_BC_MASK       0x0007

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  I2C Prototypes                                                          *
 *                                                                          *
 * ------------------------------------------------------------------------ */
Int16 DSK6455_I2C_init ( );
Int16 DSK6455_I2C_close( );
Int16 DSK6455_I2C_write( Uint16 slaveaddr, Uint8* data, Uint16 len );
Int16 DSK6455_I2C_read ( Uint16 slaveaddr, Uint8* data, Uint16 len );

#ifdef __cplusplus
}
#endif

#endif
