/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v1/include/dsk6455_led.h                         $
* $Revision:: 1                                                               $
* $Date:: 4/11/06 9:45a                                                       $
*
* DESCRIPTION: Interface for LEDs on the DSK6455 board
* 
* NOTES :  BSL Version# 3.20 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#ifndef DSK6455_LED_
#define DSK6455_LED_

#ifdef __cplusplus
extern "C" {
#endif

/* Initialize the LEDs */
void DSK6455_LED_init();

/* Turn the LED numbered ledNum off */
void DSK6455_LED_off(Uint32 ledNum);

/* Turn the LED numbered ledNum on */
void DSK6455_LED_on(Uint32 ledNum);

/* Toggle the LED numbered ledNum */
void DSK6455_LED_toggle(Uint32 ledNum);

#ifdef __cplusplus
}
#endif

#endif

