/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v1/lib/DSK6455BSL/dsk6455_aic23_loopback.c       $
* $Revision:: 1                                                               $
* $Date:: 4/11/06 9:46a                                                       $
*
* DESCRIPTION:  DSK6455_AIC23_loopback() implementation.
* 
* NOTES :  BSL Version# 3.20 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#include "dsk6455.h"
#include "dsk6455_aic23.h"

/*
 *  ======== DSK6455_AIC23_loopback ========
 *  Enable/disable codec loopback mode
 */
void DSK6455_AIC23_loopback(DSK6455_AIC23_CodecHandle hCodec, Int16 mode)
{
    int regval;

    /* Set bypass bit if mode is true */
    regval = (mode) ? 0x8 : 0x0;

    /* Write to codec register */
    DSK6455_AIC23_rset(hCodec, DSK6455_AIC23_ANAPATH,
        (DSK6455_AIC23_rget(hCodec, DSK6455_AIC23_ANAPATH) & 0xfff7 | regval));
}
