/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v1/lib/DSK6455BSL/dsk6455_aic23_mute.c           $
* $Revision:: 1                                                               $
* $Date:: 4/11/06 9:46a                                                       $
*
* DESCRIPTION:  DSK6455_AIC23_mute() implementation.
* 
* NOTES :  BSL Version# 3.20 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#include "dsk6455.h"
#include "dsk6455_aic23.h"

/*
 *  ======== DSK6455_AIC23_mute ========
 *  Enable/disable codec mute mode
 */
void DSK6455_AIC23_mute(DSK6455_AIC23_CodecHandle hCodec, Int16 mode)
{
    int regval;

    /* Enable mute if mode is true */
    regval = (mode) ? 0x08 : 0x00;

    /* Write to codec registers (left and right) */
    DSK6455_AIC23_rset(hCodec, DSK6455_AIC23_DIGPATH,
        (DSK6455_AIC23_rget(hCodec, DSK6455_AIC23_DIGPATH) & 0xfff7) | regval);
}
