/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v1/lib/DSK6455BSL/dsk6455_aic23_outgain.c        $
* $Revision:: 1                                                               $
* $Date:: 4/11/06 9:46a                                                       $
*
* DESCRIPTION:   DSK6455_AIC23_setFreq() implementation.
* 
* NOTES :  BSL Version# 3.20 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#include "dsk6455.h"
#include "dsk6455_aic23.h"

/*
 *  ======== DSK6455_AIC23_outGain ========
 *  Set the output gain on the codec
 */
void DSK6455_AIC23_outGain(DSK6455_AIC23_CodecHandle hCodec, Uint16 outGain)
{
    /* Write to codec registers (left and right) */
    DSK6455_AIC23_rset(hCodec, DSK6455_AIC23_LEFTHPVOL,
        (DSK6455_AIC23_rget(hCodec, DSK6455_AIC23_LEFTHPVOL) & 0xff80) | (outGain & 0x7f));
    DSK6455_AIC23_rset(hCodec, DSK6455_AIC23_RIGHTHPVOL,
        (DSK6455_AIC23_rget(hCodec, DSK6455_AIC23_RIGHTHPVOL) & 0xff80) | (outGain & 0x7f));
}

