/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v1/lib/DSK6455BSL/dsk6455_aic23_powerdown.c      $
* $Revision:: 1                                                               $
* $Date:: 4/11/06 9:46a                                                       $
*
* DESCRIPTION:   DSK6455_AIC23_powerDown() implementation.
* 
* NOTES :  BSL Version# 3.20 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#include "dsk6455.h"
#include "dsk6455_aic23.h"

/*
 *  ======== DSK6455_AIC23_powerDown ========
 *  Enable/disable powerdown modes for the DAC and ADC codec subsections
 */
void DSK6455_AIC23_powerDown(DSK6455_AIC23_CodecHandle hCodec, Uint16 sect)
{
    /* Write to codec register */
    DSK6455_AIC23_rset(hCodec, DSK6455_AIC23_POWERDOWN,
        (DSK6455_AIC23_rget(hCodec, DSK6455_AIC23_POWERDOWN) & 0xff00) | (sect & 0xff));
}
