/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v1/lib/DSK6455BSL/dsk6455_aic23_read32.c         $
* $Revision:: 1                                                               $
* $Date:: 4/11/06 9:46a                                                       $
*
* DESCRIPTION:    DSK6455_AIC23_read() implementation.
* 
* NOTES :  BSL Version# 3.20 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#include "dsk6455.h"
#include "dsk6455_aic23.h"

/*
 *  ======== DSK6455_AIC23_read32 ========
 *  Read a 32-bit value from the codec
 */
Int16 DSK6455_AIC23_read32(DSK6455_AIC23_CodecHandle hCodec, Uint32 *value)
{
    if ( ( MCBSP_SPCR & MCBSP_SPCR_RRDY ) == 0 )    // Check for Rx ready
        return 1;

    *value = MCBSP_DRR_32BIT;                       // Read 32-bits

    return 1;
}
