/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v1/lib/DSK6455BSL/dsk6455_flash_checksum.c       $
* $Revision:: 1                                                               $
* $Date:: 4/11/06 9:46a                                                       $
*
* DESCRIPTION: DSK6455_FLASH_checksum() implementation.
* 
* NOTES :  BSL Version# 3.20 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#include "dsk6455.h"
#include "dsk6455_flash.h"

/* Calculate the checksum of a data range in Flash */
Uint32 DSK6455_FLASH_checksum(Uint32 start, Uint32 length)
{
    Int16 i;
    Uint8 *pdata;
    Uint32 checksum;

    /* Establish source and destination */
    pdata = (Uint8 *)start;

    /* Calculate checksum by adding each word to the total */
    checksum = 0;
    for (i = 0; i < length; i++)
    {
        checksum += *pdata++;
    }

    return checksum;
}
