/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v1/lib/DSK6455BSL/dsk6455_flash_write.c          $
* $Revision:: 1                                                               $
* $Date:: 4/11/06 9:46a                                                       $
*
* DESCRIPTION: DSK6455_FLASH_write() implementation.
* 
* NOTES :  BSL Version# 3.20 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#include "dsk6455.h"
#include "dsk6455_flash.h"

/* Write data to a data range in Flash */
void DSK6455_FLASH_write(Uint32 src, Uint32 dst, Uint32 length)
{
    Uint8 *psrc, *pdst;
    Uint32 i;

    /* Establish source and destination */
    psrc = (Uint8 *)src;
    pdst = (Uint8 *)dst;
    for (i = 0; i < length; i++)
    {
        // Program one 8-bit word
        *((Uint8 *)DSK6455_FLASH_BASE) = 0xaa;
        *((Uint8 *)DSK6455_FLASH_BASE) = 0x55;
        *((Uint8 *)DSK6455_FLASH_BASE) = 0xa0;
        *pdst = *psrc;

        // Wait for operation to complete
        while(1)
            if (*pdst == *psrc)
                break;

        pdst++;
        psrc++;
    }

    /* Put back in read mode */
    *((Uint16 *)DSK6455_FLASH_BASE) = 0xf0;
}
