/*H***************************************************************************
*
* $Archive:: /boards/dsk6455_v1/lib/DSK6455BSL/dsk6455_led.c                  $
* $Revision:: 1                                                               $
* $Date:: 4/11/06 9:46a                                                       $
*
* DESCRIPTION:LED module for the DSK6455.
* 
* NOTES :  BSL Version# 3.20 
*
* (C) Copyright 2005 by Spectrum Digital Incorporated
* All rights reserved
*
*H***************************************************************************/

#include "dsk6455.h"
#include "dsk6455_led.h"

static Int16 ledstate;

void DSK6455_LED_init()
{
    /* Turn all LEDs off */
    ledstate = 0;
    DSK6455_rset(DSK6455_USER_REG, ledstate);
}

void DSK6455_LED_off(Uint32 ledNum)
{
    /* Check bounds for ledNum */
    if (ledNum >= 4)
        return;

    /* Clear the LED bit */
    ledstate &= ~(1 << ledNum);
    DSK6455_rset(DSK6455_USER_REG, ledstate);
}

void DSK6455_LED_on(Uint32 ledNum)
{
    /* Check bounds for ledNum */
    if (ledNum >= 4)
        return;

    /* Set the LED bit */
    ledstate |= 1 << ledNum;
    DSK6455_rset(DSK6455_USER_REG, ledstate);
}

void DSK6455_LED_toggle(Uint32 ledNum)
{
    /* Check bounds for ledNum */
    if (ledNum >= 4)
        return;

    /* Toggle the LED bit */
    if ((DSK6455_rget(DSK6455_USER_REG) & (1 << ledNum)) == 0)
        DSK6455_LED_on(ledNum);
    else
        DSK6455_LED_off(ledNum);
}


