/*
 * UART.c
 *
 *  Created on: 2017-1-19
 *      Author: admin
 */

#include "csl_uart.h"
#include "csl_uartAux.h"
#include "stdio.h"
#include "UART.h"


void UART_INIT()
{
    CSL_UartObj 	uartObj;
    CSL_UartHandle  hUart;
    CSL_UartSetup uartSetup =
    {
    	/* Input clock freq in MHz */
        72000000,
    	/* Baud rate */
        115200,
    	/* Word length of 8 */
        CSL_UART_WORD8,
    	/* To generate 1 stop bit */
        0,
    	/* Disable the parity */
        CSL_UART_DISABLE_PARITY,
    	/* Disable fifo */
    	/* Enable trigger 14 fifo */
//    	CSL_UART_FIFO_DMA1_DISABLE_TRIG14,
        CSL_UART_FIFO_DISABLE,
    	/* Loop Back enable */
        CSL_UART_NO_LOOPBACK,
    	/* No auto flow control*/
    	CSL_UART_NO_AFE ,
    	/* No RTS */
    	CSL_UART_NO_RTS ,
    };
    UART_init(&uartObj,CSL_UART_INST_0,UART_POLLED);
    /* Handle created */
    hUart = (CSL_UartHandle)(&uartObj);
    /* Configure UART registers using setup structure */
    UART_setup(hUart,&uartSetup);
//    /* Enable the UART Events */
//    UART_eventEnable(hUart, CSL_UART_RECVOR_REG_DATA_INTERRUPT);
}




void UART_SEND(Uint8 dat)
{
    THR=dat;;;
    while((LSR&0X0020)==0X0000);

}
