/* ============================================================================
 * Copyright (c) 2008-2012 Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/


/*********************************************************************
* file: cslr_mcspi.h
*
* Brief: This file contains the Register Description for mcspi
*
*********************************************************************/
#ifndef _CSLR_MCSPI_H_
#define _CSLR_MCSPI_H_

#include <cslr.h>

#include <tistdtypes.h>


/* Minimum unit = 2 bytes */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint16 RSVD0[256];
    volatile Uint16 REVISIONL;
    volatile Uint16 RSVD1[15];
    volatile Uint16 SYSCONFIGL;
    volatile Uint16 RSVD2[3];
    volatile Uint16 SYSSTATUSL;
    volatile Uint16 RSVD3[3];
    volatile Uint16 IRQSTATUSL;
    volatile Uint16 IRQSTATUSU;
    volatile Uint16 RSVD4[2];
    volatile Uint16 IRQENABLEL;
    volatile Uint16 IRQENABLEU;
    volatile Uint16 RSVD5[2];
    volatile Uint16 WAKEUPENABLEL;
    volatile Uint16 RSVD6[7];
    volatile Uint16 MODULCTRLL;
    volatile Uint16 RSVD7[3];
    volatile Uint16 CH0CONFL;
    volatile Uint16 CH0CONFU;
    volatile Uint16 RSVD8[2];
    volatile Uint16 CH0STATL;
    volatile Uint16 RSVD9[3];
    volatile Uint16 CH0CTRLL;
    volatile Uint16 RSVD10[3];
    volatile Uint16 CH0TXL;
    volatile Uint16 CH0TXU;
    volatile Uint16 RSVD11[2];
    volatile Uint16 CH0RXL;
    volatile Uint16 CH0RXU;
    volatile Uint16 RSVD12[2];
    volatile Uint16 CH1CONFL;
    volatile Uint16 CH1CONFU;
    volatile Uint16 RSVD13[2];
    volatile Uint16 CH1STATL;
    volatile Uint16 RSVD14[3];
    volatile Uint16 CH1CTRLL;
    volatile Uint16 RSVD15[3];
    volatile Uint16 CH1TXL;
    volatile Uint16 CH1TXU;
    volatile Uint16 RSVD16[2];
    volatile Uint16 CH1RXL;
    volatile Uint16 CH1RXU;
    volatile Uint16 RSVD17[2];
    volatile Uint16 CH2CONFL;
    volatile Uint16 CH2CONFU;
    volatile Uint16 RSVD18[2];
    volatile Uint16 CH2STATL;
    volatile Uint16 RSVD19[3];
    volatile Uint16 CH2CTRLL;
    volatile Uint16 RSVD20[3];
    volatile Uint16 CH2TXL;
    volatile Uint16 CH2TXU;
    volatile Uint16 RSVD21[2];
    volatile Uint16 CH2RXL;
    volatile Uint16 CH2RXU;
    volatile Uint16 RSVD22[22];
    volatile Uint16 XFERLEVELL;
    volatile Uint16 XFERLEVELU;
    volatile Uint16 RSVD23[2];
    volatile Uint16 DAFTXL;
    volatile Uint16 DAFTXU;
    volatile Uint16 RSVD24[30];
    volatile Uint16 DAFRXL;
    volatile Uint16 DAFRXU;
} CSL_McspiRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* REVISIONL */


#define CSL_MCSPI_REVISIONL_REV_MASK     (0x00FFu)
#define CSL_MCSPI_REVISIONL_REV_SHIFT    (0x0000u)
#define CSL_MCSPI_REVISIONL_REV_RESETVAL (0x002Bu)

#define CSL_MCSPI_REVISIONL_RESETVAL     (0x002Bu)

/* SYSCONFIGL */


#define CSL_MCSPI_SYSCONFIGL_CLOCKACTIVITY_MASK (0x0300u)
#define CSL_MCSPI_SYSCONFIGL_CLOCKACTIVITY_SHIFT (0x0008u)
#define CSL_MCSPI_SYSCONFIGL_CLOCKACTIVITY_RESETVAL (0x0000u)
/*----CLOCKACTIVITY Tokens----*/
#define CSL_MCSPI_SYSCONFIGL_CLOCKACTIVITY_ACT0 (0x0000u)
#define CSL_MCSPI_SYSCONFIGL_CLOCKACTIVITY_ACT1 (0x0001u)
#define CSL_MCSPI_SYSCONFIGL_CLOCKACTIVITY_ACT2 (0x0002u)
#define CSL_MCSPI_SYSCONFIGL_CLOCKACTIVITY_ACT3 (0x0003u)


#define CSL_MCSPI_SYSCONFIGL_SIDLEMODE_MASK (0x0018u)
#define CSL_MCSPI_SYSCONFIGL_SIDLEMODE_SHIFT (0x0003u)
#define CSL_MCSPI_SYSCONFIGL_SIDLEMODE_RESETVAL (0x0002u)
/*----SIDLEMODE Tokens----*/
#define CSL_MCSPI_SYSCONFIGL_SIDLEMODE_MODE0 (0x0000u)
#define CSL_MCSPI_SYSCONFIGL_SIDLEMODE_MODE1 (0x0001u)
#define CSL_MCSPI_SYSCONFIGL_SIDLEMODE_MODE2 (0x0002u)
#define CSL_MCSPI_SYSCONFIGL_SIDLEMODE_MODE3 (0x0003u)

#define CSL_MCSPI_SYSCONFIGL_ENAWAKEUP_MASK (0x0004u)
#define CSL_MCSPI_SYSCONFIGL_ENAWAKEUP_SHIFT (0x0002u)
#define CSL_MCSPI_SYSCONFIGL_ENAWAKEUP_RESETVAL (0x0001u)
/*----ENAWAKEUP Tokens----*/
#define CSL_MCSPI_SYSCONFIGL_ENAWAKEUP_DISABLE (0x0000u)
#define CSL_MCSPI_SYSCONFIGL_ENAWAKEUP_ENABLE (0x0001u)

#define CSL_MCSPI_SYSCONFIGL_SOFTRESET_MASK (0x0002u)
#define CSL_MCSPI_SYSCONFIGL_SOFTRESET_SHIFT (0x0001u)
#define CSL_MCSPI_SYSCONFIGL_SOFTRESET_RESETVAL (0x0000u)
/*----SOFTRESET Tokens----*/
#define CSL_MCSPI_SYSCONFIGL_SOFTRESET_NORMAL (0x0000u)
#define CSL_MCSPI_SYSCONFIGL_SOFTRESET_TRIGGER (0x0001u)

#define CSL_MCSPI_SYSCONFIGL_AUTOIDLE_MASK (0x0001u)
#define CSL_MCSPI_SYSCONFIGL_AUTOIDLE_SHIFT (0x0000u)
#define CSL_MCSPI_SYSCONFIGL_AUTOIDLE_RESETVAL (0x0001u)
/*----AUTOIDLE Tokens----*/
#define CSL_MCSPI_SYSCONFIGL_AUTOIDLE_FREERUN (0x0000u)
#define CSL_MCSPI_SYSCONFIGL_AUTOIDLE_AUTO (0x0001u)

#define CSL_MCSPI_SYSCONFIGL_RESETVAL    (0x0015u)

/* SYSSTATUSL */


#define CSL_MCSPI_SYSSTATUSL_RESETDONE_MASK (0x0001u)
#define CSL_MCSPI_SYSSTATUSL_RESETDONE_SHIFT (0x0000u)
#define CSL_MCSPI_SYSSTATUSL_RESETDONE_RESETVAL (0x0000u)
/*----RESETDONE Tokens----*/
#define CSL_MCSPI_SYSSTATUSL_RESETDONE_ONGOING (0x0000u)
#define CSL_MCSPI_SYSSTATUSL_RESETDONE_COMPLETE (0x0001u)

#define CSL_MCSPI_SYSSTATUSL_RESETVAL    (0x0000u)

/* IRQSTATUSL */


#define CSL_MCSPI_IRQSTATUSL_RX3_FULL_MASK (0x4000u)
#define CSL_MCSPI_IRQSTATUSL_RX3_FULL_SHIFT (0x000Eu)
#define CSL_MCSPI_IRQSTATUSL_RX3_FULL_RESETVAL (0x0000u)
/*----RX3_FULL Tokens----*/
#define CSL_MCSPI_IRQSTATUSL_RX3_FULL_FALSEEVT (0x0000u)
#define CSL_MCSPI_IRQSTATUSL_RX3_FULL_PENDINGEVT (0x0001u)

#define CSL_MCSPI_IRQSTATUSL_TX3_UNDERFLOW_MASK (0x2000u)
#define CSL_MCSPI_IRQSTATUSL_TX3_UNDERFLOW_SHIFT (0x000Du)
#define CSL_MCSPI_IRQSTATUSL_TX3_UNDERFLOW_RESETVAL (0x0000u)
/*----TX3_UNDERFLOW Tokens----*/
#define CSL_MCSPI_IRQSTATUSL_TX3_UNDERFLOW_FALSEEVT (0x0000u)
#define CSL_MCSPI_IRQSTATUSL_TX3_UNDERFLOW_PENDINGEVT (0x0001u)

#define CSL_MCSPI_IRQSTATUSL_TX3_EMPTY_MASK (0x1000u)
#define CSL_MCSPI_IRQSTATUSL_TX3_EMPTY_SHIFT (0x000Cu)
#define CSL_MCSPI_IRQSTATUSL_TX3_EMPTY_RESETVAL (0x0000u)
/*----TX3_EMPTY Tokens----*/
#define CSL_MCSPI_IRQSTATUSL_TX3_EMPTY_FALSEEVT (0x0000u)
#define CSL_MCSPI_IRQSTATUSL_TX3_EMPTY_PENDINGEVT (0x0001u)


#define CSL_MCSPI_IRQSTATUSL_RX2_FULL_MASK (0x0400u)
#define CSL_MCSPI_IRQSTATUSL_RX2_FULL_SHIFT (0x000Au)
#define CSL_MCSPI_IRQSTATUSL_RX2_FULL_RESETVAL (0x0000u)
/*----RX2_FULL Tokens----*/
#define CSL_MCSPI_IRQSTATUSL_RX2_FULL_FALSEEVT (0x0000u)
#define CSL_MCSPI_IRQSTATUSL_RX2_FULL_PENDINGEVT (0x0001u)

#define CSL_MCSPI_IRQSTATUSL_TX2_UNDERFLOW_MASK (0x0200u)
#define CSL_MCSPI_IRQSTATUSL_TX2_UNDERFLOW_SHIFT (0x0009u)
#define CSL_MCSPI_IRQSTATUSL_TX2_UNDERFLOW_RESETVAL (0x0000u)
/*----TX2_UNDERFLOW Tokens----*/
#define CSL_MCSPI_IRQSTATUSL_TX2_UNDERFLOW_FALSEEVT (0x0000u)
#define CSL_MCSPI_IRQSTATUSL_TX2_UNDERFLOW_PENDINGEVT (0x0001u)

#define CSL_MCSPI_IRQSTATUSL_TX2_EMPTY_MASK (0x0100u)
#define CSL_MCSPI_IRQSTATUSL_TX2_EMPTY_SHIFT (0x0008u)
#define CSL_MCSPI_IRQSTATUSL_TX2_EMPTY_RESETVAL (0x0000u)
/*----TX2_EMPTY Tokens----*/
#define CSL_MCSPI_IRQSTATUSL_TX2_EMPTY_FALSEEVT (0x0000u)
#define CSL_MCSPI_IRQSTATUSL_TX2_EMPTY_PENDINGEVT (0x0001u)


#define CSL_MCSPI_IRQSTATUSL_RX1_FULL_MASK (0x0040u)
#define CSL_MCSPI_IRQSTATUSL_RX1_FULL_SHIFT (0x0006u)
#define CSL_MCSPI_IRQSTATUSL_RX1_FULL_RESETVAL (0x0000u)
/*----RX1_FULL Tokens----*/
#define CSL_MCSPI_IRQSTATUSL_RX1_FULL_FALSEEVT (0x0000u)
#define CSL_MCSPI_IRQSTATUSL_RX1_FULL_PENDINGEVT (0x0001u)

#define CSL_MCSPI_IRQSTATUSL_TX1_UNDERFLOW_MASK (0x0020u)
#define CSL_MCSPI_IRQSTATUSL_TX1_UNDERFLOW_SHIFT (0x0005u)
#define CSL_MCSPI_IRQSTATUSL_TX1_UNDERFLOW_RESETVAL (0x0000u)
/*----TX1_UNDERFLOW Tokens----*/
#define CSL_MCSPI_IRQSTATUSL_TX1_UNDERFLOW_FALSEEVT (0x0000u)
#define CSL_MCSPI_IRQSTATUSL_TX1_UNDERFLOW_PENDINGEVT (0x0001u)

#define CSL_MCSPI_IRQSTATUSL_TX1_EMPTY_MASK (0x0010u)
#define CSL_MCSPI_IRQSTATUSL_TX1_EMPTY_SHIFT (0x0004u)
#define CSL_MCSPI_IRQSTATUSL_TX1_EMPTY_RESETVAL (0x0000u)
/*----TX1_EMPTY Tokens----*/
#define CSL_MCSPI_IRQSTATUSL_TX1_EMPTY_FALSEEVT (0x0000u)
#define CSL_MCSPI_IRQSTATUSL_TX1_EMPTY_PENDINGEVT (0x0001u)

#define CSL_MCSPI_IRQSTATUSL_RX0_OVERFLOW_MASK (0x0008u)
#define CSL_MCSPI_IRQSTATUSL_RX0_OVERFLOW_SHIFT (0x0003u)
#define CSL_MCSPI_IRQSTATUSL_RX0_OVERFLOW_RESETVAL (0x0000u)
/*----RX0_OVERFLOW Tokens----*/
#define CSL_MCSPI_IRQSTATUSL_RX0_OVERFLOW_FALSEEVT (0x0000u)
#define CSL_MCSPI_IRQSTATUSL_RX0_OVERFLOW_PENDINGEVT (0x0001u)

#define CSL_MCSPI_IRQSTATUSL_RX0_FULL_MASK (0x0004u)
#define CSL_MCSPI_IRQSTATUSL_RX0_FULL_SHIFT (0x0002u)
#define CSL_MCSPI_IRQSTATUSL_RX0_FULL_RESETVAL (0x0000u)
/*----RX0_FULL Tokens----*/
#define CSL_MCSPI_IRQSTATUSL_RX0_FULL_FALSEEVT (0x0000u)
#define CSL_MCSPI_IRQSTATUSL_RX0_FULL_PENDINGEVT (0x0001u)

#define CSL_MCSPI_IRQSTATUSL_TX0_UNDERFLOW_MASK (0x0002u)
#define CSL_MCSPI_IRQSTATUSL_TX0_UNDERFLOW_SHIFT (0x0001u)
#define CSL_MCSPI_IRQSTATUSL_TX0_UNDERFLOW_RESETVAL (0x0000u)
/*----TX0_UNDERFLOW Tokens----*/
#define CSL_MCSPI_IRQSTATUSL_TX0_UNDERFLOW_FALSEEVT (0x0000u)
#define CSL_MCSPI_IRQSTATUSL_TX0_UNDERFLOW_PENDINGEVT (0x0001u)

#define CSL_MCSPI_IRQSTATUSL_TX0_EMPTY_MASK (0x0001u)
#define CSL_MCSPI_IRQSTATUSL_TX0_EMPTY_SHIFT (0x0000u)
#define CSL_MCSPI_IRQSTATUSL_TX0_EMPTY_RESETVAL (0x0000u)
/*----TX0_EMPTY Tokens----*/
#define CSL_MCSPI_IRQSTATUSL_TX0_EMPTY_FALSEEVT (0x0000u)
#define CSL_MCSPI_IRQSTATUSL_TX0_EMPTY_PENDINGEVT (0x0001u)

#define CSL_MCSPI_IRQSTATUSL_RESETVAL    (0x0000u)

/* IRQSTATUSU */


#define CSL_MCSPI_IRQSTATUSU_EOW_MASK    (0x0002u)
#define CSL_MCSPI_IRQSTATUSU_EOW_SHIFT   (0x0001u)
#define CSL_MCSPI_IRQSTATUSU_EOW_RESETVAL (0x0000u)
/*----EOW Tokens----*/
#define CSL_MCSPI_IRQSTATUSU_EOW_NOCHNAGE (0x0000u)
#define CSL_MCSPI_IRQSTATUSU_EOW_BITRESET (0x0001u)

#define CSL_MCSPI_IRQSTATUSU_WKS_MASK    (0x0001u)
#define CSL_MCSPI_IRQSTATUSU_WKS_SHIFT   (0x0000u)
#define CSL_MCSPI_IRQSTATUSU_WKS_RESETVAL (0x0000u)
/*----WKS Tokens----*/
#define CSL_MCSPI_IRQSTATUSU_WKS_NOCHNAGE (0x0000u)
#define CSL_MCSPI_IRQSTATUSU_WKS_BITRESET (0x0001u)

#define CSL_MCSPI_IRQSTATUSU_RESETVAL    (0x0000u)

/* IRQENABLEL */


#define CSL_MCSPI_IRQENABLEL_RX3_FULL_ENABLE_MASK (0x4000u)
#define CSL_MCSPI_IRQENABLEL_RX3_FULL_ENABLE_SHIFT (0x000Eu)
#define CSL_MCSPI_IRQENABLEL_RX3_FULL_ENABLE_RESETVAL (0x0000u)
/*----RX3_FULL_ENABLE Tokens----*/
#define CSL_MCSPI_IRQENABLEL_RX3_FULL_ENABLE_DISABLE (0x0000u)
#define CSL_MCSPI_IRQENABLEL_RX3_FULL_ENABLE_ENABLE (0x0001u)

#define CSL_MCSPI_IRQENABLEL_TX3_UNDERFLOW_ENABLE_MASK (0x2000u)
#define CSL_MCSPI_IRQENABLEL_TX3_UNDERFLOW_ENABLE_SHIFT (0x000Du)
#define CSL_MCSPI_IRQENABLEL_TX3_UNDERFLOW_ENABLE_RESETVAL (0x0000u)
/*----TX3_UNDERFLOW_ENABLE Tokens----*/
#define CSL_MCSPI_IRQENABLEL_TX3_UNDERFLOW_ENABLE_DISABLE (0x0000u)
#define CSL_MCSPI_IRQENABLEL_TX3_UNDERFLOW_ENABLE_ENABLE (0x0001u)

#define CSL_MCSPI_IRQENABLEL_TX3_EMPTY_ENABLE_MASK (0x1000u)
#define CSL_MCSPI_IRQENABLEL_TX3_EMPTY_ENABLE_SHIFT (0x000Cu)
#define CSL_MCSPI_IRQENABLEL_TX3_EMPTY_ENABLE_RESETVAL (0x0000u)
/*----TX3_EMPTY_ENABLE Tokens----*/
#define CSL_MCSPI_IRQENABLEL_TX3_EMPTY_ENABLE_DISABLE (0x0000u)
#define CSL_MCSPI_IRQENABLEL_TX3_EMPTY_ENABLE_ENABLE (0x0001u)


#define CSL_MCSPI_IRQENABLEL_RX2_FULL_ENABLE_MASK (0x0400u)
#define CSL_MCSPI_IRQENABLEL_RX2_FULL_ENABLE_SHIFT (0x000Au)
#define CSL_MCSPI_IRQENABLEL_RX2_FULL_ENABLE_RESETVAL (0x0000u)
/*----RX2_FULL_ENABLE Tokens----*/
#define CSL_MCSPI_IRQENABLEL_RX2_FULL_ENABLE_DISABLE (0x0000u)
#define CSL_MCSPI_IRQENABLEL_RX2_FULL_ENABLE_ENABLE (0x0001u)

#define CSL_MCSPI_IRQENABLEL_TX2_UNDERFLOW_ENABLE_MASK (0x0200u)
#define CSL_MCSPI_IRQENABLEL_TX2_UNDERFLOW_ENABLE_SHIFT (0x0009u)
#define CSL_MCSPI_IRQENABLEL_TX2_UNDERFLOW_ENABLE_RESETVAL (0x0000u)
/*----TX2_UNDERFLOW_ENABLE Tokens----*/
#define CSL_MCSPI_IRQENABLEL_TX2_UNDERFLOW_ENABLE_DISABLE (0x0000u)
#define CSL_MCSPI_IRQENABLEL_TX2_UNDERFLOW_ENABLE_ENABLE (0x0001u)

#define CSL_MCSPI_IRQENABLEL_TX2_EMPTY_ENABLE_MASK (0x0100u)
#define CSL_MCSPI_IRQENABLEL_TX2_EMPTY_ENABLE_SHIFT (0x0008u)
#define CSL_MCSPI_IRQENABLEL_TX2_EMPTY_ENABLE_RESETVAL (0x0000u)
/*----TX2_EMPTY_ENABLE Tokens----*/
#define CSL_MCSPI_IRQENABLEL_TX2_EMPTY_ENABLE_DISABLE (0x0000u)
#define CSL_MCSPI_IRQENABLEL_TX2_EMPTY_ENABLE_ENABLE (0x0001u)


#define CSL_MCSPI_IRQENABLEL_RX1_FULL_ENABLE_MASK (0x0040u)
#define CSL_MCSPI_IRQENABLEL_RX1_FULL_ENABLE_SHIFT (0x0006u)
#define CSL_MCSPI_IRQENABLEL_RX1_FULL_ENABLE_RESETVAL (0x0000u)
/*----RX1_FULL_ENABLE Tokens----*/
#define CSL_MCSPI_IRQENABLEL_RX1_FULL_ENABLE_DISABLE (0x0000u)
#define CSL_MCSPI_IRQENABLEL_RX1_FULL_ENABLE_ENABLE (0x0001u)

#define CSL_MCSPI_IRQENABLEL_TX1_UNDERFLOW_ENABLE_MASK (0x0020u)
#define CSL_MCSPI_IRQENABLEL_TX1_UNDERFLOW_ENABLE_SHIFT (0x0005u)
#define CSL_MCSPI_IRQENABLEL_TX1_UNDERFLOW_ENABLE_RESETVAL (0x0000u)
/*----TX1_UNDERFLOW_ENABLE Tokens----*/
#define CSL_MCSPI_IRQENABLEL_TX1_UNDERFLOW_ENABLE_DISABLE (0x0000u)
#define CSL_MCSPI_IRQENABLEL_TX1_UNDERFLOW_ENABLE_ENABLE (0x0001u)

#define CSL_MCSPI_IRQENABLEL_TX1_EMPTY_ENABLE_MASK (0x0010u)
#define CSL_MCSPI_IRQENABLEL_TX1_EMPTY_ENABLE_SHIFT (0x0004u)
#define CSL_MCSPI_IRQENABLEL_TX1_EMPTY_ENABLE_RESETVAL (0x0000u)
/*----TX1_EMPTY_ENABLE Tokens----*/
#define CSL_MCSPI_IRQENABLEL_TX1_EMPTY_ENABLE_DISABLE (0x0000u)
#define CSL_MCSPI_IRQENABLEL_TX1_EMPTY_ENABLE_ENABLE (0x0001u)

#define CSL_MCSPI_IRQENABLEL_RX0_OVERFLOW_ENABLE_MASK (0x0008u)
#define CSL_MCSPI_IRQENABLEL_RX0_OVERFLOW_ENABLE_SHIFT (0x0003u)
#define CSL_MCSPI_IRQENABLEL_RX0_OVERFLOW_ENABLE_RESETVAL (0x0000u)
/*----RX0_OVERFLOW_ENABLE Tokens----*/
#define CSL_MCSPI_IRQENABLEL_RX0_OVERFLOW_ENABLE_DISABLE (0x0000u)
#define CSL_MCSPI_IRQENABLEL_RX0_OVERFLOW_ENABLE_ENABLE (0x0001u)

#define CSL_MCSPI_IRQENABLEL_RX0_FULL_ENABLE_MASK (0x0004u)
#define CSL_MCSPI_IRQENABLEL_RX0_FULL_ENABLE_SHIFT (0x0002u)
#define CSL_MCSPI_IRQENABLEL_RX0_FULL_ENABLE_RESETVAL (0x0000u)
/*----RX0_FULL_ENABLE Tokens----*/
#define CSL_MCSPI_IRQENABLEL_RX0_FULL_ENABLE_DISABLE (0x0000u)
#define CSL_MCSPI_IRQENABLEL_RX0_FULL_ENABLE_ENABLE (0x0001u)

#define CSL_MCSPI_IRQENABLEL_TX0_UNDERFLOW_ENABLE_MASK (0x0002u)
#define CSL_MCSPI_IRQENABLEL_TX0_UNDERFLOW_ENABLE_SHIFT (0x0001u)
#define CSL_MCSPI_IRQENABLEL_TX0_UNDERFLOW_ENABLE_RESETVAL (0x0000u)
/*----TX0_UNDERFLOW_ENABLE Tokens----*/
#define CSL_MCSPI_IRQENABLEL_TX0_UNDERFLOW_ENABLE_DISABLE (0x0000u)
#define CSL_MCSPI_IRQENABLEL_TX0_UNDERFLOW_ENABLE_ENABLE (0x0001u)

#define CSL_MCSPI_IRQENABLEL_TX0_EMPTY_ENABLE_MASK (0x0001u)
#define CSL_MCSPI_IRQENABLEL_TX0_EMPTY_ENABLE_SHIFT (0x0000u)
#define CSL_MCSPI_IRQENABLEL_TX0_EMPTY_ENABLE_RESETVAL (0x0000u)
/*----TX0_EMPTY_ENABLE Tokens----*/
#define CSL_MCSPI_IRQENABLEL_TX0_EMPTY_ENABLE_DISABLE (0x0000u)
#define CSL_MCSPI_IRQENABLEL_TX0_EMPTY_ENABLE_ENABLE (0x0001u)

#define CSL_MCSPI_IRQENABLEL_RESETVAL    (0x0000u)

/* IRQENABLEU */


#define CSL_MCSPI_IRQENABLEU_EOWE_MASK   (0x0002u)
#define CSL_MCSPI_IRQENABLEU_EOWE_SHIFT  (0x0001u)
#define CSL_MCSPI_IRQENABLEU_EOWE_RESETVAL (0x0000u)
/*----EOWE Tokens----*/
#define CSL_MCSPI_IRQENABLEU_EOWE_DISABLE (0x0000u)
#define CSL_MCSPI_IRQENABLEU_EOWE_ENABLE (0x0001u)

#define CSL_MCSPI_IRQENABLEU_WKE_MASK    (0x0001u)
#define CSL_MCSPI_IRQENABLEU_WKE_SHIFT   (0x0000u)
#define CSL_MCSPI_IRQENABLEU_WKE_RESETVAL (0x0000u)
/*----WKE Tokens----*/
#define CSL_MCSPI_IRQENABLEU_WKE_DISABLE (0x0000u)
#define CSL_MCSPI_IRQENABLEU_WKE_ENABLE  (0x0001u)

#define CSL_MCSPI_IRQENABLEU_RESETVAL    (0x0000u)

/* WAKEUPENABLEL */


#define CSL_MCSPI_WAKEUPENABLEL_WKEN_MASK (0x0001u)
#define CSL_MCSPI_WAKEUPENABLEL_WKEN_SHIFT (0x0000u)
#define CSL_MCSPI_WAKEUPENABLEL_WKEN_RESETVAL (0x0000u)
/*----WKEN Tokens----*/
#define CSL_MCSPI_WAKEUPENABLEL_WKEN_NOTALLOW (0x0000u)
#define CSL_MCSPI_WAKEUPENABLEL_WKEN_ALLOW (0x0001u)

#define CSL_MCSPI_WAKEUPENABLEL_RESETVAL (0x0000u)

/* MODULCTRLL */


#define CSL_MCSPI_MODULCTRLL_FDAA_MASK   (0x0100u)
#define CSL_MCSPI_MODULCTRLL_FDAA_SHIFT  (0x0008u)
#define CSL_MCSPI_MODULCTRLL_FDAA_RESETVAL (0x0000u)
/*----FDAA Tokens----*/
#define CSL_MCSPI_MODULCTRLL_FDAA_TXREG  (0x0000u)
#define CSL_MCSPI_MODULCTRLL_FDAA_DAFTXREG (0x0001u)

#define CSL_MCSPI_MODULCTRLL_MOA_MASK    (0x0080u)
#define CSL_MCSPI_MODULCTRLL_MOA_SHIFT   (0x0007u)
#define CSL_MCSPI_MODULCTRLL_MOA_RESETVAL (0x0000u)
/*----MOA Tokens----*/
#define CSL_MCSPI_MODULCTRLL_MOA_DISABLE (0x0000u)
#define CSL_MCSPI_MODULCTRLL_MOA_ENABLE  (0x0001u)

#define CSL_MCSPI_MODULCTRLL_INITDLY_MASK (0x0070u)
#define CSL_MCSPI_MODULCTRLL_INITDLY_SHIFT (0x0004u)
#define CSL_MCSPI_MODULCTRLL_INITDLY_RESETVAL (0x0000u)
/*----INITDLY Tokens----*/
#define CSL_MCSPI_MODULCTRLL_INITDLY_NODELAY (0x0000u)
#define CSL_MCSPI_MODULCTRLL_INITDLY_4CLK (0x0001u)
#define CSL_MCSPI_MODULCTRLL_INITDLY_8CLK (0x0002u)
#define CSL_MCSPI_MODULCTRLL_INITDLY_16CLK (0x0003u)
#define CSL_MCSPI_MODULCTRLL_INITDLY_32CLK (0x0004u)

#define CSL_MCSPI_MODULCTRLL_SYSTEM_TEST_MASK (0x0008u)
#define CSL_MCSPI_MODULCTRLL_SYSTEM_TEST_SHIFT (0x0003u)
#define CSL_MCSPI_MODULCTRLL_SYSTEM_TEST_RESETVAL (0x0000u)
/*----SYSTEM_TEST Tokens----*/
#define CSL_MCSPI_MODULCTRLL_SYSTEM_TEST_FUNTIONAL (0x0000u)
#define CSL_MCSPI_MODULCTRLL_SYSTEM_TEST_SYSTEST (0x0001u)

#define CSL_MCSPI_MODULCTRLL_MS_MASK     (0x0004u)
#define CSL_MCSPI_MODULCTRLL_MS_SHIFT    (0x0002u)
#define CSL_MCSPI_MODULCTRLL_MS_RESETVAL (0x0001u)
/*----MS Tokens----*/
#define CSL_MCSPI_MODULCTRLL_MS_MASTER   (0x0000u)
#define CSL_MCSPI_MODULCTRLL_MS_SLAVE    (0x0001u)

#define CSL_MCSPI_MODULCTRLL_PIN34_MASK  (0x0002u)
#define CSL_MCSPI_MODULCTRLL_PIN34_SHIFT (0x0001u)
#define CSL_MCSPI_MODULCTRLL_PIN34_RESETVAL (0x0000u)
/*----PIN34 Tokens----*/
#define CSL_MCSPI_MODULCTRLL_PIN34_SPIENUSE (0x0000u)
#define CSL_MCSPI_MODULCTRLL_PIN34_SPIENNOTUSE (0x0001u)

#define CSL_MCSPI_MODULCTRLL_SINGLE_MASK (0x0001u)
#define CSL_MCSPI_MODULCTRLL_SINGLE_SHIFT (0x0000u)
#define CSL_MCSPI_MODULCTRLL_SINGLE_RESETVAL (0x0000u)
/*----SINGLE Tokens----*/
#define CSL_MCSPI_MODULCTRLL_SINGLE_MULTICH (0x0000u)
#define CSL_MCSPI_MODULCTRLL_SINGLE_SINGLECH (0x0001u)

#define CSL_MCSPI_MODULCTRLL_RESETVAL    (0x0004u)

/* CH0CONFL */

#define CSL_MCSPI_CH0CONFL_DMAR_MASK     (0x8000u)
#define CSL_MCSPI_CH0CONFL_DMAR_SHIFT    (0x000Fu)
#define CSL_MCSPI_CH0CONFL_DMAR_RESETVAL (0x0000u)
/*----DMAR Tokens----*/
#define CSL_MCSPI_CH0CONFL_DMAR_DISABLE  (0x0000u)
#define CSL_MCSPI_CH0CONFL_DMAR_ENABLE   (0x0001u)

#define CSL_MCSPI_CH0CONFL_DMAW_MASK     (0x4000u)
#define CSL_MCSPI_CH0CONFL_DMAW_SHIFT    (0x000Eu)
#define CSL_MCSPI_CH0CONFL_DMAW_RESETVAL (0x0000u)
/*----DMAW Tokens----*/
#define CSL_MCSPI_CH0CONFL_DMAW_DISABLE  (0x0000u)
#define CSL_MCSPI_CH0CONFL_DMAW_ENABLE   (0x0001u)

#define CSL_MCSPI_CH0CONFL_TRM_MASK      (0x3000u)
#define CSL_MCSPI_CH0CONFL_TRM_SHIFT     (0x000Cu)
#define CSL_MCSPI_CH0CONFL_TRM_RESETVAL  (0x0000u)
/*----TRM Tokens----*/
#define CSL_MCSPI_CH0CONFL_TRM_MODE0     (0x0000u)
#define CSL_MCSPI_CH0CONFL_TRM_MODE1     (0x0001u)
#define CSL_MCSPI_CH0CONFL_TRM_MODE2     (0x0002u)

#define CSL_MCSPI_CH0CONFL_WL_MASK       (0x0F80u)
#define CSL_MCSPI_CH0CONFL_WL_SHIFT      (0x0007u)
#define CSL_MCSPI_CH0CONFL_WL_RESETVAL   (0x0000u)
/*----WL Tokens----*/
#define CSL_MCSPI_CH0CONFL_WL_4BIT       (0x0003u)
#define CSL_MCSPI_CH0CONFL_WL_5BIT       (0x0004u)
#define CSL_MCSPI_CH0CONFL_WL_6BIT       (0x0005u)
#define CSL_MCSPI_CH0CONFL_WL_7BIT       (0x0006u)
#define CSL_MCSPI_CH0CONFL_WL_8BIT       (0x0007u)
#define CSL_MCSPI_CH0CONFL_WL_9BIT       (0x0008u)
#define CSL_MCSPI_CH0CONFL_WL_10BIT      (0x0009u)
#define CSL_MCSPI_CH0CONFL_WL_11BIT      (0x000au)
#define CSL_MCSPI_CH0CONFL_WL_12BIT      (0x000bu)
#define CSL_MCSPI_CH0CONFL_WL_13BIT      (0x000cu)
#define CSL_MCSPI_CH0CONFL_WL_14BIT      (0x000du)
#define CSL_MCSPI_CH0CONFL_WL_15BIT      (0x000eu)
#define CSL_MCSPI_CH0CONFL_WL_16BIT      (0x000fu)
#define CSL_MCSPI_CH0CONFL_WL_17BIT      (0x0010u)
#define CSL_MCSPI_CH0CONFL_WL_18BIT      (0x0011u)
#define CSL_MCSPI_CH0CONFL_WL_19BIT      (0x0012u)
#define CSL_MCSPI_CH0CONFL_WL_20BIT      (0x0013u)
#define CSL_MCSPI_CH0CONFL_WL_21BIT      (0x0014u)
#define CSL_MCSPI_CH0CONFL_WL_22BIT      (0x0015u)
#define CSL_MCSPI_CH0CONFL_WL_23BIT      (0x0016u)
#define CSL_MCSPI_CH0CONFL_WL_24BIT      (0x0017u)
#define CSL_MCSPI_CH0CONFL_WL_25BIT      (0x0018u)
#define CSL_MCSPI_CH0CONFL_WL_26BIT      (0x0019u)
#define CSL_MCSPI_CH0CONFL_WL_27BIT      (0x001au)
#define CSL_MCSPI_CH0CONFL_WL_28BIT      (0x001bu)
#define CSL_MCSPI_CH0CONFL_WL_29BIT      (0x001cu)
#define CSL_MCSPI_CH0CONFL_WL_30BIT      (0x001du)
#define CSL_MCSPI_CH0CONFL_WL_31BIT      (0x001eu)
#define CSL_MCSPI_CH0CONFL_WL_32BIT      (0x001fu)

#define CSL_MCSPI_CH0CONFL_EPOL_MASK     (0x0040u)
#define CSL_MCSPI_CH0CONFL_EPOL_SHIFT    (0x0006u)
#define CSL_MCSPI_CH0CONFL_EPOL_RESETVAL (0x0000u)
/*----EPOL Tokens----*/
#define CSL_MCSPI_CH0CONFL_EPOL_ACTIVEHIGH (0x0000u)
#define CSL_MCSPI_CH0CONFL_EPOL_ACTIVELOW (0x0001u)

#define CSL_MCSPI_CH0CONFL_CLKD_MASK     (0x003Cu)
#define CSL_MCSPI_CH0CONFL_CLKD_SHIFT    (0x0002u)
#define CSL_MCSPI_CH0CONFL_CLKD_RESETVAL (0x0000u)
/*----CLKD Tokens----*/
#define CSL_MCSPI_CH0CONFL_CLKD_DIV1     (0x0000u)
#define CSL_MCSPI_CH0CONFL_CLKD_DIV2     (0x0001u)
#define CSL_MCSPI_CH0CONFL_CLKD_DIV4     (0x0002u)
#define CSL_MCSPI_CH0CONFL_CLKD_DIV8     (0x0003u)
#define CSL_MCSPI_CH0CONFL_CLKD_DIV16    (0x0004u)
#define CSL_MCSPI_CH0CONFL_CLKD_DIV32    (0x0005u)
#define CSL_MCSPI_CH0CONFL_CLKD_DIV64    (0x0006u)
#define CSL_MCSPI_CH0CONFL_CLKD_DIV128   (0x0007u)
#define CSL_MCSPI_CH0CONFL_CLKD_DIV256   (0x0008u)
#define CSL_MCSPI_CH0CONFL_CLKD_DIV512   (0x0009u)
#define CSL_MCSPI_CH0CONFL_CLKD_DIV1024  (0x000au)
#define CSL_MCSPI_CH0CONFL_CLKD_DIV2048  (0x000bu)
#define CSL_MCSPI_CH0CONFL_CLKD_DIV4096  (0x000cu)
#define CSL_MCSPI_CH0CONFL_CLKD_DIV8192  (0x000du)
#define CSL_MCSPI_CH0CONFL_CLKD_DIV16384 (0x000eu)
#define CSL_MCSPI_CH0CONFL_CLKD_DIV32768 (0x000fu)

#define CSL_MCSPI_CH0CONFL_POL_MASK      (0x0002u)
#define CSL_MCSPI_CH0CONFL_POL_SHIFT     (0x0001u)
#define CSL_MCSPI_CH0CONFL_POL_RESETVAL  (0x0000u)
/*----POL Tokens----*/
#define CSL_MCSPI_CH0CONFL_POL_ACTIVEHIGH (0x0000u)
#define CSL_MCSPI_CH0CONFL_POL_ACTIVELOW (0x0001u)
#define CSL_MCSPI_CH0CONFL_POL_DIV1      (0x0000u)

#define CSL_MCSPI_CH0CONFL_PHA_MASK      (0x0001u)
#define CSL_MCSPI_CH0CONFL_PHA_SHIFT     (0x0000u)
#define CSL_MCSPI_CH0CONFL_PHA_RESETVAL  (0x0000u)
/*----PHA Tokens----*/
#define CSL_MCSPI_CH0CONFL_PHA_ODD       (0x0000u)
#define CSL_MCSPI_CH0CONFL_PHA_EVEN      (0x0001u)

#define CSL_MCSPI_CH0CONFL_RESETVAL      (0x0000u)

/* CH0CONFU */


#define CSL_MCSPI_CH0CONFU_CLKG_MASK     (0x2000u)
#define CSL_MCSPI_CH0CONFU_CLKG_SHIFT    (0x000Du)
#define CSL_MCSPI_CH0CONFU_CLKG_RESETVAL (0x0000u)
/*----CLKG Tokens----*/
#define CSL_MCSPI_CH0CONFU_CLKG_GRAN0    (0x0000u)
#define CSL_MCSPI_CH0CONFU_CLKG_GRAN1    (0x0001u)

#define CSL_MCSPI_CH0CONFU_FFER_MASK     (0x1000u)
#define CSL_MCSPI_CH0CONFU_FFER_SHIFT    (0x000Cu)
#define CSL_MCSPI_CH0CONFU_FFER_RESETVAL (0x0000u)
/*----FFER Tokens----*/
#define CSL_MCSPI_CH0CONFU_FFER_FIFONOTUSED (0x0000u)
#define CSL_MCSPI_CH0CONFU_FFER_FIFOUSED (0x0001u)

#define CSL_MCSPI_CH0CONFU_FFEW_MASK     (0x0800u)
#define CSL_MCSPI_CH0CONFU_FFEW_SHIFT    (0x000Bu)
#define CSL_MCSPI_CH0CONFU_FFEW_RESETVAL (0x0000u)
/*----FFEW Tokens----*/
#define CSL_MCSPI_CH0CONFU_FFEW_FIFONOTUSED (0x0000u)
#define CSL_MCSPI_CH0CONFU_FFEW_FIFOUSED (0x0001u)

#define CSL_MCSPI_CH0CONFU_TCS_MASK      (0x0600u)
#define CSL_MCSPI_CH0CONFU_TCS_SHIFT     (0x0009u)
#define CSL_MCSPI_CH0CONFU_TCS_RESETVAL  (0x0000u)
/*----TCS Tokens----*/
#define CSL_MCSPI_CH0CONFU_TCS_TIME0     (0x0000u)
#define CSL_MCSPI_CH0CONFU_TCS_TIME1     (0x0001u)
#define CSL_MCSPI_CH0CONFU_TCS_TIME2     (0x0002u)
#define CSL_MCSPI_CH0CONFU_TCS_TIME3     (0x0003u)

#define CSL_MCSPI_CH0CONFU_SBPOL_MASK    (0x0100u)
#define CSL_MCSPI_CH0CONFU_SBPOL_SHIFT   (0x0008u)
#define CSL_MCSPI_CH0CONFU_SBPOL_RESETVAL (0x0000u)
/*----SBPOL Tokens----*/
#define CSL_MCSPI_CH0CONFU_SBPOL_ACTIVELOW (0x0000u)
#define CSL_MCSPI_CH0CONFU_SBPOL_ATIVEHIGH (0x0001u)

#define CSL_MCSPI_CH0CONFU_SBE_MASK      (0x0080u)
#define CSL_MCSPI_CH0CONFU_SBE_SHIFT     (0x0007u)
#define CSL_MCSPI_CH0CONFU_SBE_RESETVAL  (0x0000u)
/*----SBE Tokens----*/
#define CSL_MCSPI_CH0CONFU_SBE_DEFAULT   (0x0000u)
#define CSL_MCSPI_CH0CONFU_SBE_ENABLE    (0x0001u)

#define CSL_MCSPI_CH0CONFU_SPIENSLV_MASK (0x0060u)
#define CSL_MCSPI_CH0CONFU_SPIENSLV_SHIFT (0x0005u)
#define CSL_MCSPI_CH0CONFU_SPIENSLV_RESETVAL (0x0000u)
/*----SPIENSLV Tokens----*/
#define CSL_MCSPI_CH0CONFU_SPIENSLV_DETSPIEN0 (0x0000u)
#define CSL_MCSPI_CH0CONFU_SPIENSLV_DETSPIEN1 (0x0001u)
#define CSL_MCSPI_CH0CONFU_SPIENSLV_DETSPIEN2 (0x0002u)
#define CSL_MCSPI_CH0CONFU_SPIENSLV_DETSPIEN3 (0x0003u)

#define CSL_MCSPI_CH0CONFU_FORCE_MASK    (0x0010u)
#define CSL_MCSPI_CH0CONFU_FORCE_SHIFT   (0x0004u)
#define CSL_MCSPI_CH0CONFU_FORCE_RESETVAL (0x0000u)
/*----FORCE Tokens----*/
#define CSL_MCSPI_CH0CONFU_FORCE_SPIENLOW (0x0000u)
#define CSL_MCSPI_CH0CONFU_FORCE_SPIENHIGH (0x0001u)

#define CSL_MCSPI_CH0CONFU_TURBO_MASK    (0x0008u)
#define CSL_MCSPI_CH0CONFU_TURBO_SHIFT   (0x0003u)
#define CSL_MCSPI_CH0CONFU_TURBO_RESETVAL (0x0000u)
/*----TURBO Tokens----*/
#define CSL_MCSPI_CH0CONFU_TURBO_DEACTIVATE (0x0000u)
#define CSL_MCSPI_CH0CONFU_TURBO_ACTIVATE (0x0001u)

#define CSL_MCSPI_CH0CONFU_IS_MASK       (0x0004u)
#define CSL_MCSPI_CH0CONFU_IS_SHIFT      (0x0002u)
#define CSL_MCSPI_CH0CONFU_IS_RESETVAL   (0x0001u)
/*----IS Tokens----*/
#define CSL_MCSPI_CH0CONFU_IS_LINE0      (0x0000u)
#define CSL_MCSPI_CH0CONFU_IS_LINE1      (0x0001u)

#define CSL_MCSPI_CH0CONFU_DPE1_MASK     (0x0002u)
#define CSL_MCSPI_CH0CONFU_DPE1_SHIFT    (0x0001u)
#define CSL_MCSPI_CH0CONFU_DPE1_RESETVAL (0x0001u)
/*----DPE1 Tokens----*/
#define CSL_MCSPI_CH0CONFU_DPE1_DATLINE1 (0x0000u)
#define CSL_MCSPI_CH0CONFU_DPE1_NOTRANSMISSON (0x0001u)

#define CSL_MCSPI_CH0CONFU_DPE0_MASK     (0x0001u)
#define CSL_MCSPI_CH0CONFU_DPE0_SHIFT    (0x0000u)
#define CSL_MCSPI_CH0CONFU_DPE0_RESETVAL (0x0000u)
/*----DPE0 Tokens----*/
#define CSL_MCSPI_CH0CONFU_DPE0_DATLINE0 (0x0000u)
#define CSL_MCSPI_CH0CONFU_DPE0_NOTRANSMISSON (0x0001u)

#define CSL_MCSPI_CH0CONFU_RESETVAL      (0x0006u)

/* CH0STATL */


#define CSL_MCSPI_CH0STATL_RXFFF_MASK    (0x0040u)
#define CSL_MCSPI_CH0STATL_RXFFF_SHIFT   (0x0006u)
#define CSL_MCSPI_CH0STATL_RXFFF_RESETVAL (0x0000u)
/*----RXFFF Tokens----*/
#define CSL_MCSPI_CH0STATL_RXFFF_NOTFULL (0x0000u)
#define CSL_MCSPI_CH0STATL_RXFFF_FULL    (0x0001u)

#define CSL_MCSPI_CH0STATL_RXFFE_MASK    (0x0020u)
#define CSL_MCSPI_CH0STATL_RXFFE_SHIFT   (0x0005u)
#define CSL_MCSPI_CH0STATL_RXFFE_RESETVAL (0x0000u)
/*----RXFFE Tokens----*/
#define CSL_MCSPI_CH0STATL_RXFFE_NOTEMPTY (0x0000u)
#define CSL_MCSPI_CH0STATL_RXFFE_EMPTY   (0x0001u)

#define CSL_MCSPI_CH0STATL_TXFFF_MASK    (0x0010u)
#define CSL_MCSPI_CH0STATL_TXFFF_SHIFT   (0x0004u)
#define CSL_MCSPI_CH0STATL_TXFFF_RESETVAL (0x0000u)
/*----TXFFF Tokens----*/
#define CSL_MCSPI_CH0STATL_TXFFF_NOTFULL (0x0000u)
#define CSL_MCSPI_CH0STATL_TXFFF_FULL    (0x0001u)

#define CSL_MCSPI_CH0STATL_TXFFE_MASK    (0x0008u)
#define CSL_MCSPI_CH0STATL_TXFFE_SHIFT   (0x0003u)
#define CSL_MCSPI_CH0STATL_TXFFE_RESETVAL (0x0000u)
/*----TXFFE Tokens----*/
#define CSL_MCSPI_CH0STATL_TXFFE_NOTEMPTY (0x0000u)
#define CSL_MCSPI_CH0STATL_TXFFE_EMPTY   (0x0001u)

#define CSL_MCSPI_CH0STATL_EOT_MASK      (0x0004u)
#define CSL_MCSPI_CH0STATL_EOT_SHIFT     (0x0002u)
#define CSL_MCSPI_CH0STATL_EOT_RESETVAL  (0x0000u)
/*----EOT Tokens----*/
#define CSL_MCSPI_CH0STATL_EOT_INPROGRESS (0x0000u)
#define CSL_MCSPI_CH0STATL_EOT_COMPLETED (0x0001u)

#define CSL_MCSPI_CH0STATL_TXS_MASK      (0x0002u)
#define CSL_MCSPI_CH0STATL_TXS_SHIFT     (0x0001u)
#define CSL_MCSPI_CH0STATL_TXS_RESETVAL  (0x0000u)
/*----TXS Tokens----*/
#define CSL_MCSPI_CH0STATL_TXS_FULL      (0x0000u)
#define CSL_MCSPI_CH0STATL_TXS_EMPTY     (0x0001u)

#define CSL_MCSPI_CH0STATL_RXS_MASK      (0x0001u)
#define CSL_MCSPI_CH0STATL_RXS_SHIFT     (0x0000u)
#define CSL_MCSPI_CH0STATL_RXS_RESETVAL  (0x0000u)
/*----RXS Tokens----*/
#define CSL_MCSPI_CH0STATL_RXS_EMPTY     (0x0000u)
#define CSL_MCSPI_CH0STATL_RXS_FULL      (0x0001u)

#define CSL_MCSPI_CH0STATL_RESETVAL      (0x0000u)

/* CH0CTRLL */

#define CSL_MCSPI_CH0CTRLL_EXTCLK_MASK   (0xFF00u)
#define CSL_MCSPI_CH0CTRLL_EXTCLK_SHIFT  (0x0008u)
#define CSL_MCSPI_CH0CTRLL_EXTCLK_RESETVAL (0x0000u)
/*----EXTCLK Tokens----*/
#define CSL_MCSPI_CH0CTRLL_EXTCLK_CLKRATIO1 (0x0000u)
#define CSL_MCSPI_CH0CTRLL_EXTCLK_CLKRATIO2 (0x0001u)
#define CSL_MCSPI_CH0CTRLL_EXTCLK_CLKRATIO3 (0x0002u)


#define CSL_MCSPI_CH0CTRLL_EN_MASK       (0x0001u)
#define CSL_MCSPI_CH0CTRLL_EN_SHIFT      (0x0000u)
#define CSL_MCSPI_CH0CTRLL_EN_RESETVAL   (0x0000u)
/*----EN Tokens----*/
#define CSL_MCSPI_CH0CTRLL_EN_DISABLE    (0x0000u)
#define CSL_MCSPI_CH0CTRLL_EN_ENABLE     (0x0001u)

#define CSL_MCSPI_CH0CTRLL_RESETVAL      (0x0000u)

/* CH0TXL */

#define CSL_MCSPI_CH0TXL_TDATA_MASK        (0xFFFFu)
#define CSL_MCSPI_CH0TXL_TDATA_SHIFT       (0x0000u)
#define CSL_MCSPI_CH0TXL_TDATA_RESETVAL    (0x0000u)

#define CSL_MCSPI_CH0TXL_RESETVAL          (0x0000u)

/* CH0TXU */

#define CSL_MCSPI_CH0TXU_TDATA_MASK        (0xFFFFu)
#define CSL_MCSPI_CH0TXU_TDATA_SHIFT       (0x0000u)
#define CSL_MCSPI_CH0TXU_TDATA_RESETVAL    (0x0000u)

#define CSL_MCSPI_CH0TXU_RESETVAL          (0x0000u)

/* CH0RXL */

#define CSL_MCSPI_CH0RXL_RDATA_MASK        (0xFFFFu)
#define CSL_MCSPI_CH0RXL_RDATA_SHIFT       (0x0000u)
#define CSL_MCSPI_CH0RXL_RDATA_RESETVAL    (0x0000u)

#define CSL_MCSPI_CH0RXL_RESETVAL          (0x0000u)

/* CH0RXU */

#define CSL_MCSPI_CH0RXU_RDATA_MASK        (0xFFFFu)
#define CSL_MCSPI_CH0RXU_RDATA_SHIFT       (0x0000u)
#define CSL_MCSPI_CH0RXU_RDATA_RESETVAL    (0x0000u)

#define CSL_MCSPI_CH0RXU_RESETVAL          (0x0000u)

/* CH1CONFL */

#define CSL_MCSPI_CH1CONFL_DMAR_MASK     (0x8000u)
#define CSL_MCSPI_CH1CONFL_DMAR_SHIFT    (0x000Fu)
#define CSL_MCSPI_CH1CONFL_DMAR_RESETVAL (0x0000u)
/*----DMAR Tokens----*/
#define CSL_MCSPI_CH1CONFL_DMAR_DISABLE  (0x0000u)
#define CSL_MCSPI_CH1CONFL_DMAR_ENABLE   (0x0001u)

#define CSL_MCSPI_CH1CONFL_DMAW_MASK     (0x4000u)
#define CSL_MCSPI_CH1CONFL_DMAW_SHIFT    (0x000Eu)
#define CSL_MCSPI_CH1CONFL_DMAW_RESETVAL (0x0000u)
/*----DMAW Tokens----*/
#define CSL_MCSPI_CH1CONFL_DMAW_DISABLE  (0x0000u)
#define CSL_MCSPI_CH1CONFL_DMAW_ENABLE   (0x0001u)

#define CSL_MCSPI_CH1CONFL_TRM_MASK      (0x3000u)
#define CSL_MCSPI_CH1CONFL_TRM_SHIFT     (0x000Cu)
#define CSL_MCSPI_CH1CONFL_TRM_RESETVAL  (0x0000u)
/*----TRM Tokens----*/
#define CSL_MCSPI_CH1CONFL_TRM_MODE0     (0x0000u)
#define CSL_MCSPI_CH1CONFL_TRM_MODE1     (0x0001u)
#define CSL_MCSPI_CH1CONFL_TRM_MODE2     (0x0002u)

#define CSL_MCSPI_CH1CONFL_WL_MASK       (0x0F80u)
#define CSL_MCSPI_CH1CONFL_WL_SHIFT      (0x0007u)
#define CSL_MCSPI_CH1CONFL_WL_RESETVAL   (0x0000u)
/*----WL Tokens----*/
#define CSL_MCSPI_CH1CONFL_WL_4BIT       (0x0003u)
#define CSL_MCSPI_CH1CONFL_WL_5BIT       (0x0004u)
#define CSL_MCSPI_CH1CONFL_WL_6BIT       (0x0005u)
#define CSL_MCSPI_CH1CONFL_WL_7BIT       (0x0006u)
#define CSL_MCSPI_CH1CONFL_WL_8BIT       (0x0007u)
#define CSL_MCSPI_CH1CONFL_WL_9BIT       (0x0008u)
#define CSL_MCSPI_CH1CONFL_WL_10BIT      (0x0009u)
#define CSL_MCSPI_CH1CONFL_WL_11BIT      (0x000au)
#define CSL_MCSPI_CH1CONFL_WL_12BIT      (0x000bu)
#define CSL_MCSPI_CH1CONFL_WL_13BIT      (0x000cu)
#define CSL_MCSPI_CH1CONFL_WL_14BIT      (0x000du)
#define CSL_MCSPI_CH1CONFL_WL_15BIT      (0x000eu)
#define CSL_MCSPI_CH1CONFL_WL_16BIT      (0x000fu)
#define CSL_MCSPI_CH1CONFL_WL_17BIT      (0x0010u)
#define CSL_MCSPI_CH1CONFL_WL_18BIT      (0x0011u)
#define CSL_MCSPI_CH1CONFL_WL_19BIT      (0x0012u)
#define CSL_MCSPI_CH1CONFL_WL_20BIT      (0x0013u)
#define CSL_MCSPI_CH1CONFL_WL_21BIT      (0x0014u)
#define CSL_MCSPI_CH1CONFL_WL_22BIT      (0x0015u)
#define CSL_MCSPI_CH1CONFL_WL_23BIT      (0x0016u)
#define CSL_MCSPI_CH1CONFL_WL_24BIT      (0x0017u)
#define CSL_MCSPI_CH1CONFL_WL_25BIT      (0x0018u)
#define CSL_MCSPI_CH1CONFL_WL_26BIT      (0x0019u)
#define CSL_MCSPI_CH1CONFL_WL_27BIT      (0x001au)
#define CSL_MCSPI_CH1CONFL_WL_28BIT      (0x001bu)
#define CSL_MCSPI_CH1CONFL_WL_29BIT      (0x001cu)
#define CSL_MCSPI_CH1CONFL_WL_30BIT      (0x001du)
#define CSL_MCSPI_CH1CONFL_WL_31BIT      (0x001eu)
#define CSL_MCSPI_CH1CONFL_WL_32BIT      (0x001fu)

#define CSL_MCSPI_CH1CONFL_EPOL_MASK     (0x0040u)
#define CSL_MCSPI_CH1CONFL_EPOL_SHIFT    (0x0006u)
#define CSL_MCSPI_CH1CONFL_EPOL_RESETVAL (0x0000u)
/*----EPOL Tokens----*/
#define CSL_MCSPI_CH1CONFL_EPOL_ACTIVEHIGH (0x0000u)
#define CSL_MCSPI_CH1CONFL_EPOL_ACTIVELOW (0x0001u)

#define CSL_MCSPI_CH1CONFL_CLKD_MASK     (0x003Cu)
#define CSL_MCSPI_CH1CONFL_CLKD_SHIFT    (0x0002u)
#define CSL_MCSPI_CH1CONFL_CLKD_RESETVAL (0x0000u)
/*----CLKD Tokens----*/
#define CSL_MCSPI_CH1CONFL_CLKD_DIV1     (0x0000u)
#define CSL_MCSPI_CH1CONFL_CLKD_DIV2     (0x0001u)
#define CSL_MCSPI_CH1CONFL_CLKD_DIV4     (0x0002u)
#define CSL_MCSPI_CH1CONFL_CLKD_DIV8     (0x0003u)
#define CSL_MCSPI_CH1CONFL_CLKD_DIV16    (0x0004u)
#define CSL_MCSPI_CH1CONFL_CLKD_DIV32    (0x0005u)
#define CSL_MCSPI_CH1CONFL_CLKD_DIV64    (0x0006u)
#define CSL_MCSPI_CH1CONFL_CLKD_DIV128   (0x0007u)
#define CSL_MCSPI_CH1CONFL_CLKD_DIV256   (0x0008u)
#define CSL_MCSPI_CH1CONFL_CLKD_DIV512   (0x0009u)
#define CSL_MCSPI_CH1CONFL_CLKD_DIV1024  (0x000au)
#define CSL_MCSPI_CH1CONFL_CLKD_DIV2048  (0x000bu)
#define CSL_MCSPI_CH1CONFL_CLKD_DIV4096  (0x000cu)
#define CSL_MCSPI_CH1CONFL_CLKD_DIV8192  (0x000du)
#define CSL_MCSPI_CH1CONFL_CLKD_DIV16384 (0x000eu)
#define CSL_MCSPI_CH1CONFL_CLKD_DIV32768 (0x000fu)

#define CSL_MCSPI_CH1CONFL_POL_MASK      (0x0002u)
#define CSL_MCSPI_CH1CONFL_POL_SHIFT     (0x0001u)
#define CSL_MCSPI_CH1CONFL_POL_RESETVAL  (0x0000u)
/*----POL Tokens----*/
#define CSL_MCSPI_CH1CONFL_POL_ACTIVEHIGH (0x0000u)
#define CSL_MCSPI_CH1CONFL_POL_ACTIVELOW (0x0001u)
#define CSL_MCSPI_CH1CONFL_POL_DIV1      (0x0000u)

#define CSL_MCSPI_CH1CONFL_PHA_MASK      (0x0001u)
#define CSL_MCSPI_CH1CONFL_PHA_SHIFT     (0x0000u)
#define CSL_MCSPI_CH1CONFL_PHA_RESETVAL  (0x0000u)
/*----PHA Tokens----*/
#define CSL_MCSPI_CH1CONFL_PHA_ODD       (0x0000u)
#define CSL_MCSPI_CH1CONFL_PHA_EVEN      (0x0001u)

#define CSL_MCSPI_CH1CONFL_RESETVAL      (0x0000u)

/* CH1CONFU */


#define CSL_MCSPI_CH1CONFU_CLKG_MASK     (0x2000u)
#define CSL_MCSPI_CH1CONFU_CLKG_SHIFT    (0x000Du)
#define CSL_MCSPI_CH1CONFU_CLKG_RESETVAL (0x0000u)
/*----CLKG Tokens----*/
#define CSL_MCSPI_CH1CONFU_CLKG_GRAN0    (0x0000u)
#define CSL_MCSPI_CH1CONFU_CLKG_GRAN1    (0x0001u)

#define CSL_MCSPI_CH1CONFU_FFER_MASK     (0x1000u)
#define CSL_MCSPI_CH1CONFU_FFER_SHIFT    (0x000Cu)
#define CSL_MCSPI_CH1CONFU_FFER_RESETVAL (0x0000u)
/*----FFER Tokens----*/
#define CSL_MCSPI_CH1CONFU_FFER_FIFONOTUSED (0x0000u)
#define CSL_MCSPI_CH1CONFU_FFER_FIFOUSED (0x0001u)

#define CSL_MCSPI_CH1CONFU_FFEW_MASK     (0x0800u)
#define CSL_MCSPI_CH1CONFU_FFEW_SHIFT    (0x000Bu)
#define CSL_MCSPI_CH1CONFU_FFEW_RESETVAL (0x0000u)
/*----FFEW Tokens----*/
#define CSL_MCSPI_CH1CONFU_FFEW_FIFONOTUSED (0x0000u)
#define CSL_MCSPI_CH1CONFU_FFEW_FIFOUSED (0x0001u)

#define CSL_MCSPI_CH1CONFU_TCS_MASK      (0x0600u)
#define CSL_MCSPI_CH1CONFU_TCS_SHIFT     (0x0009u)
#define CSL_MCSPI_CH1CONFU_TCS_RESETVAL  (0x0000u)
/*----TCS Tokens----*/
#define CSL_MCSPI_CH1CONFU_TCS_TIME0     (0x0000u)
#define CSL_MCSPI_CH1CONFU_TCS_TIME1     (0x0001u)
#define CSL_MCSPI_CH1CONFU_TCS_TIME2     (0x0002u)
#define CSL_MCSPI_CH1CONFU_TCS_TIME3     (0x0003u)

#define CSL_MCSPI_CH1CONFU_SBPOL_MASK    (0x0100u)
#define CSL_MCSPI_CH1CONFU_SBPOL_SHIFT   (0x0008u)
#define CSL_MCSPI_CH1CONFU_SBPOL_RESETVAL (0x0000u)
/*----SBPOL Tokens----*/
#define CSL_MCSPI_CH1CONFU_SBPOL_ACTIVELOW (0x0000u)
#define CSL_MCSPI_CH1CONFU_SBPOL_ATIVEHIGH (0x0001u)

#define CSL_MCSPI_CH1CONFU_SBE_MASK      (0x0080u)
#define CSL_MCSPI_CH1CONFU_SBE_SHIFT     (0x0007u)
#define CSL_MCSPI_CH1CONFU_SBE_RESETVAL  (0x0000u)
/*----SBE Tokens----*/
#define CSL_MCSPI_CH1CONFU_SBE_DEFAULT   (0x0000u)
#define CSL_MCSPI_CH1CONFU_SBE_ENABLE    (0x0001u)

#define CSL_MCSPI_CH1CONFU_SPIENSLV_MASK (0x0060u)
#define CSL_MCSPI_CH1CONFU_SPIENSLV_SHIFT (0x0005u)
#define CSL_MCSPI_CH1CONFU_SPIENSLV_RESETVAL (0x0000u)
/*----SPIENSLV Tokens----*/
#define CSL_MCSPI_CH1CONFU_SPIENSLV_DETSPIEN0 (0x0000u)
#define CSL_MCSPI_CH1CONFU_SPIENSLV_DETSPIEN1 (0x0001u)
#define CSL_MCSPI_CH1CONFU_SPIENSLV_DETSPIEN2 (0x0002u)
#define CSL_MCSPI_CH1CONFU_SPIENSLV_DETSPIEN3 (0x0003u)

#define CSL_MCSPI_CH1CONFU_FORCE_MASK    (0x0010u)
#define CSL_MCSPI_CH1CONFU_FORCE_SHIFT   (0x0004u)
#define CSL_MCSPI_CH1CONFU_FORCE_RESETVAL (0x0000u)
/*----FORCE Tokens----*/
#define CSL_MCSPI_CH1CONFU_FORCE_SPIENLOW (0x0000u)
#define CSL_MCSPI_CH1CONFU_FORCE_SPIENHIGH (0x0001u)

#define CSL_MCSPI_CH1CONFU_TURBO_MASK    (0x0008u)
#define CSL_MCSPI_CH1CONFU_TURBO_SHIFT   (0x0003u)
#define CSL_MCSPI_CH1CONFU_TURBO_RESETVAL (0x0000u)
/*----TURBO Tokens----*/
#define CSL_MCSPI_CH1CONFU_TURBO_DEACTIVATE (0x0000u)
#define CSL_MCSPI_CH1CONFU_TURBO_ACTIVATE (0x0001u)

#define CSL_MCSPI_CH1CONFU_IS_MASK       (0x0004u)
#define CSL_MCSPI_CH1CONFU_IS_SHIFT      (0x0002u)
#define CSL_MCSPI_CH1CONFU_IS_RESETVAL   (0x0001u)
/*----IS Tokens----*/
#define CSL_MCSPI_CH1CONFU_IS_LINE0      (0x0000u)
#define CSL_MCSPI_CH1CONFU_IS_LINE1      (0x0001u)

#define CSL_MCSPI_CH1CONFU_DPE1_MASK     (0x0002u)
#define CSL_MCSPI_CH1CONFU_DPE1_SHIFT    (0x0001u)
#define CSL_MCSPI_CH1CONFU_DPE1_RESETVAL (0x0001u)
/*----DPE1 Tokens----*/
#define CSL_MCSPI_CH1CONFU_DPE1_DATLINE1 (0x0000u)
#define CSL_MCSPI_CH1CONFU_DPE1_NOTRANSMISSON (0x0001u)

#define CSL_MCSPI_CH1CONFU_DPE0_MASK     (0x0001u)
#define CSL_MCSPI_CH1CONFU_DPE0_SHIFT    (0x0000u)
#define CSL_MCSPI_CH1CONFU_DPE0_RESETVAL (0x0000u)
/*----DPE0 Tokens----*/
#define CSL_MCSPI_CH1CONFU_DPE0_DATLINE0 (0x0000u)
#define CSL_MCSPI_CH1CONFU_DPE0_NOTRANSMISSON (0x0001u)

#define CSL_MCSPI_CH1CONFU_RESETVAL      (0x0006u)

/* CH1STATL */


#define CSL_MCSPI_CH1STATL_RXFFF_MASK    (0x0040u)
#define CSL_MCSPI_CH1STATL_RXFFF_SHIFT   (0x0006u)
#define CSL_MCSPI_CH1STATL_RXFFF_RESETVAL (0x0000u)
/*----RXFFF Tokens----*/
#define CSL_MCSPI_CH1STATL_RXFFF_NOTFULL (0x0000u)
#define CSL_MCSPI_CH1STATL_RXFFF_FULL    (0x0001u)

#define CSL_MCSPI_CH1STATL_RXFFE_MASK    (0x0020u)
#define CSL_MCSPI_CH1STATL_RXFFE_SHIFT   (0x0005u)
#define CSL_MCSPI_CH1STATL_RXFFE_RESETVAL (0x0000u)
/*----RXFFE Tokens----*/
#define CSL_MCSPI_CH1STATL_RXFFE_NOTEMPTY (0x0000u)
#define CSL_MCSPI_CH1STATL_RXFFE_EMPTY   (0x0001u)

#define CSL_MCSPI_CH1STATL_TXFFF_MASK    (0x0010u)
#define CSL_MCSPI_CH1STATL_TXFFF_SHIFT   (0x0004u)
#define CSL_MCSPI_CH1STATL_TXFFF_RESETVAL (0x0000u)
/*----TXFFF Tokens----*/
#define CSL_MCSPI_CH1STATL_TXFFF_NOTFULL (0x0000u)
#define CSL_MCSPI_CH1STATL_TXFFF_FULL    (0x0001u)

#define CSL_MCSPI_CH1STATL_TXFFE_MASK    (0x0008u)
#define CSL_MCSPI_CH1STATL_TXFFE_SHIFT   (0x0003u)
#define CSL_MCSPI_CH1STATL_TXFFE_RESETVAL (0x0000u)
/*----TXFFE Tokens----*/
#define CSL_MCSPI_CH1STATL_TXFFE_NOTEMPTY (0x0000u)
#define CSL_MCSPI_CH1STATL_TXFFE_EMPTY   (0x0001u)

#define CSL_MCSPI_CH1STATL_EOT_MASK      (0x0004u)
#define CSL_MCSPI_CH1STATL_EOT_SHIFT     (0x0002u)
#define CSL_MCSPI_CH1STATL_EOT_RESETVAL  (0x0000u)
/*----EOT Tokens----*/
#define CSL_MCSPI_CH1STATL_EOT_INPROGRESS (0x0000u)
#define CSL_MCSPI_CH1STATL_EOT_COMPLETED (0x0001u)

#define CSL_MCSPI_CH1STATL_TXS_MASK      (0x0002u)
#define CSL_MCSPI_CH1STATL_TXS_SHIFT     (0x0001u)
#define CSL_MCSPI_CH1STATL_TXS_RESETVAL  (0x0000u)
/*----TXS Tokens----*/
#define CSL_MCSPI_CH1STATL_TXS_FULL      (0x0000u)
#define CSL_MCSPI_CH1STATL_TXS_EMPTY     (0x0001u)

#define CSL_MCSPI_CH1STATL_RXS_MASK      (0x0001u)
#define CSL_MCSPI_CH1STATL_RXS_SHIFT     (0x0000u)
#define CSL_MCSPI_CH1STATL_RXS_RESETVAL  (0x0000u)
/*----RXS Tokens----*/
#define CSL_MCSPI_CH1STATL_RXS_EMPTY     (0x0000u)
#define CSL_MCSPI_CH1STATL_RXS_FULL      (0x0001u)

#define CSL_MCSPI_CH1STATL_RESETVAL      (0x0000u)

/* CH1CTRLL */

#define CSL_MCSPI_CH1CTRLL_EXTCLK_MASK   (0xFF00u)
#define CSL_MCSPI_CH1CTRLL_EXTCLK_SHIFT  (0x0008u)
#define CSL_MCSPI_CH1CTRLL_EXTCLK_RESETVAL (0x0000u)
/*----EXTCLK Tokens----*/
#define CSL_MCSPI_CH1CTRLL_EXTCLK_CLKRATIO1 (0x0000u)
#define CSL_MCSPI_CH1CTRLL_EXTCLK_CLKRATIO2 (0x0001u)
#define CSL_MCSPI_CH1CTRLL_EXTCLK_CLKRATIO3 (0x0002u)


#define CSL_MCSPI_CH1CTRLL_EN_MASK       (0x0001u)
#define CSL_MCSPI_CH1CTRLL_EN_SHIFT      (0x0000u)
#define CSL_MCSPI_CH1CTRLL_EN_RESETVAL   (0x0000u)
/*----EN Tokens----*/
#define CSL_MCSPI_CH1CTRLL_EN_DISABLE    (0x0000u)
#define CSL_MCSPI_CH1CTRLL_EN_ENABLE     (0x0001u)

#define CSL_MCSPI_CH1CTRLL_RESETVAL      (0x0000u)

/* CH1TXL */

#define CSL_MCSPI_CH1TXL_TDATA_MASK        (0xFFFFu)
#define CSL_MCSPI_CH1TXL_TDATA_SHIFT       (0x0000u)
#define CSL_MCSPI_CH1TXL_TDATA_RESETVAL    (0x0000u)

#define CSL_MCSPI_CH1TXL_RESETVAL          (0x0000u)

/* CH1TXU */

#define CSL_MCSPI_CH1TXU_TDATA_MASK        (0xFFFFu)
#define CSL_MCSPI_CH1TXU_TDATA_SHIFT       (0x0000u)
#define CSL_MCSPI_CH1TXU_TDATA_RESETVAL    (0x0000u)

#define CSL_MCSPI_CH1TXU_RESETVAL          (0x0000u)

/* CH1RXL */

#define CSL_MCSPI_CH1RXL_RDATA_MASK        (0xFFFFu)
#define CSL_MCSPI_CH1RXL_RDATA_SHIFT       (0x0000u)
#define CSL_MCSPI_CH1RXL_RDATA_RESETVAL    (0x0000u)

#define CSL_MCSPI_CH1RXL_RESETVAL          (0x0000u)

/* CH1RXU */

#define CSL_MCSPI_CH1RXU_RDATA_MASK        (0xFFFFu)
#define CSL_MCSPI_CH1RXU_RDATA_SHIFT       (0x0000u)
#define CSL_MCSPI_CH1RXU_RDATA_RESETVAL    (0x0000u)

#define CSL_MCSPI_CH1RXU_RESETVAL          (0x0000u)

/* CH2CONFL */

#define CSL_MCSPI_CH2CONFL_DMAR_MASK     (0x8000u)
#define CSL_MCSPI_CH2CONFL_DMAR_SHIFT    (0x000Fu)
#define CSL_MCSPI_CH2CONFL_DMAR_RESETVAL (0x0000u)
/*----DMAR Tokens----*/
#define CSL_MCSPI_CH2CONFL_DMAR_DISABLE  (0x0000u)
#define CSL_MCSPI_CH2CONFL_DMAR_ENABLE   (0x0001u)

#define CSL_MCSPI_CH2CONFL_DMAW_MASK     (0x4000u)
#define CSL_MCSPI_CH2CONFL_DMAW_SHIFT    (0x000Eu)
#define CSL_MCSPI_CH2CONFL_DMAW_RESETVAL (0x0000u)
/*----DMAW Tokens----*/
#define CSL_MCSPI_CH2CONFL_DMAW_DISABLE  (0x0000u)
#define CSL_MCSPI_CH2CONFL_DMAW_ENABLE   (0x0001u)

#define CSL_MCSPI_CH2CONFL_TRM_MASK      (0x3000u)
#define CSL_MCSPI_CH2CONFL_TRM_SHIFT     (0x000Cu)
#define CSL_MCSPI_CH2CONFL_TRM_RESETVAL  (0x0000u)
/*----TRM Tokens----*/
#define CSL_MCSPI_CH2CONFL_TRM_MODE0     (0x0000u)
#define CSL_MCSPI_CH2CONFL_TRM_MODE1     (0x0001u)
#define CSL_MCSPI_CH2CONFL_TRM_MODE2     (0x0002u)

#define CSL_MCSPI_CH2CONFL_WL_MASK       (0x0F80u)
#define CSL_MCSPI_CH2CONFL_WL_SHIFT      (0x0007u)
#define CSL_MCSPI_CH2CONFL_WL_RESETVAL   (0x0000u)
/*----WL Tokens----*/
#define CSL_MCSPI_CH2CONFL_WL_4BIT       (0x0003u)
#define CSL_MCSPI_CH2CONFL_WL_5BIT       (0x0004u)
#define CSL_MCSPI_CH2CONFL_WL_6BIT       (0x0005u)
#define CSL_MCSPI_CH2CONFL_WL_7BIT       (0x0006u)
#define CSL_MCSPI_CH2CONFL_WL_8BIT       (0x0007u)
#define CSL_MCSPI_CH2CONFL_WL_9BIT       (0x0008u)
#define CSL_MCSPI_CH2CONFL_WL_10BIT      (0x0009u)
#define CSL_MCSPI_CH2CONFL_WL_11BIT      (0x000au)
#define CSL_MCSPI_CH2CONFL_WL_12BIT      (0x000bu)
#define CSL_MCSPI_CH2CONFL_WL_13BIT      (0x000cu)
#define CSL_MCSPI_CH2CONFL_WL_14BIT      (0x000du)
#define CSL_MCSPI_CH2CONFL_WL_15BIT      (0x000eu)
#define CSL_MCSPI_CH2CONFL_WL_16BIT      (0x000fu)
#define CSL_MCSPI_CH2CONFL_WL_17BIT      (0x0010u)
#define CSL_MCSPI_CH2CONFL_WL_18BIT      (0x0011u)
#define CSL_MCSPI_CH2CONFL_WL_19BIT      (0x0012u)
#define CSL_MCSPI_CH2CONFL_WL_20BIT      (0x0013u)
#define CSL_MCSPI_CH2CONFL_WL_21BIT      (0x0014u)
#define CSL_MCSPI_CH2CONFL_WL_22BIT      (0x0015u)
#define CSL_MCSPI_CH2CONFL_WL_23BIT      (0x0016u)
#define CSL_MCSPI_CH2CONFL_WL_24BIT      (0x0017u)
#define CSL_MCSPI_CH2CONFL_WL_25BIT      (0x0018u)
#define CSL_MCSPI_CH2CONFL_WL_26BIT      (0x0019u)
#define CSL_MCSPI_CH2CONFL_WL_27BIT      (0x001au)
#define CSL_MCSPI_CH2CONFL_WL_28BIT      (0x001bu)
#define CSL_MCSPI_CH2CONFL_WL_29BIT      (0x001cu)
#define CSL_MCSPI_CH2CONFL_WL_30BIT      (0x001du)
#define CSL_MCSPI_CH2CONFL_WL_31BIT      (0x001eu)
#define CSL_MCSPI_CH2CONFL_WL_32BIT      (0x001fu)

#define CSL_MCSPI_CH2CONFL_EPOL_MASK     (0x0040u)
#define CSL_MCSPI_CH2CONFL_EPOL_SHIFT    (0x0006u)
#define CSL_MCSPI_CH2CONFL_EPOL_RESETVAL (0x0000u)
/*----EPOL Tokens----*/
#define CSL_MCSPI_CH2CONFL_EPOL_ACTIVEHIGH (0x0000u)
#define CSL_MCSPI_CH2CONFL_EPOL_ACTIVELOW (0x0001u)

#define CSL_MCSPI_CH2CONFL_CLKD_MASK     (0x003Cu)
#define CSL_MCSPI_CH2CONFL_CLKD_SHIFT    (0x0002u)
#define CSL_MCSPI_CH2CONFL_CLKD_RESETVAL (0x0000u)
/*----CLKD Tokens----*/
#define CSL_MCSPI_CH2CONFL_CLKD_DIV1     (0x0000u)
#define CSL_MCSPI_CH2CONFL_CLKD_DIV2     (0x0001u)
#define CSL_MCSPI_CH2CONFL_CLKD_DIV4     (0x0002u)
#define CSL_MCSPI_CH2CONFL_CLKD_DIV8     (0x0003u)
#define CSL_MCSPI_CH2CONFL_CLKD_DIV16    (0x0004u)
#define CSL_MCSPI_CH2CONFL_CLKD_DIV32    (0x0005u)
#define CSL_MCSPI_CH2CONFL_CLKD_DIV64    (0x0006u)
#define CSL_MCSPI_CH2CONFL_CLKD_DIV128   (0x0007u)
#define CSL_MCSPI_CH2CONFL_CLKD_DIV256   (0x0008u)
#define CSL_MCSPI_CH2CONFL_CLKD_DIV512   (0x0009u)
#define CSL_MCSPI_CH2CONFL_CLKD_DIV1024  (0x000au)
#define CSL_MCSPI_CH2CONFL_CLKD_DIV2048  (0x000bu)
#define CSL_MCSPI_CH2CONFL_CLKD_DIV4096  (0x000cu)
#define CSL_MCSPI_CH2CONFL_CLKD_DIV8192  (0x000du)
#define CSL_MCSPI_CH2CONFL_CLKD_DIV16384 (0x000eu)
#define CSL_MCSPI_CH2CONFL_CLKD_DIV32768 (0x000fu)

#define CSL_MCSPI_CH2CONFL_POL_MASK      (0x0002u)
#define CSL_MCSPI_CH2CONFL_POL_SHIFT     (0x0001u)
#define CSL_MCSPI_CH2CONFL_POL_RESETVAL  (0x0000u)
/*----POL Tokens----*/
#define CSL_MCSPI_CH2CONFL_POL_ACTIVEHIGH (0x0000u)
#define CSL_MCSPI_CH2CONFL_POL_ACTIVELOW (0x0001u)
#define CSL_MCSPI_CH2CONFL_POL_DIV1      (0x0000u)

#define CSL_MCSPI_CH2CONFL_PHA_MASK      (0x0001u)
#define CSL_MCSPI_CH2CONFL_PHA_SHIFT     (0x0000u)
#define CSL_MCSPI_CH2CONFL_PHA_RESETVAL  (0x0000u)
/*----PHA Tokens----*/
#define CSL_MCSPI_CH2CONFL_PHA_ODD       (0x0000u)
#define CSL_MCSPI_CH2CONFL_PHA_EVEN      (0x0001u)

#define CSL_MCSPI_CH2CONFL_RESETVAL      (0x0000u)

/* CH2CONFU */


#define CSL_MCSPI_CH2CONFU_CLKG_MASK     (0x2000u)
#define CSL_MCSPI_CH2CONFU_CLKG_SHIFT    (0x000Du)
#define CSL_MCSPI_CH2CONFU_CLKG_RESETVAL (0x0000u)
/*----CLKG Tokens----*/
#define CSL_MCSPI_CH2CONFU_CLKG_GRAN0    (0x0000u)
#define CSL_MCSPI_CH2CONFU_CLKG_GRAN1    (0x0001u)

#define CSL_MCSPI_CH2CONFU_FFER_MASK     (0x1000u)
#define CSL_MCSPI_CH2CONFU_FFER_SHIFT    (0x000Cu)
#define CSL_MCSPI_CH2CONFU_FFER_RESETVAL (0x0000u)
/*----FFER Tokens----*/
#define CSL_MCSPI_CH2CONFU_FFER_FIFONOTUSED (0x0000u)
#define CSL_MCSPI_CH2CONFU_FFER_FIFOUSED (0x0001u)

#define CSL_MCSPI_CH2CONFU_FFEW_MASK     (0x0800u)
#define CSL_MCSPI_CH2CONFU_FFEW_SHIFT    (0x000Bu)
#define CSL_MCSPI_CH2CONFU_FFEW_RESETVAL (0x0000u)
/*----FFEW Tokens----*/
#define CSL_MCSPI_CH2CONFU_FFEW_FIFONOTUSED (0x0000u)
#define CSL_MCSPI_CH2CONFU_FFEW_FIFOUSED (0x0001u)

#define CSL_MCSPI_CH2CONFU_TCS_MASK      (0x0600u)
#define CSL_MCSPI_CH2CONFU_TCS_SHIFT     (0x0009u)
#define CSL_MCSPI_CH2CONFU_TCS_RESETVAL  (0x0000u)
/*----TCS Tokens----*/
#define CSL_MCSPI_CH2CONFU_TCS_TIME0     (0x0000u)
#define CSL_MCSPI_CH2CONFU_TCS_TIME1     (0x0001u)
#define CSL_MCSPI_CH2CONFU_TCS_TIME2     (0x0002u)
#define CSL_MCSPI_CH2CONFU_TCS_TIME3     (0x0003u)

#define CSL_MCSPI_CH2CONFU_SBPOL_MASK    (0x0100u)
#define CSL_MCSPI_CH2CONFU_SBPOL_SHIFT   (0x0008u)
#define CSL_MCSPI_CH2CONFU_SBPOL_RESETVAL (0x0000u)
/*----SBPOL Tokens----*/
#define CSL_MCSPI_CH2CONFU_SBPOL_ACTIVELOW (0x0000u)
#define CSL_MCSPI_CH2CONFU_SBPOL_ATIVEHIGH (0x0001u)

#define CSL_MCSPI_CH2CONFU_SBE_MASK      (0x0080u)
#define CSL_MCSPI_CH2CONFU_SBE_SHIFT     (0x0007u)
#define CSL_MCSPI_CH2CONFU_SBE_RESETVAL  (0x0000u)
/*----SBE Tokens----*/
#define CSL_MCSPI_CH2CONFU_SBE_DEFAULT   (0x0000u)
#define CSL_MCSPI_CH2CONFU_SBE_ENABLE    (0x0001u)

#define CSL_MCSPI_CH2CONFU_SPIENSLV_MASK (0x0060u)
#define CSL_MCSPI_CH2CONFU_SPIENSLV_SHIFT (0x0005u)
#define CSL_MCSPI_CH2CONFU_SPIENSLV_RESETVAL (0x0000u)
/*----SPIENSLV Tokens----*/
#define CSL_MCSPI_CH2CONFU_SPIENSLV_DETSPIEN0 (0x0000u)
#define CSL_MCSPI_CH2CONFU_SPIENSLV_DETSPIEN1 (0x0001u)
#define CSL_MCSPI_CH2CONFU_SPIENSLV_DETSPIEN2 (0x0002u)
#define CSL_MCSPI_CH2CONFU_SPIENSLV_DETSPIEN3 (0x0003u)

#define CSL_MCSPI_CH2CONFU_FORCE_MASK    (0x0010u)
#define CSL_MCSPI_CH2CONFU_FORCE_SHIFT   (0x0004u)
#define CSL_MCSPI_CH2CONFU_FORCE_RESETVAL (0x0000u)
/*----FORCE Tokens----*/
#define CSL_MCSPI_CH2CONFU_FORCE_SPIENLOW (0x0000u)
#define CSL_MCSPI_CH2CONFU_FORCE_SPIENHIGH (0x0001u)

#define CSL_MCSPI_CH2CONFU_TURBO_MASK    (0x0008u)
#define CSL_MCSPI_CH2CONFU_TURBO_SHIFT   (0x0003u)
#define CSL_MCSPI_CH2CONFU_TURBO_RESETVAL (0x0000u)
/*----TURBO Tokens----*/
#define CSL_MCSPI_CH2CONFU_TURBO_DEACTIVATE (0x0000u)
#define CSL_MCSPI_CH2CONFU_TURBO_ACTIVATE (0x0001u)

#define CSL_MCSPI_CH2CONFU_IS_MASK       (0x0004u)
#define CSL_MCSPI_CH2CONFU_IS_SHIFT      (0x0002u)
#define CSL_MCSPI_CH2CONFU_IS_RESETVAL   (0x0001u)
/*----IS Tokens----*/
#define CSL_MCSPI_CH2CONFU_IS_LINE0      (0x0000u)
#define CSL_MCSPI_CH2CONFU_IS_LINE1      (0x0001u)

#define CSL_MCSPI_CH2CONFU_DPE1_MASK     (0x0002u)
#define CSL_MCSPI_CH2CONFU_DPE1_SHIFT    (0x0001u)
#define CSL_MCSPI_CH2CONFU_DPE1_RESETVAL (0x0001u)
/*----DPE1 Tokens----*/
#define CSL_MCSPI_CH2CONFU_DPE1_DATLINE1 (0x0000u)
#define CSL_MCSPI_CH2CONFU_DPE1_NOTRANSMISSON (0x0001u)

#define CSL_MCSPI_CH2CONFU_DPE0_MASK     (0x0001u)
#define CSL_MCSPI_CH2CONFU_DPE0_SHIFT    (0x0000u)
#define CSL_MCSPI_CH2CONFU_DPE0_RESETVAL (0x0000u)
/*----DPE0 Tokens----*/
#define CSL_MCSPI_CH2CONFU_DPE0_DATLINE0 (0x0000u)
#define CSL_MCSPI_CH2CONFU_DPE0_NOTRANSMISSON (0x0001u)

#define CSL_MCSPI_CH2CONFU_RESETVAL      (0x0006u)

/* CH2STATL */


#define CSL_MCSPI_CH2STATL_RXFFF_MASK    (0x0040u)
#define CSL_MCSPI_CH2STATL_RXFFF_SHIFT   (0x0006u)
#define CSL_MCSPI_CH2STATL_RXFFF_RESETVAL (0x0000u)
/*----RXFFF Tokens----*/
#define CSL_MCSPI_CH2STATL_RXFFF_NOTFULL (0x0000u)
#define CSL_MCSPI_CH2STATL_RXFFF_FULL    (0x0001u)

#define CSL_MCSPI_CH2STATL_RXFFE_MASK    (0x0020u)
#define CSL_MCSPI_CH2STATL_RXFFE_SHIFT   (0x0005u)
#define CSL_MCSPI_CH2STATL_RXFFE_RESETVAL (0x0000u)
/*----RXFFE Tokens----*/
#define CSL_MCSPI_CH2STATL_RXFFE_NOTEMPTY (0x0000u)
#define CSL_MCSPI_CH2STATL_RXFFE_EMPTY   (0x0001u)

#define CSL_MCSPI_CH2STATL_TXFFF_MASK    (0x0010u)
#define CSL_MCSPI_CH2STATL_TXFFF_SHIFT   (0x0004u)
#define CSL_MCSPI_CH2STATL_TXFFF_RESETVAL (0x0000u)
/*----TXFFF Tokens----*/
#define CSL_MCSPI_CH2STATL_TXFFF_NOTFULL (0x0000u)
#define CSL_MCSPI_CH2STATL_TXFFF_FULL    (0x0001u)

#define CSL_MCSPI_CH2STATL_TXFFE_MASK    (0x0008u)
#define CSL_MCSPI_CH2STATL_TXFFE_SHIFT   (0x0003u)
#define CSL_MCSPI_CH2STATL_TXFFE_RESETVAL (0x0000u)
/*----TXFFE Tokens----*/
#define CSL_MCSPI_CH2STATL_TXFFE_NOTEMPTY (0x0000u)
#define CSL_MCSPI_CH2STATL_TXFFE_EMPTY   (0x0001u)

#define CSL_MCSPI_CH2STATL_EOT_MASK      (0x0004u)
#define CSL_MCSPI_CH2STATL_EOT_SHIFT     (0x0002u)
#define CSL_MCSPI_CH2STATL_EOT_RESETVAL  (0x0000u)
/*----EOT Tokens----*/
#define CSL_MCSPI_CH2STATL_EOT_INPROGRESS (0x0000u)
#define CSL_MCSPI_CH2STATL_EOT_COMPLETED (0x0001u)

#define CSL_MCSPI_CH2STATL_TXS_MASK      (0x0002u)
#define CSL_MCSPI_CH2STATL_TXS_SHIFT     (0x0001u)
#define CSL_MCSPI_CH2STATL_TXS_RESETVAL  (0x0000u)
/*----TXS Tokens----*/
#define CSL_MCSPI_CH2STATL_TXS_FULL      (0x0000u)
#define CSL_MCSPI_CH2STATL_TXS_EMPTY     (0x0001u)

#define CSL_MCSPI_CH2STATL_RXS_MASK      (0x0001u)
#define CSL_MCSPI_CH2STATL_RXS_SHIFT     (0x0000u)
#define CSL_MCSPI_CH2STATL_RXS_RESETVAL  (0x0000u)
/*----RXS Tokens----*/
#define CSL_MCSPI_CH2STATL_RXS_EMPTY     (0x0000u)
#define CSL_MCSPI_CH2STATL_RXS_FULL      (0x0001u)

#define CSL_MCSPI_CH2STATL_RESETVAL      (0x0000u)

/* CH2CTRLL */

#define CSL_MCSPI_CH2CTRLL_EXTCLK_MASK   (0xFF00u)
#define CSL_MCSPI_CH2CTRLL_EXTCLK_SHIFT  (0x0008u)
#define CSL_MCSPI_CH2CTRLL_EXTCLK_RESETVAL (0x0000u)
/*----EXTCLK Tokens----*/
#define CSL_MCSPI_CH2CTRLL_EXTCLK_CLKRATIO1 (0x0000u)
#define CSL_MCSPI_CH2CTRLL_EXTCLK_CLKRATIO2 (0x0001u)
#define CSL_MCSPI_CH2CTRLL_EXTCLK_CLKRATIO3 (0x0002u)


#define CSL_MCSPI_CH2CTRLL_EN_MASK       (0x0001u)
#define CSL_MCSPI_CH2CTRLL_EN_SHIFT      (0x0000u)
#define CSL_MCSPI_CH2CTRLL_EN_RESETVAL   (0x0000u)
/*----EN Tokens----*/
#define CSL_MCSPI_CH2CTRLL_EN_DISABLE    (0x0000u)
#define CSL_MCSPI_CH2CTRLL_EN_ENABLE     (0x0001u)

#define CSL_MCSPI_CH2CTRLL_RESETVAL      (0x0000u)

/* CH2TXL */

#define CSL_MCSPI_CH2TXL_TDATA_MASK        (0xFFFFu)
#define CSL_MCSPI_CH2TXL_TDATA_SHIFT       (0x0000u)
#define CSL_MCSPI_CH2TXL_TDATA_RESETVAL    (0x0000u)

#define CSL_MCSPI_CH2TXL_RESETVAL          (0x0000u)

/* CH2TXU */

#define CSL_MCSPI_CH2TXU_TDATA_MASK        (0xFFFFu)
#define CSL_MCSPI_CH2TXU_TDATA_SHIFT       (0x0000u)
#define CSL_MCSPI_CH2TXU_TDATA_RESETVAL    (0x0000u)

#define CSL_MCSPI_CH2TXU_RESETVAL          (0x0000u)

/* CH2RXL */

#define CSL_MCSPI_CH2RXL_RDATA_MASK        (0xFFFFu)
#define CSL_MCSPI_CH2RXL_RDATA_SHIFT       (0x0000u)
#define CSL_MCSPI_CH2RXL_RDATA_RESETVAL    (0x0000u)

#define CSL_MCSPI_CH2RXL_RESETVAL          (0x0000u)

/* CH2RXU */

#define CSL_MCSPI_CH2RXU_RDATA_MASK        (0xFFFFu)
#define CSL_MCSPI_CH2RXU_RDATA_SHIFT       (0x0000u)
#define CSL_MCSPI_CH2RXU_RDATA_RESETVAL    (0x0000u)

#define CSL_MCSPI_CH2RXU_RESETVAL          (0x0000u)

/* XFERLEVELL */

#define CSL_MCSPI_XFERLEVELL_AFL_MASK    (0xFF00u)
#define CSL_MCSPI_XFERLEVELL_AFL_SHIFT   (0x0008u)
#define CSL_MCSPI_XFERLEVELL_AFL_RESETVAL (0x0000u)

#define CSL_MCSPI_XFERLEVELL_AEL_MASK    (0x00FFu)
#define CSL_MCSPI_XFERLEVELL_AEL_SHIFT   (0x0000u)
#define CSL_MCSPI_XFERLEVELL_AEL_RESETVAL (0x0000u)

#define CSL_MCSPI_XFERLEVELL_RESETVAL    (0x0000u)

/* XFERLEVELU */

#define CSL_MCSPI_XFERLEVELU_WCNT_MASK   (0xFFFFu)
#define CSL_MCSPI_XFERLEVELU_WCNT_SHIFT  (0x0000u)
#define CSL_MCSPI_XFERLEVELU_WCNT_RESETVAL (0x0000u)

#define CSL_MCSPI_XFERLEVELU_RESETVAL    (0x0000u)

/* DAFTXL */

#define CSL_MCSPI_DAFTXL_DAFTDATA_MASK   (0xFFFFu)
#define CSL_MCSPI_DAFTXL_DAFTDATA_SHIFT  (0x0000u)
#define CSL_MCSPI_DAFTXL_DAFTDATA_RESETVAL (0x0000u)

#define CSL_MCSPI_DAFTXL_RESETVAL        (0x0000u)

/* DAFTXU */

#define CSL_MCSPI_DAFTXU_DAFTDATA_MASK   (0xFFFFu)
#define CSL_MCSPI_DAFTXU_DAFTDATA_SHIFT  (0x0000u)
#define CSL_MCSPI_DAFTXU_DAFTDATA_RESETVAL (0x0000u)

#define CSL_MCSPI_DAFTXU_RESETVAL        (0x0000u)

/* DAFRXL */

#define CSL_MCSPI_DAFRXL_DAFRDATA_MASK   (0xFFFFu)
#define CSL_MCSPI_DAFRXL_DAFRDATA_SHIFT  (0x0000u)
#define CSL_MCSPI_DAFRXL_DAFRDATA_RESETVAL (0x0000u)

#define CSL_MCSPI_DAFRXL_RESETVAL        (0x0000u)

/* DAFRXU */

#define CSL_MCSPI_DAFRXU_DAFRDATA_MASK   (0xFFFFu)
#define CSL_MCSPI_DAFRXU_DAFRDATA_SHIFT  (0x0000u)
#define CSL_MCSPI_DAFRXU_DAFRDATA_RESETVAL (0x0000u)

#define CSL_MCSPI_DAFRXU_RESETVAL        (0x0000u)

#endif
