/* ============================================================================
 * Copyright (c) 2008-2012 Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/


/** @file csl_uhpi.h
 *
 *  @brief uhpi functional layer API header file
 *
 *  Path: \\(CSLPATH)\\inc
 *
 */
#ifndef _CSLR_UHPI_H_
#define _CSLR_UHPI_H_

#include <cslr.h>

#include <tistdtypes.h>


/* Minimum unit = 2 bytes */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint16 PIDL;
    volatile Uint16 PIDU;
    volatile Uint16 RSVD0[2];
    volatile Uint16 PWREMU_MGMT;
    volatile Uint16 RSVD1[3];
    volatile Uint16 GPINT_CTRLL;
    volatile Uint16 GPINT_CTRLU;
    volatile Uint16 RSVD2[2];
    volatile Uint16 GPIO_ENL;
    volatile Uint16 GPIO_ENU;
    volatile Uint16 RSVD3[2];
    volatile Uint16 GPIO_DIR1L;
    volatile Uint16 GPIO_DIR1U;
    volatile Uint16 RSVD4[2];
    volatile Uint16 GPIO_DAT1L;
    volatile Uint16 GPIO_DAT1U;
    volatile Uint16 RSVD5[2];
    volatile Uint16 GPIO_DIR2L;
    volatile Uint16 GPIO_DIR2U;
    volatile Uint16 RSVD6[2];
    volatile Uint16 GPIO_DAT2L;
    volatile Uint16 GPIO_DAT2U;
    volatile Uint16 RSVD7[2];
    volatile Uint16 GPIO_DIR3L;
    volatile Uint16 GPIO_DIR3U;
    volatile Uint16 RSVD8[2];
    volatile Uint16 GPIO_DAT3L;
    volatile Uint16 GPIO_DAT3U;
    volatile Uint16 RSVD9[10];
    volatile Uint16 UHPICL;
    volatile Uint16 RSVD10[3];
    volatile Uint16 UHPIAWL;
    volatile Uint16 UHPIAWU;
    volatile Uint16 RSVD11[2];
    volatile Uint16 UHPIARL;
    volatile Uint16 UHPIARU;
    volatile Uint16 RSVD12[8];
} CSL_UhpiRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* PIDL */

#define CSL_UHPI_PIDL_RTL_MASK           (0xF800u)
#define CSL_UHPI_PIDL_RTL_SHIFT          (0x000Bu)
#define CSL_UHPI_PIDL_RTL_RESETVAL       (0x0000u)

#define CSL_UHPI_PIDL_MAJOR_MASK         (0x0700u)
#define CSL_UHPI_PIDL_MAJOR_SHIFT        (0x0008u)
#define CSL_UHPI_PIDL_MAJOR_RESETVAL     (0x0001u)

#define CSL_UHPI_PIDL_CUSTOM_MASK        (0x00C0u)
#define CSL_UHPI_PIDL_CUSTOM_SHIFT       (0x0006u)
#define CSL_UHPI_PIDL_CUSTOM_RESETVAL    (0x0000u)

#define CSL_UHPI_PIDL_MINOR_MASK         (0x003Fu)
#define CSL_UHPI_PIDL_MINOR_SHIFT        (0x0000u)
#define CSL_UHPI_PIDL_MINOR_RESETVAL     (0x000Au)

#define CSL_UHPI_PIDL_RESETVAL           (0x010Au)

/* PIDU */

#define CSL_UHPI_PIDU_TYPE_MASK          (0xC000u)
#define CSL_UHPI_PIDU_TYPE_SHIFT         (0x000Eu)
#define CSL_UHPI_PIDU_TYPE_RESETVAL      (0x0001u)


#define CSL_UHPI_PIDU_FUNC_MASK          (0x0FFFu)
#define CSL_UHPI_PIDU_FUNC_SHIFT         (0x0000u)
#define CSL_UHPI_PIDU_FUNC_RESETVAL      (0x0421u)

#define CSL_UHPI_PIDU_RESETVAL           (0x4421u)

/* PWREMU_MGMT */


#define CSL_UHPI_PWREMU_MGMT_SOFT_MASK   (0x0002u)
#define CSL_UHPI_PWREMU_MGMT_SOFT_SHIFT  (0x0001u)
#define CSL_UHPI_PWREMU_MGMT_SOFT_RESETVAL (0x0000u)
/*----SOFT Tokens----*/
#define CSL_UHPI_PWREMU_MGMT_SOFT_DISABLE (0x0000u)
#define CSL_UHPI_PWREMU_MGMT_SOFT_ENABLE (0x0001u)

#define CSL_UHPI_PWREMU_MGMT_FREE_MASK   (0x0001u)
#define CSL_UHPI_PWREMU_MGMT_FREE_SHIFT  (0x0000u)
#define CSL_UHPI_PWREMU_MGMT_FREE_RESETVAL (0x0000u)
/*----FREE Tokens----*/
#define CSL_UHPI_PWREMU_MGMT_FREE_DISABLE (0x0000u)
#define CSL_UHPI_PWREMU_MGMT_FREE_ENABLE (0x0001u)

#define CSL_UHPI_PWREMU_MGMT_RESETVAL    (0x0000u)

/* GPINT_CTRLL */


#define CSL_UHPI_GPINT_CTRLL_GPINT_EN2_MASK (0x0004u)
#define CSL_UHPI_GPINT_CTRLL_GPINT_EN2_SHIFT (0x0002u)
#define CSL_UHPI_GPINT_CTRLL_GPINT_EN2_RESETVAL (0x0000u)
/*----GPINT_EN2 Tokens----*/
#define CSL_UHPI_GPINT_CTRLL_GPINT_EN2_DISABLE (0x0000u)
#define CSL_UHPI_GPINT_CTRLL_GPINT_EN2_ENABLE (0x0001u)

#define CSL_UHPI_GPINT_CTRLL_GPINT_EN1_MASK (0x0002u)
#define CSL_UHPI_GPINT_CTRLL_GPINT_EN1_SHIFT (0x0001u)
#define CSL_UHPI_GPINT_CTRLL_GPINT_EN1_RESETVAL (0x0000u)
/*----GPINT_EN1 Tokens----*/
#define CSL_UHPI_GPINT_CTRLL_GPINT_EN1_DISABLE (0x0000u)
#define CSL_UHPI_GPINT_CTRLL_GPINT_EN1_ENABLE (0x0001u)

#define CSL_UHPI_GPINT_CTRLL_GPINT_EN0_MASK (0x0001u)
#define CSL_UHPI_GPINT_CTRLL_GPINT_EN0_SHIFT (0x0000u)
#define CSL_UHPI_GPINT_CTRLL_GPINT_EN0_RESETVAL (0x0000u)
/*----GPINT_EN0 Tokens----*/
#define CSL_UHPI_GPINT_CTRLL_GPINT_EN0_DISABLE (0x0000u)
#define CSL_UHPI_GPINT_CTRLL_GPINT_EN0_ENABLE (0x0001u)

#define CSL_UHPI_GPINT_CTRLL_RESETVAL    (0x0000u)

/* GPINT_CTRLU */


#define CSL_UHPI_GPINT_CTRLU_GPINT_INV2_MASK (0x0004u)
#define CSL_UHPI_GPINT_CTRLU_GPINT_INV2_SHIFT (0x0002u)
#define CSL_UHPI_GPINT_CTRLU_GPINT_INV2_RESETVAL (0x0000u)
/*----GPINT_INV2 Tokens----*/
#define CSL_UHPI_GPINT_CTRLU_GPINT_INV2_DISABLE (0x0000u)
#define CSL_UHPI_GPINT_CTRLU_GPINT_INV2_ENABLE (0x0001u)

#define CSL_UHPI_GPINT_CTRLU_GPINT_INV1_MASK (0x0002u)
#define CSL_UHPI_GPINT_CTRLU_GPINT_INV1_SHIFT (0x0001u)
#define CSL_UHPI_GPINT_CTRLU_GPINT_INV1_RESETVAL (0x0000u)
/*----GPINT_INV1 Tokens----*/
#define CSL_UHPI_GPINT_CTRLU_GPINT_INV1_DISABLE (0x0000u)
#define CSL_UHPI_GPINT_CTRLU_GPINT_INV1_ENABLE (0x0001u)

#define CSL_UHPI_GPINT_CTRLU_GPINT_INV0_MASK (0x0001u)
#define CSL_UHPI_GPINT_CTRLU_GPINT_INV0_SHIFT (0x0000u)
#define CSL_UHPI_GPINT_CTRLU_GPINT_INV0_RESETVAL (0x0000u)
/*----GPINT_INV0 Tokens----*/
#define CSL_UHPI_GPINT_CTRLU_GPINT_INV0_DISABLE (0x0000u)
#define CSL_UHPI_GPINT_CTRLU_GPINT_INV0_ENABLE (0x0001u)

#define CSL_UHPI_GPINT_CTRLU_RESETVAL    (0x0000u)

/* GPIO_ENL */

#define CSL_UHPI_GPIO_ENL_GPIO_EN15_MASK (0x8000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN15_SHIFT (0x000Fu)
#define CSL_UHPI_GPIO_ENL_GPIO_EN15_RESETVAL (0x0000u)
/*----GPIO_EN15 Tokens----*/
#define CSL_UHPI_GPIO_ENL_GPIO_EN15_DISABLE (0x0000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN15_ENABLE (0x0001u)

#define CSL_UHPI_GPIO_ENL_GPIO_EN14_MASK (0x4000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN14_SHIFT (0x000Eu)
#define CSL_UHPI_GPIO_ENL_GPIO_EN14_RESETVAL (0x0000u)
/*----GPIO_EN14 Tokens----*/
#define CSL_UHPI_GPIO_ENL_GPIO_EN14_DISABLE (0x0000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN14_ENABLE (0x0001u)

#define CSL_UHPI_GPIO_ENL_GPIO_EN13_MASK (0x2000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN13_SHIFT (0x000Du)
#define CSL_UHPI_GPIO_ENL_GPIO_EN13_RESETVAL (0x0000u)
/*----GPIO_EN13 Tokens----*/
#define CSL_UHPI_GPIO_ENL_GPIO_EN13_DISABLE (0x0000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN13_ENABLE (0x0001u)

#define CSL_UHPI_GPIO_ENL_GPIO_EN12_MASK (0x1000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN12_SHIFT (0x000Cu)
#define CSL_UHPI_GPIO_ENL_GPIO_EN12_RESETVAL (0x0000u)
/*----GPIO_EN12 Tokens----*/
#define CSL_UHPI_GPIO_ENL_GPIO_EN12_DISABLE (0x0000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN12_ENABLE (0x0001u)

#define CSL_UHPI_GPIO_ENL_GPIO_EN11_MASK (0x0800u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN11_SHIFT (0x000Bu)
#define CSL_UHPI_GPIO_ENL_GPIO_EN11_RESETVAL (0x0000u)
/*----GPIO_EN11 Tokens----*/
#define CSL_UHPI_GPIO_ENL_GPIO_EN11_DISABLE (0x0000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN11_ENABLE (0x0001u)

#define CSL_UHPI_GPIO_ENL_GPIO_EN10_MASK (0x0400u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN10_SHIFT (0x000Au)
#define CSL_UHPI_GPIO_ENL_GPIO_EN10_RESETVAL (0x0000u)
/*----GPIO_EN10 Tokens----*/
#define CSL_UHPI_GPIO_ENL_GPIO_EN10_DISABLE (0x0000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN10_ENABLE (0x0001u)

#define CSL_UHPI_GPIO_ENL_GPIO_EN9_MASK  (0x0200u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN9_SHIFT (0x0009u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN9_RESETVAL (0x0000u)
/*----GPIO_EN9 Tokens----*/
#define CSL_UHPI_GPIO_ENL_GPIO_EN9_DISABLE (0x0000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN9_ENABLE (0x0001u)

#define CSL_UHPI_GPIO_ENL_GPIO_EN8_MASK  (0x0100u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN8_SHIFT (0x0008u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN8_RESETVAL (0x0000u)
/*----GPIO_EN8 Tokens----*/
#define CSL_UHPI_GPIO_ENL_GPIO_EN8_DISABLE (0x0000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN8_ENABLE (0x0001u)

#define CSL_UHPI_GPIO_ENL_GPIO_EN7_MASK  (0x0080u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN7_SHIFT (0x0007u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN7_RESETVAL (0x0000u)
/*----GPIO_EN7 Tokens----*/
#define CSL_UHPI_GPIO_ENL_GPIO_EN7_DISABLE (0x0000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN7_ENABLE (0x0001u)

#define CSL_UHPI_GPIO_ENL_GPIO_EN6_MASK  (0x0040u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN6_SHIFT (0x0006u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN6_RESETVAL (0x0000u)
/*----GPIO_EN6 Tokens----*/
#define CSL_UHPI_GPIO_ENL_GPIO_EN6_DISABLE (0x0000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN6_ENABLE (0x0001u)

#define CSL_UHPI_GPIO_ENL_GPIO_EN5_MASK  (0x0020u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN5_SHIFT (0x0005u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN5_RESETVAL (0x0000u)
/*----GPIO_EN5 Tokens----*/
#define CSL_UHPI_GPIO_ENL_GPIO_EN5_DISABLE (0x0000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN5_ENABLE (0x0001u)

#define CSL_UHPI_GPIO_ENL_GPIO_EN4_MASK  (0x0010u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN4_SHIFT (0x0004u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN4_RESETVAL (0x0000u)
/*----GPIO_EN4 Tokens----*/
#define CSL_UHPI_GPIO_ENL_GPIO_EN4_DISABLE (0x0000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN4_ENABLE (0x0001u)

#define CSL_UHPI_GPIO_ENL_GPIO_EN3_MASK  (0x0008u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN3_SHIFT (0x0003u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN3_RESETVAL (0x0000u)
/*----GPIO_EN3 Tokens----*/
#define CSL_UHPI_GPIO_ENL_GPIO_EN3_DISABLE (0x0000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN3_ENABLE (0x0001u)

#define CSL_UHPI_GPIO_ENL_GPIO_EN2_MASK  (0x0004u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN2_SHIFT (0x0002u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN2_RESETVAL (0x0000u)
/*----GPIO_EN2 Tokens----*/
#define CSL_UHPI_GPIO_ENL_GPIO_EN2_DISABLE (0x0000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN2_ENABLE (0x0001u)

#define CSL_UHPI_GPIO_ENL_GPIO_EN1_MASK  (0x0002u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN1_SHIFT (0x0001u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN1_RESETVAL (0x0000u)
/*----GPIO_EN1 Tokens----*/
#define CSL_UHPI_GPIO_ENL_GPIO_EN1_DISABLE (0x0000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN1_ENABLE (0x0001u)

#define CSL_UHPI_GPIO_ENL_GPIO_EN0_MASK  (0x0001u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN0_SHIFT (0x0000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN0_RESETVAL (0x0000u)
/*----GPIO_EN0 Tokens----*/
#define CSL_UHPI_GPIO_ENL_GPIO_EN0_DISABLE (0x0000u)
#define CSL_UHPI_GPIO_ENL_GPIO_EN0_ENABLE (0x0001u)

#define CSL_UHPI_GPIO_ENL_RESETVAL       (0x0000u)

/* GPIO_ENU */


#define CSL_UHPI_GPIO_ENU_GPIO_EN16_MASK (0x0001u)
#define CSL_UHPI_GPIO_ENU_GPIO_EN16_SHIFT (0x0000u)
#define CSL_UHPI_GPIO_ENU_GPIO_EN16_RESETVAL (0x0000u)
/*----GPIO_EN16 Tokens----*/
#define CSL_UHPI_GPIO_ENU_GPIO_EN16_DISABLE (0x0000u)
#define CSL_UHPI_GPIO_ENU_GPIO_EN16_ENABLE (0x0001u)

#define CSL_UHPI_GPIO_ENU_RESETVAL       (0x0000u)

/* GPIO_DIR1L */

#define CSL_UHPI_GPIO_DIR1L_DIR_MASK     (0xFFFFu)
#define CSL_UHPI_GPIO_DIR1L_DIR_SHIFT    (0x0000u)
#define CSL_UHPI_GPIO_DIR1L_DIR_RESETVAL (0x0000u)

#define CSL_UHPI_GPIO_DIR1L_RESETVAL     (0x0000u)

/* GPIO_DIR1U */

#define CSL_UHPI_GPIO_DIR1U_DIR_MASK     (0xFFFFu)
#define CSL_UHPI_GPIO_DIR1U_DIR_SHIFT    (0x0000u)
#define CSL_UHPI_GPIO_DIR1U_DIR_RESETVAL (0x0000u)

#define CSL_UHPI_GPIO_DIR1U_RESETVAL     (0x0000u)

/* GPIO_DAT1L */

#define CSL_UHPI_GPIO_DAT1L_DAT_MASK     (0xFFFFu)
#define CSL_UHPI_GPIO_DAT1L_DAT_SHIFT    (0x0000u)
#define CSL_UHPI_GPIO_DAT1L_DAT_RESETVAL (0x0000u)

#define CSL_UHPI_GPIO_DAT1L_RESETVAL     (0x0000u)

/* GPIO_DAT1U */

#define CSL_UHPI_GPIO_DAT1U_DAT_MASK     (0xFFFFu)
#define CSL_UHPI_GPIO_DAT1U_DAT_SHIFT    (0x0000u)
#define CSL_UHPI_GPIO_DAT1U_DAT_RESETVAL (0x0000u)

#define CSL_UHPI_GPIO_DAT1U_RESETVAL     (0x0000u)

/* GPIO_DIR2L */


#define CSL_UHPI_GPIO_DIR2L_DIR14_MASK   (0x4000u)
#define CSL_UHPI_GPIO_DIR2L_DIR14_SHIFT  (0x000Eu)
#define CSL_UHPI_GPIO_DIR2L_DIR14_RESETVAL (0x0000u)
/*----DIR14 Tokens----*/
#define CSL_UHPI_GPIO_DIR2L_DIR14_INPUT  (0x0000u)
#define CSL_UHPI_GPIO_DIR2L_DIR14_OUTPUT (0x0001u)

#define CSL_UHPI_GPIO_DIR2L_DIR13_MASK   (0x2000u)
#define CSL_UHPI_GPIO_DIR2L_DIR13_SHIFT  (0x000Du)
#define CSL_UHPI_GPIO_DIR2L_DIR13_RESETVAL (0x0000u)
/*----DIR13 Tokens----*/
#define CSL_UHPI_GPIO_DIR2L_DIR13_INPUT  (0x0000u)
#define CSL_UHPI_GPIO_DIR2L_DIR13_OUTPUT (0x0001u)

#define CSL_UHPI_GPIO_DIR2L_DIR12_MASK   (0x1000u)
#define CSL_UHPI_GPIO_DIR2L_DIR12_SHIFT  (0x000Cu)
#define CSL_UHPI_GPIO_DIR2L_DIR12_RESETVAL (0x0000u)
/*----DIR12 Tokens----*/
#define CSL_UHPI_GPIO_DIR2L_DIR12_INPUT  (0x0000u)
#define CSL_UHPI_GPIO_DIR2L_DIR12_OUTPUT (0x0001u)

#define CSL_UHPI_GPIO_DIR2L_DIR11_MASK   (0x0800u)
#define CSL_UHPI_GPIO_DIR2L_DIR11_SHIFT  (0x000Bu)
#define CSL_UHPI_GPIO_DIR2L_DIR11_RESETVAL (0x0000u)
/*----DIR11 Tokens----*/
#define CSL_UHPI_GPIO_DIR2L_DIR11_INPUT  (0x0000u)
#define CSL_UHPI_GPIO_DIR2L_DIR11_OUTPUT (0x0001u)

#define CSL_UHPI_GPIO_DIR2L_DIR10_MASK   (0x0400u)
#define CSL_UHPI_GPIO_DIR2L_DIR10_SHIFT  (0x000Au)
#define CSL_UHPI_GPIO_DIR2L_DIR10_RESETVAL (0x0000u)
/*----DIR10 Tokens----*/
#define CSL_UHPI_GPIO_DIR2L_DIR10_INPUT  (0x0000u)
#define CSL_UHPI_GPIO_DIR2L_DIR10_OUTPUT (0x0001u)

#define CSL_UHPI_GPIO_DIR2L_DIR9_MASK    (0x0200u)
#define CSL_UHPI_GPIO_DIR2L_DIR9_SHIFT   (0x0009u)
#define CSL_UHPI_GPIO_DIR2L_DIR9_RESETVAL (0x0000u)
/*----DIR9 Tokens----*/
#define CSL_UHPI_GPIO_DIR2L_DIR9_INPUT   (0x0000u)
#define CSL_UHPI_GPIO_DIR2L_DIR9_OUTPUT  (0x0001u)

#define CSL_UHPI_GPIO_DIR2L_DIR8_MASK    (0x0100u)
#define CSL_UHPI_GPIO_DIR2L_DIR8_SHIFT   (0x0008u)
#define CSL_UHPI_GPIO_DIR2L_DIR8_RESETVAL (0x0000u)
/*----DIR8 Tokens----*/
#define CSL_UHPI_GPIO_DIR2L_DIR8_INPUT   (0x0000u)
#define CSL_UHPI_GPIO_DIR2L_DIR8_OUTPUT  (0x0001u)

#define CSL_UHPI_GPIO_DIR2L_DIR7_MASK    (0x0080u)
#define CSL_UHPI_GPIO_DIR2L_DIR7_SHIFT   (0x0007u)
#define CSL_UHPI_GPIO_DIR2L_DIR7_RESETVAL (0x0000u)
/*----DIR7 Tokens----*/
#define CSL_UHPI_GPIO_DIR2L_DIR7_INPUT   (0x0000u)
#define CSL_UHPI_GPIO_DIR2L_DIR7_OUTPUT  (0x0001u)

#define CSL_UHPI_GPIO_DIR2L_DIR6_MASK    (0x0040u)
#define CSL_UHPI_GPIO_DIR2L_DIR6_SHIFT   (0x0006u)
#define CSL_UHPI_GPIO_DIR2L_DIR6_RESETVAL (0x0000u)
/*----DIR6 Tokens----*/
#define CSL_UHPI_GPIO_DIR2L_DIR6_INPUT   (0x0000u)
#define CSL_UHPI_GPIO_DIR2L_DIR6_OUTPUT  (0x0001u)

#define CSL_UHPI_GPIO_DIR2L_DIR5_MASK    (0x0020u)
#define CSL_UHPI_GPIO_DIR2L_DIR5_SHIFT   (0x0005u)
#define CSL_UHPI_GPIO_DIR2L_DIR5_RESETVAL (0x0000u)
/*----DIR5 Tokens----*/
#define CSL_UHPI_GPIO_DIR2L_DIR5_INPUT   (0x0000u)
#define CSL_UHPI_GPIO_DIR2L_DIR5_OUTPUT  (0x0001u)

#define CSL_UHPI_GPIO_DIR2L_DIR4_MASK    (0x0010u)
#define CSL_UHPI_GPIO_DIR2L_DIR4_SHIFT   (0x0004u)
#define CSL_UHPI_GPIO_DIR2L_DIR4_RESETVAL (0x0000u)
/*----DIR4 Tokens----*/
#define CSL_UHPI_GPIO_DIR2L_DIR4_INPUT   (0x0000u)
#define CSL_UHPI_GPIO_DIR2L_DIR4_OUTPUT  (0x0001u)

#define CSL_UHPI_GPIO_DIR2L_DIR3_MASK    (0x0008u)
#define CSL_UHPI_GPIO_DIR2L_DIR3_SHIFT   (0x0003u)
#define CSL_UHPI_GPIO_DIR2L_DIR3_RESETVAL (0x0000u)
/*----DIR3 Tokens----*/
#define CSL_UHPI_GPIO_DIR2L_DIR3_INPUT   (0x0000u)
#define CSL_UHPI_GPIO_DIR2L_DIR3_OUTPUT  (0x0001u)

#define CSL_UHPI_GPIO_DIR2L_DIR2_MASK    (0x0004u)
#define CSL_UHPI_GPIO_DIR2L_DIR2_SHIFT   (0x0002u)
#define CSL_UHPI_GPIO_DIR2L_DIR2_RESETVAL (0x0000u)
/*----DIR2 Tokens----*/
#define CSL_UHPI_GPIO_DIR2L_DIR2_INPUT   (0x0000u)
#define CSL_UHPI_GPIO_DIR2L_DIR2_OUTPUT  (0x0001u)

#define CSL_UHPI_GPIO_DIR2L_DIR1_MASK    (0x0002u)
#define CSL_UHPI_GPIO_DIR2L_DIR1_SHIFT   (0x0001u)
#define CSL_UHPI_GPIO_DIR2L_DIR1_RESETVAL (0x0000u)
/*----DIR1 Tokens----*/
#define CSL_UHPI_GPIO_DIR2L_DIR1_INPUT   (0x0000u)
#define CSL_UHPI_GPIO_DIR2L_DIR1_OUTPUT  (0x0001u)

#define CSL_UHPI_GPIO_DIR2L_DIR0_MASK    (0x0001u)
#define CSL_UHPI_GPIO_DIR2L_DIR0_SHIFT   (0x0000u)
#define CSL_UHPI_GPIO_DIR2L_DIR0_RESETVAL (0x0000u)
/*----DIR0 Tokens----*/
#define CSL_UHPI_GPIO_DIR2L_DIR0_INPUT   (0x0000u)
#define CSL_UHPI_GPIO_DIR2L_DIR0_OUTPUT  (0x0001u)

#define CSL_UHPI_GPIO_DIR2L_RESETVAL     (0x0000u)

/* GPIO_DIR2U */


#define CSL_UHPI_GPIO_DIR2U_RESETVAL     (0x0000u)

/* GPIO_DAT2L */


#define CSL_UHPI_GPIO_DAT2L_DAT14_MASK   (0x4000u)
#define CSL_UHPI_GPIO_DAT2L_DAT14_SHIFT  (0x000Eu)
#define CSL_UHPI_GPIO_DAT2L_DAT14_RESETVAL (0x0000u)
/*----DAT14 Tokens----*/
#define CSL_UHPI_GPIO_DAT2L_DAT14_LOW    (0x0000u)
#define CSL_UHPI_GPIO_DAT2L_DAT14_HIGH   (0x0001u)

#define CSL_UHPI_GPIO_DAT2L_DAT13_MASK   (0x2000u)
#define CSL_UHPI_GPIO_DAT2L_DAT13_SHIFT  (0x000Du)
#define CSL_UHPI_GPIO_DAT2L_DAT13_RESETVAL (0x0000u)
/*----DAT13 Tokens----*/
#define CSL_UHPI_GPIO_DAT2L_DAT13_LOW    (0x0000u)
#define CSL_UHPI_GPIO_DAT2L_DAT13_HIGH   (0x0001u)

#define CSL_UHPI_GPIO_DAT2L_DAT12_MASK   (0x1000u)
#define CSL_UHPI_GPIO_DAT2L_DAT12_SHIFT  (0x000Cu)
#define CSL_UHPI_GPIO_DAT2L_DAT12_RESETVAL (0x0000u)
/*----DAT12 Tokens----*/
#define CSL_UHPI_GPIO_DAT2L_DAT12_LOW    (0x0000u)
#define CSL_UHPI_GPIO_DAT2L_DAT12_HIGH   (0x0001u)

#define CSL_UHPI_GPIO_DAT2L_DAT11_MASK   (0x0800u)
#define CSL_UHPI_GPIO_DAT2L_DAT11_SHIFT  (0x000Bu)
#define CSL_UHPI_GPIO_DAT2L_DAT11_RESETVAL (0x0000u)
/*----DAT11 Tokens----*/
#define CSL_UHPI_GPIO_DAT2L_DAT11_LOW    (0x0000u)
#define CSL_UHPI_GPIO_DAT2L_DAT11_HIGH   (0x0001u)

#define CSL_UHPI_GPIO_DAT2L_DAT10_MASK   (0x0400u)
#define CSL_UHPI_GPIO_DAT2L_DAT10_SHIFT  (0x000Au)
#define CSL_UHPI_GPIO_DAT2L_DAT10_RESETVAL (0x0000u)
/*----DAT10 Tokens----*/
#define CSL_UHPI_GPIO_DAT2L_DAT10_LOW    (0x0000u)
#define CSL_UHPI_GPIO_DAT2L_DAT10_HIGH   (0x0001u)

#define CSL_UHPI_GPIO_DAT2L_DAT9_MASK    (0x0200u)
#define CSL_UHPI_GPIO_DAT2L_DAT9_SHIFT   (0x0009u)
#define CSL_UHPI_GPIO_DAT2L_DAT9_RESETVAL (0x0000u)
/*----DAT9 Tokens----*/
#define CSL_UHPI_GPIO_DAT2L_DAT9_LOW     (0x0000u)
#define CSL_UHPI_GPIO_DAT2L_DAT9_HIGH    (0x0001u)

#define CSL_UHPI_GPIO_DAT2L_DAT8_MASK    (0x0100u)
#define CSL_UHPI_GPIO_DAT2L_DAT8_SHIFT   (0x0008u)
#define CSL_UHPI_GPIO_DAT2L_DAT8_RESETVAL (0x0000u)
/*----DAT8 Tokens----*/
#define CSL_UHPI_GPIO_DAT2L_DAT8_LOW     (0x0000u)
#define CSL_UHPI_GPIO_DAT2L_DAT8_HIGH    (0x0001u)

#define CSL_UHPI_GPIO_DAT2L_DAT7_MASK    (0x0080u)
#define CSL_UHPI_GPIO_DAT2L_DAT7_SHIFT   (0x0007u)
#define CSL_UHPI_GPIO_DAT2L_DAT7_RESETVAL (0x0000u)
/*----DAT7 Tokens----*/
#define CSL_UHPI_GPIO_DAT2L_DAT7_LOW     (0x0000u)
#define CSL_UHPI_GPIO_DAT2L_DAT7_HIGH    (0x0001u)

#define CSL_UHPI_GPIO_DAT2L_DAT6_MASK    (0x0040u)
#define CSL_UHPI_GPIO_DAT2L_DAT6_SHIFT   (0x0006u)
#define CSL_UHPI_GPIO_DAT2L_DAT6_RESETVAL (0x0000u)
/*----DAT6 Tokens----*/
#define CSL_UHPI_GPIO_DAT2L_DAT6_LOW     (0x0000u)
#define CSL_UHPI_GPIO_DAT2L_DAT6_HIGH    (0x0001u)

#define CSL_UHPI_GPIO_DAT2L_DAT5_MASK    (0x0020u)
#define CSL_UHPI_GPIO_DAT2L_DAT5_SHIFT   (0x0005u)
#define CSL_UHPI_GPIO_DAT2L_DAT5_RESETVAL (0x0000u)
/*----DAT5 Tokens----*/
#define CSL_UHPI_GPIO_DAT2L_DAT5_LOW     (0x0000u)
#define CSL_UHPI_GPIO_DAT2L_DAT5_HIGH    (0x0001u)

#define CSL_UHPI_GPIO_DAT2L_DAT4_MASK    (0x0010u)
#define CSL_UHPI_GPIO_DAT2L_DAT4_SHIFT   (0x0004u)
#define CSL_UHPI_GPIO_DAT2L_DAT4_RESETVAL (0x0000u)
/*----DAT4 Tokens----*/
#define CSL_UHPI_GPIO_DAT2L_DAT4_LOW     (0x0000u)
#define CSL_UHPI_GPIO_DAT2L_DAT4_HIGH    (0x0001u)

#define CSL_UHPI_GPIO_DAT2L_DAT3_MASK    (0x0008u)
#define CSL_UHPI_GPIO_DAT2L_DAT3_SHIFT   (0x0003u)
#define CSL_UHPI_GPIO_DAT2L_DAT3_RESETVAL (0x0000u)
/*----DAT3 Tokens----*/
#define CSL_UHPI_GPIO_DAT2L_DAT3_LOW     (0x0000u)
#define CSL_UHPI_GPIO_DAT2L_DAT3_HIGH    (0x0001u)

#define CSL_UHPI_GPIO_DAT2L_DAT2_MASK    (0x0004u)
#define CSL_UHPI_GPIO_DAT2L_DAT2_SHIFT   (0x0002u)
#define CSL_UHPI_GPIO_DAT2L_DAT2_RESETVAL (0x0000u)
/*----DAT2 Tokens----*/
#define CSL_UHPI_GPIO_DAT2L_DAT2_LOW     (0x0000u)
#define CSL_UHPI_GPIO_DAT2L_DAT2_HIGH    (0x0001u)

#define CSL_UHPI_GPIO_DAT2L_DAT1_MASK    (0x0002u)
#define CSL_UHPI_GPIO_DAT2L_DAT1_SHIFT   (0x0001u)
#define CSL_UHPI_GPIO_DAT2L_DAT1_RESETVAL (0x0000u)
/*----DAT1 Tokens----*/
#define CSL_UHPI_GPIO_DAT2L_DAT1_LOW     (0x0000u)
#define CSL_UHPI_GPIO_DAT2L_DAT1_HIGH    (0x0001u)

#define CSL_UHPI_GPIO_DAT2L_DAT0_MASK    (0x0001u)
#define CSL_UHPI_GPIO_DAT2L_DAT0_SHIFT   (0x0000u)
#define CSL_UHPI_GPIO_DAT2L_DAT0_RESETVAL (0x0000u)
/*----DAT0 Tokens----*/
#define CSL_UHPI_GPIO_DAT2L_DAT0_LOW     (0x0000u)
#define CSL_UHPI_GPIO_DAT2L_DAT0_HIGH    (0x0001u)

#define CSL_UHPI_GPIO_DAT2L_RESETVAL     (0x0000u)

/* GPIO_DAT2U */


#define CSL_UHPI_GPIO_DAT2U_RESETVAL     (0x0000u)

/* GPIO_DIR3L */

#define CSL_UHPI_GPIO_DIR3L_DIR_MASK     (0xFFFFu)
#define CSL_UHPI_GPIO_DIR3L_DIR_SHIFT    (0x0000u)
#define CSL_UHPI_GPIO_DIR3L_DIR_RESETVAL (0x0000u)

#define CSL_UHPI_GPIO_DIR3L_RESETVAL     (0x0000u)

/* GPIO_DIR3U */

#define CSL_UHPI_GPIO_DIR3U_DIR_MASK     (0xFFFFu)
#define CSL_UHPI_GPIO_DIR3U_DIR_SHIFT    (0x0000u)
#define CSL_UHPI_GPIO_DIR3U_DIR_RESETVAL (0x0000u)

#define CSL_UHPI_GPIO_DIR3U_RESETVAL     (0x0000u)

/* GPIO_DAT3L */

#define CSL_UHPI_GPIO_DAT3L_DAT_MASK     (0xFFFFu)
#define CSL_UHPI_GPIO_DAT3L_DAT_SHIFT    (0x0000u)
#define CSL_UHPI_GPIO_DAT3L_DAT_RESETVAL (0x0000u)

#define CSL_UHPI_GPIO_DAT3L_RESETVAL     (0x0000u)

/* GPIO_DAT3U */

#define CSL_UHPI_GPIO_DAT3U_DAT_MASK     (0xFFFFu)
#define CSL_UHPI_GPIO_DAT3U_DAT_SHIFT    (0x0000u)
#define CSL_UHPI_GPIO_DAT3U_DAT_RESETVAL (0x0000u)

#define CSL_UHPI_GPIO_DAT3U_RESETVAL     (0x0000u)

/* UHPICL */

#define CSL_UHPI_UHPICL_NRDY_HPID_WR_MASK (0x8000u)
#define CSL_UHPI_UHPICL_NRDY_HPID_WR_SHIFT (0x000Fu)
#define CSL_UHPI_UHPICL_NRDY_HPID_WR_RESETVAL (0x0000u)
/*----NRDY_HPID_WR Tokens----*/
#define CSL_UHPI_UHPICL_NRDY_HPID_WR_READY (0x0000u)
#define CSL_UHPI_UHPICL_NRDY_HPID_WR_NRDY (0x0001u)

#define CSL_UHPI_UHPICL_NRDY_HPIDP_WR_MASK (0x4000u)
#define CSL_UHPI_UHPICL_NRDY_HPIDP_WR_SHIFT (0x000Eu)
#define CSL_UHPI_UHPICL_NRDY_HPIDP_WR_RESETVAL (0x0000u)
/*----NRDY_HPIDP_WR Tokens----*/
#define CSL_UHPI_UHPICL_NRDY_HPIDP_WR_READY (0x0000u)
#define CSL_UHPI_UHPICL_NRDY_HPIDP_WR_NRDY (0x0001u)

#define CSL_UHPI_UHPICL_NRDY_HPID_RD_MASK (0x2000u)
#define CSL_UHPI_UHPICL_NRDY_HPID_RD_SHIFT (0x000Du)
#define CSL_UHPI_UHPICL_NRDY_HPID_RD_RESETVAL (0x0000u)
/*----NRDY_HPID_RD Tokens----*/
#define CSL_UHPI_UHPICL_NRDY_HPID_RD_READY (0x0000u)
#define CSL_UHPI_UHPICL_NRDY_HPID_RD_NRDY (0x0001u)

#define CSL_UHPI_UHPICL_NRDY_HPIA_WR_MASK (0x1000u)
#define CSL_UHPI_UHPICL_NRDY_HPIA_WR_SHIFT (0x000Cu)
#define CSL_UHPI_UHPICL_NRDY_HPIA_WR_RESETVAL (0x0000u)
/*----NRDY_HPIA_WR Tokens----*/
#define CSL_UHPI_UHPICL_NRDY_HPIA_WR_READY (0x0000u)
#define CSL_UHPI_UHPICL_NRDY_HPIA_WR_NRDY (0x0001u)

#define CSL_UHPI_UHPICL_HPIA_RW_SEL_MASK  (0x0800u)
#define CSL_UHPI_UHPICL_HPIA_RW_SEL_SHIFT (0x000Bu)
#define CSL_UHPI_UHPICL_HPIA_RW_SEL_RESETVAL (0x0000u)
/*----HPIA_RW_SEL Tokens----*/
#define CSL_UHPI_UHPICL_HPIA_RW_SEL_WRITE (0x0000u)
#define CSL_UHPI_UHPICL_HPIA_RW_SEL_READ  (0x0001u)

#define CSL_UHPI_UHPICL_LB_MODE_MASK      (0x0400u)
#define CSL_UHPI_UHPICL_LB_MODE_SHIFT     (0x000Au)
#define CSL_UHPI_UHPICL_LB_MODE_RESETVAL  (0x0000u)
/*----LB_MODE Tokens----*/
#define CSL_UHPI_UHPICL_LB_MODE_DISABLE   (0x0000u)
#define CSL_UHPI_UHPICL_LB_MODE_ENABLE    (0x0001u)

#define CSL_UHPI_UHPICL_DUAL_HPIA_MASK    (0x0200u)
#define CSL_UHPI_UHPICL_DUAL_HPIA_SHIFT   (0x0009u)
#define CSL_UHPI_UHPICL_DUAL_HPIA_RESETVAL (0x0000u)
/*----DUAL_HPIA Tokens----*/
#define CSL_UHPI_UHPICL_DUAL_HPIA_DISABLE (0x0000u)
#define CSL_UHPI_UHPICL_DUAL_HPIA_ENABLE  (0x0001u)

#define CSL_UHPI_UHPICL_HWOB_STAT_MASK    (0x0100u)
#define CSL_UHPI_UHPICL_HWOB_STAT_SHIFT   (0x0008u)
#define CSL_UHPI_UHPICL_HWOB_STAT_RESETVAL (0x0000u)
/*----HWOB_STAT Tokens----*/
#define CSL_UHPI_UHPICL_HWOB_STAT_ZERO    (0x0000u)
#define CSL_UHPI_UHPICL_HWOB_STAT_ONE     (0x0001u)

#define CSL_UHPI_UHPICL_HPI_RST_MASK      (0x0080u)
#define CSL_UHPI_UHPICL_HPI_RST_SHIFT     (0x0007u)
#define CSL_UHPI_UHPICL_HPI_RST_RESETVAL  (0x0001u)
/*----HPI_RST Tokens----*/
#define CSL_UHPI_UHPICL_HPI_RST_CLEAR     (0x0000u)
#define CSL_UHPI_UHPICL_HPI_RST_GENERATE  (0x0001u)

#define CSL_UHPI_UHPICL_RESET_MASK        (0x0040u)
#define CSL_UHPI_UHPICL_RESET_SHIFT       (0x0006u)
#define CSL_UHPI_UHPICL_RESET_RESETVAL    (0x0001u)
/*----RESET Tokens----*/
#define CSL_UHPI_UHPICL_RESET_DISABLE     (0x0000u)
#define CSL_UHPI_UHPICL_RESET_ENABLE      (0x0001u)

#define CSL_UHPI_UHPICL_XHPIA_MASK        (0x0020u)
#define CSL_UHPI_UHPICL_XHPIA_SHIFT       (0x0005u)
#define CSL_UHPI_UHPICL_XHPIA_RESETVAL    (0x0000u)
/*----XHPIA Tokens----*/
#define CSL_UHPI_UHPICL_XHPIA_DISABLE     (0x0000u)
#define CSL_UHPI_UHPICL_XHPIA_ENABLE      (0x0001u)

#define CSL_UHPI_UHPICL_FETCH_MASK        (0x0010u)
#define CSL_UHPI_UHPICL_FETCH_SHIFT       (0x0004u)
#define CSL_UHPI_UHPICL_FETCH_RESETVAL    (0x0000u)
/*----FETCH Tokens----*/
#define CSL_UHPI_UHPICL_FETCH_ZERO        (0x0000u)
#define CSL_UHPI_UHPICL_FETCH_ONE         (0x0001u)

#define CSL_UHPI_UHPICL_HRDY_MASK         (0x0008u)
#define CSL_UHPI_UHPICL_HRDY_SHIFT        (0x0003u)
#define CSL_UHPI_UHPICL_HRDY_RESETVAL     (0x0000u)
/*----HRDY Tokens----*/
#define CSL_UHPI_UHPICL_HRDY_BUSY         (0x0000u)
#define CSL_UHPI_UHPICL_HRDY_READY        (0x0001u)

#define CSL_UHPI_UHPICL_HINT_MASK         (0x0004u)
#define CSL_UHPI_UHPICL_HINT_SHIFT        (0x0002u)
#define CSL_UHPI_UHPICL_HINT_RESETVAL     (0x0000u)
/*----HINT Tokens----*/
#define CSL_UHPI_UHPICL_HINT_CLEAR        (0x0000u)
#define CSL_UHPI_UHPICL_HINT_GENERATE     (0x0001u)

#define CSL_UHPI_UHPICL_DSP_INT_MASK      (0x0002u)
#define CSL_UHPI_UHPICL_DSP_INT_SHIFT     (0x0001u)
#define CSL_UHPI_UHPICL_DSP_INT_RESETVAL  (0x0000u)
/*----DSP_INT Tokens----*/
#define CSL_UHPI_UHPICL_DSP_INT_CLEAR     (0x0000u)
#define CSL_UHPI_UHPICL_DSP_INT_GENERATE  (0x0001u)

#define CSL_UHPI_UHPICL_HWOB_MASK         (0x0001u)
#define CSL_UHPI_UHPICL_HWOB_SHIFT        (0x0000u)
#define CSL_UHPI_UHPICL_HWOB_RESETVAL     (0x0000u)
/*----HWOB Tokens----*/
#define CSL_UHPI_UHPICL_HWOB_MSB          (0x0000u)
#define CSL_UHPI_UHPICL_HWOB_LSB          (0x0001u)

#define CSL_UHPI_HPICL_RESETVAL          (0x00C0u)

/* UHPIAWL */

#define CSL_UHPI_UHPIAWL_HPIAW_MASK       (0xFFFFu)
#define CSL_UHPI_UHPIAWL_HPIAW_SHIFT      (0x0000u)
#define CSL_UHPI_UHPIAWL_HPIAW_RESETVAL   (0x0000u)

#define CSL_UHPI_UHPIAWL_RESETVAL         (0x0000u)

/* UHPIAWU */

#define CSL_UHPI_UHPIAWU_HPIAW_MASK       (0xFFFFu)
#define CSL_UHPI_UHPIAWU_HPIAW_SHIFT      (0x0000u)
#define CSL_UHPI_UHPIAWU_HPIAW_RESETVAL   (0x0000u)

#define CSL_UHPI_UHPIAWU_RESETVAL         (0x0000u)

/* UHPIARL */

#define CSL_UHPI_UHPIARL_HPIAR_MASK       (0xFFFFu)
#define CSL_UHPI_UHPIARL_HPIAR_SHIFT      (0x0000u)
#define CSL_UHPI_UHPIARL_HPIAR_RESETVAL   (0x0000u)

#define CSL_UHPI_UHPIARL_RESETVAL         (0x0000u)

/* UHPIARU */

#define CSL_UHPI_UHPIARU_HPIAR_MASK       (0xFFFFu)
#define CSL_UHPI_UHPIARU_HPIAR_SHIFT      (0x0000u)
#define CSL_UHPI_UHPIARU_HPIAR_RESETVAL   (0x0000u)

#define CSL_UHPI_UHPIARU_RESETVAL         (0x0000u)

#endif
