/****************************************************************************/
/*                                                                          */
/*              EDMA3 һά                                          */
/*                                                                          */
/*              20140724                                              */
/*                                                                          */
/****************************************************************************/
#include "hw_types.h"
#include "hw_psc_C6748.h"
#include "soc_C6748.h"
#include "edma.h"
#include "psc.h"
#include "uartStdio.h"

#include <ti/sysbios/hal/Hwi.h>
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/family/c64p/Cache.h>
/****************************************************************************/
/*                                                                          */
/*              DSPFPGAͨŲ(EMIF DMA)                                 */
/*                                                                          */
/*              20141014                                              */
/*                                                                          */
/****************************************************************************/
#include <c6x.h>
#include <stdio.h>

//#include "hw_types.h"				// 
#include "hw_syscfg0_C6748.h"	    // ϵͳģĴ
//#include "soc_C6748.h"			    // DSP C6748 Ĵ
//#include "psc.h"			        // Դ˯߿ƺ꼰豸㺯
#include "gpio.h"					// ͨں꼰豸㺯
#include "rtc.h"					// ʵʱʱӺ꼰豸㺯
#include "interrupt.h"             // DSP C6748 жӦóӿںϵͳ¼Ŷ
#include "EMIFAPinmuxSetup.h"
#include "emifa.h"
//#include "edma.h"

#include "uartStdio.h"             // ڱ׼ն˺

/****************************************************************************/
/*                                                                          */
/*              궨                                                      */
/*                                                                          */
/****************************************************************************/
//  ACOUNT
//#define MAX_ACOUNT        (10u)

//  BCOUNT
//#define MAX_BCOUNT        (10u)

//  CCOUNT
//#define MAX_CCOUNT        (1u)

//#define MAX_BUFFER_SIZE   (MAX_ACOUNT * MAX_BCOUNT * MAX_CCOUNT)
/****************************************************************************/
/*                                                                          */
/*              궨                                                      */
/*                                                                          */
/****************************************************************************/
#define CHTYPE_DMA
#define EMIF_BUFFER_LENGTH 32767

/* MAX ACOUNT */
#define MAX_ACOUNT        (EMIF_BUFFER_LENGTH*2)

/* MAX BCOUNT */
#define MAX_BCOUNT        (1u)

/* MAX CCOUNT */
#define MAX_CCOUNT        (1u)

/****************************************************************************/
/*                                                                          */
/*              ȫֱ                                                    */
/*                                                                          */
/****************************************************************************/
volatile int irqRaised;

// 
//unsigned int chType     = EDMA3_CHANNEL_TYPE_DMA;
//unsigned int chNum      = 0;
//unsigned int tccNum     = 0;
//unsigned int edmaTC     = 0;
//unsigned int syncType   = EDMA3_SYNC_A;
//unsigned int trigMode   = EDMA3_TRIG_MODE_MANUAL;
//unsigned int evtQ       = 0; // ʹõ¼

//volatile char _srcBuff[MAX_BUFFER_SIZE];
//volatile char _dstBuff[MAX_BUFFER_SIZE];

//volatile char *srcBuff;
//volatile char *dstBuff;
/****************************************************************************/
/*                                                                          */
/*              ȫֱ                                                    */
/*                                                                          */
/****************************************************************************/
unsigned short emif_wbuffer[EMIF_BUFFER_LENGTH];
unsigned short emif_rbuffer[EMIF_BUFFER_LENGTH];

volatile int irqRaised;

#ifdef CHTYPE_DMA
    unsigned int chType     = EDMA3_CHANNEL_TYPE_DMA;
    unsigned int chNum      = 0;
    unsigned int tccNum     = 0;
    unsigned int edmaTC     = 0;
    unsigned int syncType   = EDMA3_SYNC_A;
    unsigned int trigMode   = EDMA3_TRIG_MODE_MANUAL;
    unsigned int evtQ       = 0; // ʹõ¼
#else
unsigned int chType 	= EDMA3_CHANNEL_TYPE_QDMA;
unsigned int chNum		= 0;
unsigned int tccNum 	= 0;
unsigned int edmaTC 	= 0;
unsigned int syncType	  = EDMA3_SYNC_AB;//EDMA3_SYNC_A;//
unsigned int trigMode	  = EDMA3_TRIG_MODE_QDMA;
unsigned int paRAMId		= 32u;
unsigned int evtQ			= 0;/* Event Queue used 					*/
unsigned int opt			= 0;
#endif

volatile char *srcBuff;
volatile char *dstBuff;

/****************************************************************************/
/*                                                                          */
/*                                                                  */
/*                                                                          */
/****************************************************************************/
// ص
void (*cb_Fxn[EDMA3_NUM_TCC])(unsigned int tcc, unsigned int status, void *appData);
/****************************************************************************/
/*                                                                          */
/*                                                                  */
/*                                                                          */
/****************************************************************************/
void Delay(volatile unsigned int count);
void PSCInit(void);
void EMIFASetup(void);

#ifdef CHTYPE_DMA
unsigned int EDMA3();
#else
unsigned int QDMA3();
#endif

//void registerEdma3Interrupts();
//void edma3CCComplIsr();
//void edma3CCErrIsr();

/****************************************************************************/
/*                                                                          */
/*              ص                                                    */
/*                                                                          */
/****************************************************************************/
void callback(unsigned int tccNum, unsigned int status, void *appData)
{
    (void)tccNum;
    (void)appData;

    if(EDMA3_XFER_COMPLETE == status)
    {
		// ɹ
        irqRaised = 1;
    }

    else if(EDMA3_CC_DMA_EVT_MISS == status)
    {
		// 䵼 DMA ¼ʧ
		irqRaised = -1;
    }

    else if(EDMA3_CC_QDMA_EVT_MISS == status)
    {
    	// 䵼 QDMA ¼ʧ
		irqRaised = -2;
    }

    irqRaised = 1;
}

/****************************************************************************/
/*                                                                          */
/*              PSC ʼ                                                  */
/*                                                                          */
/****************************************************************************/
void PSCInit(void)
{
	// ʹEMIFAģ
	PSCModuleControl(SOC_PSC_0_REGS, HW_PSC_EMIFA, PSC_POWERDOMAIN_ALWAYS_ON,PSC_MDCTL_NEXT_ENABLE);

	// ʹ EDMA3CC_0
    PSCModuleControl(SOC_PSC_0_REGS, 0, 0, PSC_MDCTL_NEXT_ENABLE);

    // ʹ EDMA3TC_0
    PSCModuleControl(SOC_PSC_0_REGS, 1, 0, PSC_MDCTL_NEXT_ENABLE);
}
/****************************************************************************/
/*                                                                          */
/*              ʼEMIFA                                           */
/*                                                                          */
/****************************************************************************/
void EMIFASetup(void)
{
	/*EMIFAظ*/
	EMIFAPinMuxSetup();

	/*16bit*/
	EMIFAAsyncDevDataBusWidthSelect(SOC_EMIFA_0_REGS,EMIFA_CHIP_SELECT_2,
									EMIFA_DATA_BUSWITTH_16BIT);

	/*ѡNormalģʽ*/
	EMIFAAsyncDevOpModeSelect(SOC_EMIFA_0_REGS,EMIFA_CHIP_SELECT_2,
							   EMIFA_ASYNC_INTERFACE_NORMAL_MODE);

	/*ֹWAIT*/
	EMIFAExtendedWaitConfig(SOC_EMIFA_0_REGS,EMIFA_CHIP_SELECT_2,
							 EMIFA_EXTENDED_WAIT_DISABLE);

	/*W_SETUP/R_SETUP   W_STROBE/R_STROBE    W_HOLD/R_HOLD	TAȲ*/
	EMIFAWaitTimingConfig(SOC_EMIFA_0_REGS,EMIFA_CHIP_SELECT_2,
						   EMIFA_ASYNC_WAITTIME_CONFIG(0, 3, 0, 0, 3, 0, 0 ));
}
/****************************************************************************/
/*                                                                          */
/*              EDMA3                                                   */
/*                                                                          */
/****************************************************************************/
#ifdef CHTYPE_DMA
/****************************************************************************/
/*                                                                          */
/*              EDMA3                                                   */
/*                                                                          */
/****************************************************************************/
unsigned int EDMA3()
{
    volatile unsigned int index = 0;
    volatile unsigned int count = 0;

    EDMA3CCPaRAMEntry paramSet;
    unsigned int retVal = 0u;
    unsigned int numenabled = 0u;
    unsigned int acnt = MAX_ACOUNT;
    unsigned int bcnt = MAX_BCOUNT;
    unsigned int ccnt = MAX_CCOUNT;

    //  DMA ͨ TCC
    retVal = EDMA3RequestChannel(SOC_EDMA30CC_0_REGS, chType, chNum, tccNum, evtQ);

    // עص
    cb_Fxn[tccNum] = &callback;

    if (TRUE == retVal)
    {
        //  RAM ֵ
        paramSet.srcAddr    = (unsigned int)(srcBuff);
        paramSet.destAddr   = (unsigned int)(dstBuff);

        paramSet.aCnt = (unsigned short)acnt;
        paramSet.bCnt = (unsigned short)bcnt;
        paramSet.cCnt = (unsigned short)ccnt;

        //  SRC / DES 
        paramSet.srcBIdx = (short)acnt;
        paramSet.destBIdx = (short)acnt;

        if (syncType == EDMA3_SYNC_A)
        {
			// A Sync ģʽ
			paramSet.srcCIdx = (short)acnt;
			paramSet.destCIdx = (short)acnt;
        }
        else
        {
			// AB Sync ģʽ
			paramSet.srcCIdx = ((short)acnt * (short)bcnt);
            paramSet.destCIdx = ((short)acnt * (short)bcnt);
        }

        paramSet.linkAddr = (unsigned short)0xFFFFu;
        paramSet.bCntReload = (unsigned short)0u;
        paramSet.opt = 0u;
        // Src  Dest ʹ INCR ģʽ
        paramSet.opt &= 0xFFFFFFFCu;
        //  TCC
        paramSet.opt |= ((tccNum << EDMA3CC_OPT_TCC_SHIFT) & EDMA3CC_OPT_TCC);

        // ʹ Intermediate & Final ж
        paramSet.opt |= (1 << EDMA3CC_OPT_ITCINTEN_SHIFT);
        paramSet.opt |= (1 << EDMA3CC_OPT_TCINTEN_SHIFT);

        if (syncType == EDMA3_SYNC_A)
		{
        	paramSet.opt &= 0xFFFFFFFBu;
		}
        else
		{
		    // AB Sync ģʽ
        	paramSet.opt |= (1 << EDMA3CC_OPT_SYNCDIM_SHIFT);
		}

        // д RAM
        EDMA3SetPaRAM(SOC_EDMA30CC_0_REGS, chNum, &paramSet);
    }

    if (TRUE == retVal)
    {
        if (syncType == EDMA3_SYNC_A)
		{
        	numenabled = bcnt * ccnt;
		}
        else
		{
			// AB Sync ģʽ
			numenabled = ccnt;
		}

        for (index = 0; index < numenabled; index++)
		{
			irqRaised = 0;

			// ռĴʹܴ
			retVal = EDMA3EnableTransfer(SOC_EDMA30CC_0_REGS, chNum, EDMA3_TRIG_MODE_MANUAL);
			if (TRUE != retVal)
			{
				UARTPuts ("edma3Test: EDMA3EnableTransfer Failed.\r\n", -1);
				break;
			}

			// ȴжϷִ
			while (irqRaised == 0u)
			{

			}

			// ⴫״̬
			if (irqRaised < 0)
			{
				// ʱֹ
				UARTPuts("\r\nedma3Test: Event Miss Occured!!!\r\n", -1);

				// ־λ
				EDMA3ClearErrorBits(SOC_EDMA30CC_0_REGS, chNum, evtQ);
				break;
			}
		}
    }


    return retVal;
}
#else
/****************************************************************************/
/*                                                                          */
/*                       ʹQDMA3LCDд               						*/
/*                                                                          */
/****************************************************************************/
unsigned int QDMA3()
{
    volatile unsigned int index = 0u;
    volatile unsigned int count = 0u;
    EDMA3CCPaRAMEntry paramSet;
    unsigned int retVal = 0u;
    unsigned int numenabled = 0u;
    unsigned int acnt = MAX_ACOUNT;
    unsigned int bcnt = MAX_BCOUNT;
    unsigned int ccnt = MAX_CCOUNT;
    unsigned int dstBuffAddr = 0;

    //  DMA ͨ TCC
    retVal = EDMA3RequestChannel(SOC_EDMA30CC_0_REGS, chType, chNum, tccNum, evtQ);

    EDMA3MapQdmaChToPaRAM(SOC_EDMA30CC_0_REGS, chNum, &paRAMId);

    EDMA3SetQdmaTrigWord(SOC_EDMA30CC_0_REGS, chNum, EDMA3CC_PARAM_ENTRY_DST);

    // עص
    cb_Fxn[tccNum] = &callback;

    if (TRUE == retVal)
    {
    	//  RAM ֵ
        paramSet.srcAddr    = (unsigned int)(srcBuff);
        paramSet.destAddr   = (unsigned int)(dstBuff);

        paramSet.aCnt = (unsigned short)acnt;
        paramSet.bCnt = (unsigned short)bcnt;
        paramSet.cCnt = (unsigned short)ccnt;
        //  SRC / DES 
        paramSet.srcBIdx = (short)acnt;
        paramSet.destBIdx = (short)acnt;
        if (syncType == EDMA3_SYNC_A)
        {
        	// A Sync ģʽ
			paramSet.srcCIdx = (short)acnt;
			paramSet.destCIdx = (short)acnt;
        }
        else
        {
        	// AB Sync ģʽ
            paramSet.srcCIdx = ((short)acnt * (short)bcnt);
            paramSet.destCIdx = ((short)acnt * (short)bcnt);
        }
        paramSet.linkAddr = (unsigned short)0xFFFFu;
        paramSet.bCntReload = (unsigned short)0u;
        paramSet.opt = 0u;
        // Src & Dest ʹ INCR ģʽ
        paramSet.opt &= 0xFFFFFFFCu;
        //  TCC
        paramSet.opt |= ((tccNum << EDMA3CC_OPT_TCC_SHIFT) & EDMA3CC_OPT_TCC);

        // ʹ Intermediate & Final ж
        paramSet.opt |= (1 << EDMA3CC_OPT_ITCINTEN_SHIFT);
        paramSet.opt |= (1 << EDMA3CC_OPT_TCINTEN_SHIFT);

        if (syncType == EDMA3_SYNC_A)
		{
        	paramSet.opt &= 0xFFFFFFFBu;
		}
        else
		{
        	// AB Sync ģʽ
        	paramSet.opt |= (1 << EDMA3CC_OPT_SYNCDIM_SHIFT);
		}

        opt = paramSet.opt;
        // PaRAM
        EDMA3QdmaSetPaRAM(SOC_EDMA30CC_0_REGS, chNum, paRAMId, &paramSet);
    }

    retVal = EDMA3EnableTransfer(SOC_EDMA30CC_0_REGS, chNum, EDMA3_TRIG_MODE_QDMA);

    if (TRUE == retVal)
    {

        if (syncType == EDMA3_SYNC_A)
        {
            numenabled = bcnt * ccnt;
        }
        else
        {
        	// AB Sync ģʽ
            numenabled = ccnt;
        }

        for (index = 0; index < numenabled; index++)
        {
            irqRaised = 0u;

            if (index == (numenabled-1u))
            {
                opt |= EDMA3CC_OPT_STATIC;
                EDMA3QdmaSetPaRAMEntry(SOC_EDMA30CC_0_REGS, paRAMId,
                                                  EDMA3CC_PARAM_ENTRY_OPT, opt);
            }

            opt |= EDMA3CC_OPT_FWID_8BIT;
            EDMA3QdmaSetPaRAMEntry(SOC_EDMA30CC_0_REGS, paRAMId,
                                                  EDMA3CC_PARAM_ENTRY_OPT, opt);


            dstBuffAddr = (unsigned int)EDMA3QdmaGetPaRAMEntry(
                         SOC_EDMA30CC_0_REGS, paRAMId, EDMA3CC_PARAM_ENTRY_DST);
            EDMA3QdmaSetPaRAMEntry(SOC_EDMA30CC_0_REGS, paRAMId,
                                          EDMA3CC_PARAM_ENTRY_DST, dstBuffAddr);

            // ȴжϷ
			while (irqRaised == 0u)
			{

			}

			// ⴫״̬
			if (irqRaised < 0)
			{
				// ʱж
				UARTPuts("\r\nQdma3Test: Event Miss Occured!!!\r\n", -1);

				// ־λ
			    EDMA3ClearErrorBits(SOC_EDMA30CC_0_REGS, chNum, evtQ);
			    break;
			}
        }
    }
    EDMA3FreeChannel(SOC_EDMA30CC_0_REGS, EDMA3_CHANNEL_TYPE_QDMA,
    		chNum, EDMA3_TRIG_MODE_QDMA, tccNum, evtQ);

    return TRUE;
}
#endif

/****************************************************************************/
/*                                                                          */
/*              EDMA3 жɷ                                      */
/*                                                                          */
/****************************************************************************/
Void EDMA3CCComplIsr(UArg arg)
{
    volatile unsigned int pendingIrqs;
    volatile unsigned int isIPR = 0;

    unsigned int indexl;
    unsigned int Cnt = 0;
    indexl = 1u;

    isIPR = EDMA3GetIntrStatus(SOC_EDMA30CC_0_REGS);
    if(isIPR)
    {
        while ((Cnt < EDMA3CC_COMPL_HANDLER_RETRY_COUNT)&& (indexl != 0u))
		{
			indexl = 0u;
			pendingIrqs = EDMA3GetIntrStatus(SOC_EDMA30CC_0_REGS);
			while (pendingIrqs)
			{
				if(TRUE == (pendingIrqs & 1u))
				{
					// ûָص ޷ IPR Ӧλ
					// д ICR  IPR Ӧλ
					EDMA3ClrIntr(SOC_EDMA30CC_0_REGS, indexl);
					(*cb_Fxn[indexl])(indexl, EDMA3_XFER_COMPLETE, NULL);
				}

				++indexl;
				pendingIrqs >>= 1u;
			}

			Cnt++;
		}
    }
}

/****************************************************************************/
/*                                                                          */
/*              EDMA3 жϴ                                      */
/*                                                                          */
/****************************************************************************/
Void EDMA3CCErrIsr(UArg arg)
{
    volatile unsigned int pendingIrqs;
    unsigned int Cnt = 0u;
    unsigned int index;
    unsigned int evtqueNum = 0;  // ¼Ŀ

    pendingIrqs = 0u;
    index = 1u;

    if((EDMA3GetErrIntrStatus(SOC_EDMA30CC_0_REGS) != 0 )
        || (EDMA3QdmaGetErrIntrStatus(SOC_EDMA30CC_0_REGS) != 0)
        || (EDMA3GetCCErrStatus(SOC_EDMA30CC_0_REGS) != 0))
    {
        // ѭ EDMA3CC_ERR_HANDLER_RETRY_COUNT 
    	// ֱûеȴежʱֹ
        while ((Cnt < EDMA3CC_ERR_HANDLER_RETRY_COUNT) && (index != 0u))
        {
            index = 0u;
            pendingIrqs = EDMA3GetErrIntrStatus(SOC_EDMA30CC_0_REGS);

            while (pendingIrqs)
            {
				// ִеȴеж
				if(TRUE == (pendingIrqs & 1u))
				{
					//  SER
					EDMA3ClrMissEvt(SOC_EDMA30CC_0_REGS, index);
				}
					++index;
					pendingIrqs >>= 1u;
			}

			index = 0u;
			pendingIrqs = EDMA3QdmaGetErrIntrStatus(SOC_EDMA30CC_0_REGS);

			while (pendingIrqs)
			{
				// ִеȴеж
				if(TRUE == (pendingIrqs & 1u))
				{
					//  SER
					EDMA3QdmaClrMissEvt(SOC_EDMA30CC_0_REGS, index);
				}
				++index;
				pendingIrqs >>= 1u;
			}

			index = 0u;
			pendingIrqs = EDMA3GetCCErrStatus(SOC_EDMA30CC_0_REGS);

			if (pendingIrqs != 0u)
			{
				// ִеȴе CC ж
				// ¼ ڴ
				for (evtqueNum = 0u; evtqueNum < SOC_EDMA3_NUM_EVQUE; evtqueNum++)
				{
					if((pendingIrqs & (1u << evtqueNum)) != 0u)
					{
						// ж
						EDMA3ClrCCErr(SOC_EDMA30CC_0_REGS, (1u << evtqueNum));
					}
				}

				// ɴ
				if ((pendingIrqs & (1 << EDMA3CC_CCERR_TCCERR_SHIFT)) != 0u)
				{
					EDMA3ClrCCErr(SOC_EDMA30CC_0_REGS, (0x01u << EDMA3CC_CCERR_TCCERR_SHIFT));
				}

				++index;
			}

			Cnt++;
        }
    }
}

/****************************************************************************/
/*                                                                          */
/*                                                                      */
/*                                                                          */
/****************************************************************************/
Void smain(UArg a0, UArg a1)
{
		volatile int EMIFA_error_count = 0;
		int i,j;
		unsigned int flag;
		char ch[2];
		char  put_char[50];

		// ܲԣ
		long long t_start, t_stop, t_overhead;
		TSCL = 0;
		TSCH = 0;
	    t_start = _itoll(TSCH, TSCL);
	    t_stop = _itoll(TSCH, TSCL);
	    t_overhead = t_stop - t_start;

		/* жϿʼ */
		//IntDSPINTCInit();
		//IntGlobalEnable();

		/* ʼն ʹô2*/
		//UARTStdioInit();

		/* ӡնϢ*/
	    UARTPuts("EMIFA Test Application.\r\n", -2);

		/* ʹPSC*/
	    //PSCInit();

		/*ʼEMIFA*/
		EMIFASetup();

		EDMA3Init(SOC_EDMA30CC_0_REGS, evtQ);
		//registerEdma3Interrupts();

		/*ʼݻ*/
		for (i = 0; i < EMIF_BUFFER_LENGTH; i++)
		{
		   emif_wbuffer[i] = (short)(i);
		   emif_rbuffer[i] = 0xDEAD;
		}

		/*FPGAд*/
		UARTprintf( "Writing %d words to FPGA\r\n", EMIF_BUFFER_LENGTH );

		// EMIFͨٶȲ
		// ʼֵ
		t_start = _itoll(TSCH, TSCL);

		srcBuff = (char *)(emif_wbuffer);
		dstBuff = (char *)(SOC_EMIFA_CS2_ADDR);
	#ifdef CHTYPE_DMA
		flag = EDMA3();
	#else
		flag = QDMA3();
	#endif

		// ֵ
		t_stop = _itoll(TSCH, TSCL);
		if(flag == TRUE)
		{
			sprintf(put_char,"\tEMIF Write Speed: %f MB/s \n",
					(float)EMIF_BUFFER_LENGTH * 2 / 1024 / 1024 * 456000000/((t_stop - t_start) - t_overhead));
			UARTPuts(put_char, -2);
		}

		/*ȡFPGAݻ*/
		UARTprintf( "Reading %d words to FPGA\r\n", EMIF_BUFFER_LENGTH );

		// EMIFͨٶȲ
		// ʼֵ
		t_start = _itoll(TSCH, TSCL);

		srcBuff = (char *)(SOC_EMIFA_CS2_ADDR);
		dstBuff = (char *)(emif_rbuffer);
	#ifdef CHTYPE_DMA
		flag = EDMA3();
	#else
		flag = QDMA3();
	#endif

		// ֵ
		t_stop = _itoll(TSCH, TSCL);
		if(flag == TRUE)
		{
			sprintf(put_char,"\tEMIF Read Speed: %f MB/s \n",
					(float)EMIF_BUFFER_LENGTH * 2 / 1024 / 1024 * 456000000/((t_stop - t_start) - t_overhead));
			UARTPuts(put_char, -2);
		}

		/*EMIFAǷȷ (loopback modes only)*/
		UARTPuts("Data mismatch in buffers.\n",-2);
		for (i = 0; i<EMIF_BUFFER_LENGTH; i++)
		{
			if (emif_wbuffer[i] != emif_rbuffer[i])
			{
				EMIFA_error_count++;
			}
		}

		/* ͨŽ*/
		if (EMIFA_error_count)
		{
			UARTprintf( "EMIFA_error_count=%d\n",EMIFA_error_count);
			while(1);
		}
		else
			UARTPuts("EMIFA transfers complete!\n",-2);

		UARTPuts("Do you want to print all the data?(y/n)   ",-2);
		UARTGets(ch,2);
		UARTPuts("\n", -2);

		if(ch[0] == 'y')
		{
			/*ӡȫ*/
			for(i=0; i<EMIF_BUFFER_LENGTH; )
			{
				for(j=0; j<5; j++)
				{
					UARTprintf("rd[%d]=%d   ",i,emif_rbuffer[i]);
					i++;
					if(i >= EMIF_BUFFER_LENGTH)
						break;

				}
				UARTPuts("\n",-2);
			}
		}

		/* ѭ*/
		for(;;)
		{

		}
}

/****************************************************************************/
/*                                                                          */
/*                                                                    */
/*                                                                          */
/****************************************************************************/
int main(void)
{
	// ʹ
	PSCInit();

	// ն˳ʼ
   	UARTStdioInit();

   	UARTPuts("Tronlong EDMA / QDMA Application......\r\n\r\n", -1);

    //  SYS/BIOS ϵͳ
    BIOS_start();

    return(0);
}
