/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
/** ============================================================================
 *   @file  cslr_tcp2.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Descriptions for TCP2
 */
#ifndef _CSLR_TCP2_H_
#define _CSLR_TCP2_H_

#include <cslr.h>
#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 PID;
    volatile Uint8 RSVD0[72];
    volatile Uint32 TCPEXE;
    volatile Uint32 TCPEND;
    volatile Uint8 RSVD1[12];
    volatile Uint32 TCPERR;
    volatile Uint8 RSVD2[4];
    volatile Uint32 TCPSTAT;
    volatile Uint8 RSVD3[4];
    volatile Uint32 TCPEMU;
} CSL_Tcp2Regs;

/**************************************************************************\
* Register Overlay Structure for input and output configuration registers
\**************************************************************************/
typedef struct  {
    volatile Uint32 TCPIC0;
    volatile Uint32 TCPIC1;
    volatile Uint32 TCPIC2;
    volatile Uint32 TCPIC3;
    volatile Uint32 TCPIC4;
    volatile Uint32 TCPIC5;
    volatile Uint32 TCPIC6;
    volatile Uint32 TCPIC7;
    volatile Uint32 TCPIC8;
    volatile Uint32 TCPIC9;
    volatile Uint32 TCPIC10;
    volatile Uint32 TCPIC11;
    volatile Uint32 TCPIC12;
    volatile Uint32 TCPIC13;
    volatile Uint32 TCPIC14;
    volatile Uint32 TCPIC15;
    volatile Uint32 TCPOUT0;
    volatile Uint32 TCPOUT1;
    volatile Uint32 TCPOUT2;
} CSL_Tcp2CfgRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* PID */

#define CSL_TCP2_PID_TYPE_MASK           (0x00FF0000u)
#define CSL_TCP2_PID_TYPE_SHIFT          (0x00000010u)
#define CSL_TCP2_PID_TYPE_RESETVAL       (0x00000002u)

#define CSL_TCP2_PID_CLASS_MASK          (0x0000FF00u)
#define CSL_TCP2_PID_CLASS_SHIFT         (0x00000008u)
#define CSL_TCP2_PID_CLASS_RESETVAL      (0x00000011u)

#define CSL_TCP2_PID_REV_MASK            (0x000000FFu)
#define CSL_TCP2_PID_REV_SHIFT           (0x00000000u)
#define CSL_TCP2_PID_REV_RESETVAL        (0x00000211u)

#define CSL_TCP2_PID_RESETVAL            (0x00021311u)

/* TCPEXE */

#define CSL_TCP2_TCPEXE_EXECUTION_INSTR_MASK (0x00000007u)
#define CSL_TCP2_TCPEXE_EXECUTION_INSTR_SHIFT (0x00000000u)
#define CSL_TCP2_TCPEXE_EXECUTION_INSTR_RESETVAL (0x00000000u)

/*----EXECUTION_INSTR Tokens----*/
#define CSL_TCP2_TCPEXE_EXECUTION_INSTR_NO (0x00000000u)
#define CSL_TCP2_TCPEXE_EXECUTION_INSTR_START (0x00000001u)
#define CSL_TCP2_TCPEXE_EXECUTION_INSTR_DEBUG0 (0x00000004u)
#define CSL_TCP2_TCPEXE_EXECUTION_INSTR_DEBUG6 (0x00000005u)
#define CSL_TCP2_TCPEXE_EXECUTION_INSTR_DEBUG (0x00000006u)
#define CSL_TCP2_TCPEXE_EXECUTION_INSTR_SOFTRESET (0x00000007u)

#define CSL_TCP2_TCPEXE_RESETVAL         (0x00000000u)

/* TCPEND */

#define CSL_TCP2_TCPEND_SLPZVSS_EN_MASK  (0x00000200u)
#define CSL_TCP2_TCPEND_SLPZVSS_EN_SHIFT (0x00000009u)
#define CSL_TCP2_TCPEND_SLPZVSS_EN_RESETVAL (0x00000001u)

/*----SLPZVSS_EN Tokens----*/
#define CSL_TCP2_TCPEND_SLPZVSS_EN_DISABLE (0x00000000u)
#define CSL_TCP2_TCPEND_SLPZVSS_EN_ENABLE (0x00000001u)

#define CSL_TCP2_TCPEND_SLPZVDD_EN_MASK  (0x00000100u)
#define CSL_TCP2_TCPEND_SLPZVDD_EN_SHIFT (0x00000008u)
#define CSL_TCP2_TCPEND_SLPZVDD_EN_RESETVAL (0x00000001u)

/*----SLPZVDD_EN Tokens----*/
#define CSL_TCP2_TCPEND_SLPZVDD_EN_DISABLE (0x00000000u)
#define CSL_TCP2_TCPEND_SLPZVDD_EN_ENABLE (0x00000001u)

#define CSL_TCP2_TCPEND_ENDIAN_EXTR_MASK (0x00000002u)
#define CSL_TCP2_TCPEND_ENDIAN_EXTR_SHIFT (0x00000001u)
#define CSL_TCP2_TCPEND_ENDIAN_EXTR_RESETVAL (0x00000000u)

/*----ENDIAN_EXTR Tokens----*/
#define CSL_TCP2_TCPEND_ENDIAN_EXTR_32BITS (0x00000000u)
#define CSL_TCP2_TCPEND_ENDIAN_EXTR_NATIVE8 (0x00000001u)

#define CSL_TCP2_TCPEND_ENDIAN_INTR_MASK (0x00000001u)
#define CSL_TCP2_TCPEND_ENDIAN_INTR_SHIFT (0x00000000u)
#define CSL_TCP2_TCPEND_ENDIAN_INTR_RESETVAL (0x00000000u)

/*----ENDIAN_INTR Tokens----*/
#define CSL_TCP2_TCPEND_ENDIAN_INTR_32BITS (0x00000000u)
#define CSL_TCP2_TCPEND_ENDIAN_INTR_NATIVE16 (0x00000001u)

#define CSL_TCP2_TCPEND_RESETVAL         (0x00000300u)

/* TCPERR */

#define CSL_TCP2_TCPERR_MAXMINITER_MASK  (0x00004000u)
#define CSL_TCP2_TCPERR_MAXMINITER_SHIFT (0x0000000Eu)
#define CSL_TCP2_TCPERR_MAXMINITER_RESETVAL (0x00000000u)

#define CSL_TCP2_TCPERR_ACC_MASK         (0x00000800u)
#define CSL_TCP2_TCPERR_ACC_SHIFT        (0x0000000Bu)
#define CSL_TCP2_TCPERR_ACC_RESETVAL     (0x00000000u)

#define CSL_TCP2_TCPERR_OP_MASK          (0x00000400u)
#define CSL_TCP2_TCPERR_OP_SHIFT         (0x0000000Au)
#define CSL_TCP2_TCPERR_OP_RESETVAL      (0x00000000u)

#define CSL_TCP2_TCPERR_INT_MASK         (0x00000200u)
#define CSL_TCP2_TCPERR_INT_SHIFT        (0x00000009u)
#define CSL_TCP2_TCPERR_INT_RESETVAL     (0x00000000u)

#define CSL_TCP2_TCPERR_SNR_MASK         (0x00000100u)
#define CSL_TCP2_TCPERR_SNR_SHIFT        (0x00000008u)
#define CSL_TCP2_TCPERR_SNR_RESETVAL     (0x00000000u)

#define CSL_TCP2_TCPERR_R_MASK           (0x00000080u)
#define CSL_TCP2_TCPERR_R_SHIFT          (0x00000007u)
#define CSL_TCP2_TCPERR_R_RESETVAL       (0x00000000u)

#define CSL_TCP2_TCPERR_SF_MASK          (0x00000010u)
#define CSL_TCP2_TCPERR_SF_SHIFT         (0x00000004u)
#define CSL_TCP2_TCPERR_SF_RESETVAL      (0x00000000u)

#define CSL_TCP2_TCPERR_P_MASK           (0x00000004u)
#define CSL_TCP2_TCPERR_P_SHIFT          (0x00000002u)
#define CSL_TCP2_TCPERR_P_RESETVAL       (0x00000000u)

#define CSL_TCP2_TCPERR_F_MASK           (0x00000002u)
#define CSL_TCP2_TCPERR_F_SHIFT          (0x00000001u)
#define CSL_TCP2_TCPERR_F_RESETVAL       (0x00000000u)

#define CSL_TCP2_TCPERR_ERR_MASK         (0x00000001u)
#define CSL_TCP2_TCPERR_ERR_SHIFT        (0x00000000u)
#define CSL_TCP2_TCPERR_ERR_RESETVAL     (0x00000000u)

#define CSL_TCP2_TCPERR_RESETVAL         (0x00000000u)

/* TCPSTAT */

#define CSL_TCP2_TCPSTAT_TCP_STATE_MASK  (0x0F000000u)
#define CSL_TCP2_TCPSTAT_TCP_STATE_SHIFT (0x00000018u)
#define CSL_TCP2_TCPSTAT_TCP_STATE_RESETVAL (0x00000000u)

#define CSL_TCP2_TCPSTAT_CRC_PASS_MASK   (0x00800000u)
#define CSL_TCP2_TCPSTAT_CRC_PASS_SHIFT  (0x00000017u)
#define CSL_TCP2_TCPSTAT_CRC_PASS_RESETVAL (0x00000000u)

#define CSL_TCP2_TCPSTAT_SNR_EXCEED_MASK (0x00600000u)
#define CSL_TCP2_TCPSTAT_SNR_EXCEED_SHIFT (0x00000015u)
#define CSL_TCP2_TCPSTAT_SNR_EXCEED_RESETVAL (0x00000000u)

/*----SNR_EXCEED Tokens----*/
#define CSL_TCP2_TCPSTAT_SNR_EXCEED_MAP01_FAIL (0x00000000u)
#define CSL_TCP2_TCPSTAT_SNR_EXCEED_MAP0_PASS (0x00000001u)
#define CSL_TCP2_TCPSTAT_SNR_EXCEED_MAP1_PASS (0x00000002u)

#define CSL_TCP2_TCPSTAT_ACTIVE_ITER_MASK (0x001F0000u)
#define CSL_TCP2_TCPSTAT_ACTIVE_ITER_SHIFT (0x00000010u)
#define CSL_TCP2_TCPSTAT_ACTIVE_ITER_RESETVAL (0x00000000u)

#define CSL_TCP2_TCPSTAT_ACTIVE_STATE_MASK (0x0000F000u)
#define CSL_TCP2_TCPSTAT_ACTIVE_STATE_SHIFT (0x0000000Cu)
#define CSL_TCP2_TCPSTAT_ACTIVE_STATE_RESETVAL (0x00000000u)

#define CSL_TCP2_TCPSTAT_ACTIVE_MAP_MASK (0x00000800u)
#define CSL_TCP2_TCPSTAT_ACTIVE_MAP_SHIFT (0x0000000Bu)
#define CSL_TCP2_TCPSTAT_ACTIVE_MAP_RESETVAL (0x00000000u)

/*----ACTIVE_MAP Tokens----*/
#define CSL_TCP2_TCPSTAT_ACTIVE_MAP_MAP0 (0x00000000u)
#define CSL_TCP2_TCPSTAT_ACTIVE_MAP_MAP1 (0x00000001u)

#define CSL_TCP2_TCPSTAT_EMUHALT_MASK    (0x00000400u)
#define CSL_TCP2_TCPSTAT_EMUHALT_SHIFT   (0x0000000Au)
#define CSL_TCP2_TCPSTAT_EMUHALT_RESETVAL (0x00000000u)

#define CSL_TCP2_TCPSTAT_ROP_MASK        (0x00000200u)
#define CSL_TCP2_TCPSTAT_ROP_SHIFT       (0x00000009u)
#define CSL_TCP2_TCPSTAT_ROP_RESETVAL    (0x00000000u)

#define CSL_TCP2_TCPSTAT_RHD_MASK        (0x00000100u)
#define CSL_TCP2_TCPSTAT_RHD_SHIFT       (0x00000008u)
#define CSL_TCP2_TCPSTAT_RHD_RESETVAL    (0x00000000u)

#define CSL_TCP2_TCPSTAT_REXT_MASK       (0x00000080u)
#define CSL_TCP2_TCPSTAT_REXT_SHIFT      (0x00000007u)
#define CSL_TCP2_TCPSTAT_REXT_RESETVAL   (0x00000000u)

#define CSL_TCP2_TCPSTAT_WAP_MASK        (0x00000040u)
#define CSL_TCP2_TCPSTAT_WAP_SHIFT       (0x00000006u)
#define CSL_TCP2_TCPSTAT_WAP_RESETVAL    (0x00000000u)

#define CSL_TCP2_TCPSTAT_WSP_MASK        (0x00000020u)
#define CSL_TCP2_TCPSTAT_WSP_SHIFT       (0x00000005u)
#define CSL_TCP2_TCPSTAT_WSP_RESETVAL    (0x00000000u)

#define CSL_TCP2_TCPSTAT_WINT_MASK       (0x00000010u)
#define CSL_TCP2_TCPSTAT_WINT_SHIFT      (0x00000004u)
#define CSL_TCP2_TCPSTAT_WINT_RESETVAL   (0x00000000u)

#define CSL_TCP2_TCPSTAT_WIC_MASK        (0x00000008u)
#define CSL_TCP2_TCPSTAT_WIC_SHIFT       (0x00000003u)
#define CSL_TCP2_TCPSTAT_WIC_RESETVAL    (0x00000000u)

#define CSL_TCP2_TCPSTAT_ERR_MASK        (0x00000004u)
#define CSL_TCP2_TCPSTAT_ERR_SHIFT       (0x00000002u)
#define CSL_TCP2_TCPSTAT_ERR_RESETVAL    (0x00000000u)

#define CSL_TCP2_TCPSTAT_DEC_BUSY_MASK   (0x00000002u)
#define CSL_TCP2_TCPSTAT_DEC_BUSY_SHIFT  (0x00000001u)
#define CSL_TCP2_TCPSTAT_DEC_BUSY_RESETVAL (0x00000000u)

/*----DEC_BUSY Tokens----*/
#define CSL_TCP2_TCPSTAT_DEC_BUSY_STATE0 (0x00000000u)
#define CSL_TCP2_TCPSTAT_DEC_BUSY_STATE1_8 (0x00000001u)

#define CSL_TCP2_TCPSTAT_RESETVAL        (0x00000000u)

/* TCPEMU */

#define CSL_TCP2_TCPEMU_SOFT_MASK        (0x00000002u)
#define CSL_TCP2_TCPEMU_SOFT_SHIFT       (0x00000001u)
#define CSL_TCP2_TCPEMU_SOFT_RESETVAL    (0x00000000u)

#define CSL_TCP2_TCPEMU_FREE_MASK        (0x00000001u)
#define CSL_TCP2_TCPEMU_FREE_SHIFT       (0x00000000u)
#define CSL_TCP2_TCPEMU_FREE_RESETVAL    (0x00000000u)

#define CSL_TCP2_TCPEMU_RESETVAL         (0x00000000u)


/* TCPIC0 */

#define CSL_TCP2_TCPIC0_FL_MASK          (0x7FFF0000u)
#define CSL_TCP2_TCPIC0_FL_SHIFT         (0x00000010u)
#define CSL_TCP2_TCPIC0_FL_RESETVAL      (0x00000000u)

#define CSL_TCP2_TCPIC0_NUMSW_MASK       (0x00004000u)
#define CSL_TCP2_TCPIC0_NUMSW_SHIFT      (0x0000000Eu)
#define CSL_TCP2_TCPIC0_NUMSW_RESETVAL   (0x00000000u)

/*----NUMSW Tokens----*/
#define CSL_TCP2_TCPIC0_NUMSW_LEQ_128    (0x00000000u)
#define CSL_TCP2_TCPIC0_NUMSW_G_128      (0x00000001u)

#define CSL_TCP2_TCPIC0_OUTF_MASK        (0x00002000u)
#define CSL_TCP2_TCPIC0_OUTF_SHIFT       (0x0000000Du)
#define CSL_TCP2_TCPIC0_OUTF_RESETVAL    (0x00000000u)

/*----OUTF Tokens----*/
#define CSL_TCP2_TCPIC0_OUTF_NO          (0x00000000u)
#define CSL_TCP2_TCPIC0_OUTF_YES         (0x00000001u)

#define CSL_TCP2_TCPIC0_INTER_MASK       (0x00001000u)
#define CSL_TCP2_TCPIC0_INTER_SHIFT      (0x0000000Cu)
#define CSL_TCP2_TCPIC0_INTER_RESETVAL   (0x00000000u)

/*----INTER Tokens----*/
#define CSL_TCP2_TCPIC0_INTER_NO         (0x00000000u)
#define CSL_TCP2_TCPIC0_INTER_YES        (0x00000001u)

#define CSL_TCP2_TCPIC0_RATE_MASK        (0x00000700u)
#define CSL_TCP2_TCPIC0_RATE_SHIFT       (0x00000008u)
#define CSL_TCP2_TCPIC0_RATE_RESETVAL    (0x00000000u)

/*----RATE Tokens----*/
#define CSL_TCP2_TCPIC0_RATE_3_4         (0x00000001u)
#define CSL_TCP2_TCPIC0_RATE_1_2         (0x00000002u)
#define CSL_TCP2_TCPIC0_RATE_1_3         (0x00000003u)
#define CSL_TCP2_TCPIC0_RATE_1_4         (0x00000004u)
#define CSL_TCP2_TCPIC0_RATE_1_5         (0x00000005u)

#define CSL_TCP2_TCPIC0_OPMOD_MASK       (0x00000006u)
#define CSL_TCP2_TCPIC0_OPMOD_SHIFT      (0x00000001u)
#define CSL_TCP2_TCPIC0_OPMOD_RESETVAL   (0x00000000u)

/*----OPMOD Tokens----*/
#define CSL_TCP2_TCPIC0_OPMOD_SA         (0x00000000u)
#define CSL_TCP2_TCPIC0_OPMOD_SP_FF      (0x00000001u)
#define CSL_TCP2_TCPIC0_OPMOD_SP_MF      (0x00000002u)
#define CSL_TCP2_TCPIC0_OPMOD_SP_LF      (0x00000003u)

#define CSL_TCP2_TCPIC0_RESETVAL         (0x00000000u)

/* TCPIC1 */

#define CSL_TCP2_TCPIC1_R_MASK           (0x007F0000u)
#define CSL_TCP2_TCPIC1_R_SHIFT          (0x00000010u)
#define CSL_TCP2_TCPIC1_R_RESETVAL       (0x00000000u)

#define CSL_TCP2_TCPIC1_RESETVAL         (0x00000000u)

/* TCPIC2 */

#define CSL_TCP2_TCPIC2_SNR_MASK         (0xFF000000u)
#define CSL_TCP2_TCPIC2_SNR_SHIFT        (0x00000018u)
#define CSL_TCP2_TCPIC2_SNR_RESETVAL     (0x00000000u)

/*----SNR Tokens----*/
#define CSL_TCP2_TCPIC2_SNR_DISABLE      (0x00000000u)

#define CSL_TCP2_TCPIC2_MAXIT_MASK       (0x001F0000u)
#define CSL_TCP2_TCPIC2_MAXIT_SHIFT      (0x00000010u)
#define CSL_TCP2_TCPIC2_MAXIT_RESETVAL   (0x00000000u)

#define CSL_TCP2_TCPIC2_NSB_MASK         (0x00007F00u)
#define CSL_TCP2_TCPIC2_NSB_SHIFT        (0x00000008u)
#define CSL_TCP2_TCPIC2_NSB_RESETVAL     (0x00000000u)

#define CSL_TCP2_TCPIC2_P_MASK           (0x0000003Fu)
#define CSL_TCP2_TCPIC2_P_SHIFT          (0x00000000u)
#define CSL_TCP2_TCPIC2_P_RESETVAL       (0x00000000u)

#define CSL_TCP2_TCPIC2_RESETVAL         (0x00000000u)

/* TCPIC3 */

#define CSL_TCP2_TCPIC3_OUTORDER_MASK    (0x00004000u)
#define CSL_TCP2_TCPIC3_OUTORDER_SHIFT   (0x0000000Eu)
#define CSL_TCP2_TCPIC3_OUTORDER_RESETVAL (0x00000000u)

/*----OUTORDER Tokens----*/
#define CSL_TCP2_TCPIC3_OUTORDER_0_31    (0x00000000u)
#define CSL_TCP2_TCPIC3_OUTORDER_31_0    (0x00000001u)

#define CSL_TCP2_TCPIC3_INPUTSIGN_MASK   (0x00001000u)
#define CSL_TCP2_TCPIC3_INPUTSIGN_SHIFT  (0x0000000Cu)
#define CSL_TCP2_TCPIC3_INPUTSIGN_RESETVAL (0x00000000u)

/*----INPUTSIGN Tokens----*/
#define CSL_TCP2_TCPIC3_INPUTSIGN_POSITIVE (0x00000000u)
#define CSL_TCP2_TCPIC3_INPUTSIGN_NEGATIVE (0x00000001u)

#define CSL_TCP2_TCPIC3_MINITER_MASK     (0x000001F0u)
#define CSL_TCP2_TCPIC3_MINITER_SHIFT    (0x00000004u)
#define CSL_TCP2_TCPIC3_MINITER_RESETVAL (0x00000000u)

#define CSL_TCP2_TCPIC3_EPRORED_MASK     (0x00000002u)
#define CSL_TCP2_TCPIC3_EPRORED_SHIFT    (0x00000001u)
#define CSL_TCP2_TCPIC3_EPRORED_RESETVAL (0x00000000u)

/*----EPRORED Tokens----*/
#define CSL_TCP2_TCPIC3_EPRORED_DISABLE  (0x00000000u)
#define CSL_TCP2_TCPIC3_EPRORED_ENABLE   (0x00000001u)

#define CSL_TCP2_TCPIC3_EMAXSTR_MASK     (0x00000001u)
#define CSL_TCP2_TCPIC3_EMAXSTR_SHIFT    (0x00000000u)
#define CSL_TCP2_TCPIC3_EMAXSTR_RESETVAL (0x00000000u)

/*----EMAXSTR Tokens----*/
#define CSL_TCP2_TCPIC3_EMAXSTR_DISABLE  (0x00000000u)
#define CSL_TCP2_TCPIC3_EMAXSTR_ENABLE   (0x00000001u)

#define CSL_TCP2_TCPIC3_RESETVAL         (0x00000000u)

/* TCPIC4 */

#define CSL_TCP2_TCPIC4_CRCITERPASS_MASK (0x00001F00u)
#define CSL_TCP2_TCPIC4_CRCITERPASS_SHIFT (0x00000008u)
#define CSL_TCP2_TCPIC4_CRCITERPASS_RESETVAL (0x00000000u)

#define CSL_TCP2_TCPIC4_CRCLEN_MASK      (0x0000003Fu)
#define CSL_TCP2_TCPIC4_CRCLEN_SHIFT     (0x00000000u)
#define CSL_TCP2_TCPIC4_CRCLEN_RESETVAL  (0x00000000u)

/*----CRCLEN Tokens----*/
#define CSL_TCP2_TCPIC4_CRCLEN_DISABLE   (0x00000000u)

#define CSL_TCP2_TCPIC4_RESETVAL         (0x00000000u)

/* TCPIC5 */

#define CSL_TCP2_TCPIC5_CRCPOLY_MASK     (0xFFFFFFFFu)
#define CSL_TCP2_TCPIC5_CRCPOLY_SHIFT    (0x00000000u)
#define CSL_TCP2_TCPIC5_CRCPOLY_RESETVAL (0x00000000u)

#define CSL_TCP2_TCPIC5_RESETVAL         (0x00000000u)

/* TCPIC6 */

#define CSL_TCP2_TCPIC6_TAIL1_MASK       (0x0003FFFFu)
#define CSL_TCP2_TCPIC6_TAIL1_SHIFT      (0x00000000u)
#define CSL_TCP2_TCPIC6_TAIL1_RESETVAL   (0x00000000u)

#define CSL_TCP2_TCPIC6_RESETVAL         (0x00000000u)

/* TCPIC7 */

#define CSL_TCP2_TCPIC7_TAIL2_MASK       (0x0003FFFFu)
#define CSL_TCP2_TCPIC7_TAIL2_SHIFT      (0x00000000u)
#define CSL_TCP2_TCPIC7_TAIL2_RESETVAL   (0x00000000u)

#define CSL_TCP2_TCPIC7_RESETVAL         (0x00000000u)

/* TCPIC8 */

#define CSL_TCP2_TCPIC8_TAIL3_MASK       (0x0003FFFFu)
#define CSL_TCP2_TCPIC8_TAIL3_SHIFT      (0x00000000u)
#define CSL_TCP2_TCPIC8_TAIL3_RESETVAL   (0x00000000u)

#define CSL_TCP2_TCPIC8_RESETVAL         (0x00000000u)

/* TCPIC9 */

#define CSL_TCP2_TCPIC9_TAIL4_MASK       (0x0003FFFFu)
#define CSL_TCP2_TCPIC9_TAIL4_SHIFT      (0x00000000u)
#define CSL_TCP2_TCPIC9_TAIL4_RESETVAL   (0x00000000u)

#define CSL_TCP2_TCPIC9_RESETVAL         (0x00000000u)

/* TCPIC10 */

#define CSL_TCP2_TCPIC10_TAIL5_MASK      (0x0003FFFFu)
#define CSL_TCP2_TCPIC10_TAIL5_SHIFT     (0x00000000u)
#define CSL_TCP2_TCPIC10_TAIL5_RESETVAL  (0x00000000u)

#define CSL_TCP2_TCPIC10_RESETVAL        (0x00000000u)

/* TCPIC11 */

#define CSL_TCP2_TCPIC11_TAIL6_MASK      (0x0003FFFFu)
#define CSL_TCP2_TCPIC11_TAIL6_SHIFT     (0x00000000u)
#define CSL_TCP2_TCPIC11_TAIL6_RESETVAL  (0x00000000u)

#define CSL_TCP2_TCPIC11_RESETVAL        (0x00000000u)

/* TCPIC12 */

#define CSL_TCP2_TCPIC12_EXT_SCALE_0_3_MASK (0x00FFFFFFu)
#define CSL_TCP2_TCPIC12_EXT_SCALE_0_3_SHIFT (0x00000000u)
#define CSL_TCP2_TCPIC12_EXT_SCALE_0_3_RESETVAL (0x00000000u)

#define CSL_TCP2_TCPIC12_RESETVAL        (0x00000000u)

/* TCPIC13 */

#define CSL_TCP2_TCPIC13_EXT_SCALE_4_7_MASK (0x00FFFFFFu)
#define CSL_TCP2_TCPIC13_EXT_SCALE_4_7_SHIFT (0x00000000u)
#define CSL_TCP2_TCPIC13_EXT_SCALE_4_7_RESETVAL (0x00000000u)

#define CSL_TCP2_TCPIC13_RESETVAL        (0x00000000u)

/* TCPIC14 */

#define CSL_TCP2_TCPIC14_EXT_SCALE_8_11_MASK (0x00FFFFFFu)
#define CSL_TCP2_TCPIC14_EXT_SCALE_8_11_SHIFT (0x00000000u)
#define CSL_TCP2_TCPIC14_EXT_SCALE_8_11_RESETVAL (0x00000000u)

#define CSL_TCP2_TCPIC14_RESETVAL        (0x00000000u)

/* TCPIC15 */

#define CSL_TCP2_TCPIC15_EXT_SCALE_12_15_MASK (0x00FFFFFFu)
#define CSL_TCP2_TCPIC15_EXT_SCALE_12_15_SHIFT (0x00000000u)
#define CSL_TCP2_TCPIC15_EXT_SCALE_12_15_RESETVAL (0x00000000u)

#define CSL_TCP2_TCPIC15_RESETVAL        (0x00000000u)

/* TCPOUT0 */

#define CSL_TCP2_TCPOUT0_FINAL_ITER_MASK (0x1F000000u)
#define CSL_TCP2_TCPOUT0_FINAL_ITER_SHIFT (0x00000018u)
#define CSL_TCP2_TCPOUT0_FINAL_ITER_RESETVAL (0x00000000u)

#define CSL_TCP2_TCPOUT0_SNR_M1_MASK     (0x000FFFFFu)
#define CSL_TCP2_TCPOUT0_SNR_M1_SHIFT    (0x00000000u)
#define CSL_TCP2_TCPOUT0_SNR_M1_RESETVAL (0x00000000u)

#define CSL_TCP2_TCPOUT0_RESETVAL        (0x00000000u)

/* TCPOUT1 */

#define CSL_TCP2_TCPOUT1_SNR_EXCEED_MASK (0xC0000000u)
#define CSL_TCP2_TCPOUT1_SNR_EXCEED_SHIFT (0x0000001Eu)
#define CSL_TCP2_TCPOUT1_SNR_EXCEED_RESETVAL (0x00000000u)

/*----SNR_EXCEED Tokens----*/
#define CSL_TCP2_TCPOUT1_SNR_EXCEED_MAP01_FAIL (0x00000000u)
#define CSL_TCP2_TCPOUT1_SNR_EXCEED_MAP0_PASS (0x00000001u)
#define CSL_TCP2_TCPOUT1_SNR_EXCEED_MAP1_PASS (0x00000002u)

#define CSL_TCP2_TCPOUT1_CRC_PASS_MASK   (0x20000000u)
#define CSL_TCP2_TCPOUT1_CRC_PASS_SHIFT  (0x0000001Du)
#define CSL_TCP2_TCPOUT1_CRC_PASS_RESETVAL (0x00000000u)

/*----CRC_PASS Tokens----*/
#define CSL_TCP2_TCPOUT1_CRC_PASS_NO     (0x00000000u)
#define CSL_TCP2_TCPOUT1_CRC_PASS_YES    (0x00000001u)

#define CSL_TCP2_TCPOUT1_ACTIVE_MAP_MASK (0x10000000u)
#define CSL_TCP2_TCPOUT1_ACTIVE_MAP_SHIFT (0x0000001Cu)
#define CSL_TCP2_TCPOUT1_ACTIVE_MAP_RESETVAL (0x00000000u)

/*----ACTIVE_MAP Tokens----*/
#define CSL_TCP2_TCPOUT1_ACTIVE_MAP_MAP0 (0x00000000u)
#define CSL_TCP2_TCPOUT1_ACTIVE_MAP_MAP1 (0x00000001u)

#define CSL_TCP2_TCPOUT1_SNR_M2_MASK     (0x00FFFFFFu)
#define CSL_TCP2_TCPOUT1_SNR_M2_SHIFT    (0x00000000u)
#define CSL_TCP2_TCPOUT1_SNR_M2_RESETVAL (0x00000000u)

#define CSL_TCP2_TCPOUT1_RESETVAL        (0x00000000u)

/* TCPOUT2 */

#define CSL_TCP2_TCPOUT2_CNT_RE_MAP1_MASK (0xFFFF0000u)
#define CSL_TCP2_TCPOUT2_CNT_RE_MAP1_SHIFT (0x00000010u)
#define CSL_TCP2_TCPOUT2_CNT_RE_MAP1_RESETVAL (0x00000000u)

#define CSL_TCP2_TCPOUT2_CNT_RE_MAP0_MASK (0x0000FFFFu)
#define CSL_TCP2_TCPOUT2_CNT_RE_MAP0_SHIFT (0x00000000u)
#define CSL_TCP2_TCPOUT2_CNT_RE_MAP0_RESETVAL (0x00000000u)

#define CSL_TCP2_TCPOUT2_RESETVAL        (0x00000000u)

#endif
