/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *  ============================================================================
 */
 
/*  ============================================================================
 *  lnk.cmd   v5.00                                                         
 *         
 *    Usage:  lnk6x <obj files...>    -o <out file> -m <map file> lnk.cmd   
 *            cl6x  <src files...> -z -o <out file> -m <map file> lnk.cmd   
 *                                                                          
 *    Description: This file is a sample linker command file that can be    
 *                 used for linking programs built with the C compiler and  
 *                 running the resulting .out file on a C620x/C670x         
 *                 simulator.  Use it as a guideline.  You will want to     
 *                 change the memory layout to match your specific C6xxx    
 *                 target system.  You may want to change the allocation    
 *                 scheme according to the size of your program.            
 *                                                                          
 *    Notes: (1)   You must specivy a directory in which rts6x00.lib is     
 *                 located.  either add a -i"<directory>" line to this      
 *                 file or use the system environment variable C_DIR to     
 *                 specify a search path for the libraries.                 
 *                                                                          
 *           (2)   If the run-time library you are using is not named       
 *                 rts6200[e].lib, rts6400[e].lib, or rts6700[e].lib, be    
 *                 sure to use the correct name here.                       
 *                                                                          
 *  ============================================================================
 */

-c
-stack 0xA000
-heap  0x1000
MEMORY
{
  BOOT_MEM: origin = 0x00800000 length = 0x00000800
  GEM0_BOOT_MEM: origin = 0x10800000 length = 0x00000800
  GEM1_BOOT_MEM: origin = 0x11800000 length = 0x00000800
  GEM2_BOOT_MEM: origin = 0x12800000 length = 0x00000800

/*  TEXT_MEM: origin = 0x00800800 length = 0x0007f800 */
  GEM0_TEXT_MEM: origin = 0x10800800 length = 0x0007f800
  GEM1_TEXT_MEM: origin = 0x11800800 length = 0x0007f800
  GEM2_TEXT_MEM: origin = 0x12800800 length = 0x0001f800

  DATA_MEM: origin = 0x00880000 length = 0x00040000
  GEM0_DATA_MEM: origin = 0x10880000 length = 0x00040000
  GEM1_DATA_MEM: origin = 0x11880000 length = 0x00040000
  GEM2_DATA_MEM: origin = 0x12820000 length = 0x00020000

  L3ROM_MEM: origin = 0x3c000000 length = 0x00010000

  I2C_TB_MEM:  origin = 0xff010000 length = 0x00010000
  EMAC_TB_MEM: origin = 0xff030000 length = 0x00010000
  DDR16_0_MEM: origin = 0x80000000 length = 0x10000000

  AIF_DATA_MEM: origin = 0xa0000000 length = 0x10000000
}
 
SECTIONS
{
  .boot: > BOOT_MEM
  .gem0_boot: > GEM0_BOOT_MEM
  .gem1_boot: > GEM1_BOOT_MEM
  .gem2_boot: > GEM2_BOOT_MEM

  .text: > GEM0_TEXT_MEM
  .gem0_text: > GEM0_TEXT_MEM
  .gem1_text: > GEM1_TEXT_MEM
  .gem2_text: > GEM2_TEXT_MEM

  .data: > DATA_MEM
  .gem0_data: > GEM0_DATA_MEM
  .gem1_data: > GEM1_DATA_MEM
  .gem2_data: > GEM2_DATA_MEM
  .channelBmData    > GEM0_DATA_MEM
  .channelHdData    > GEM0_DATA_MEM
  .channelHdrefData > GEM0_DATA_MEM


  .l3rom: > L3ROM_MEM

  .i2c_tb:  > I2C_TB_MEM
  .emac_tb: > EMAC_TB_MEM
  .ddrData: > DDR16_0_MEM
  .aifData: > AIF_DATA_MEM

  vectors:    >       GEM0_TEXT_MEM
  .fasttext:  >       GEM0_TEXT_MEM
  .cinit:     >       GEM0_TEXT_MEM
  .stack:     >       GEM0_TEXT_MEM
  .bss:       >       GEM0_TEXT_MEM
  .const:     >       GEM0_TEXT_MEM
  .cio        >       GEM0_TEXT_MEM
  .far:       >       GEM0_TEXT_MEM
  .switch:    >       GEM0_TEXT_MEM
  .sysmem:    >       GEM0_TEXT_MEM
  .testMem:   >      GEM0_TEXT_MEM


  .asmBM  	  > GEM0_TEXT_MEM
  .asmRefDec  > GEM0_TEXT_MEM
  Int_Dat	  >	GEM0_TEXT_MEM
  .csl_vect   > GEM0_TEXT_MEM	
  .l2data     > GEM0_TEXT_MEM /* misc. data in L2 */
}

/*****************************************************************************/
/*                       End of Linker command file                          */
/*****************************************************************************/
