/*
 * TI Booting and Flashing Utilities
 *
 * UBL Nor boot functionality for when a UBL image sits at the start of the
 * NOR flash
 *
 * Copyright (C) 2009 Texas Instruments Incorporated - http://www.ti.com/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation version 2.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any
 * kind, whether express or implied; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

/* --------------------------------------------------------------------------
  AUTHOR      : Daniel Allred
 --------------------------------------------------------------------------- */

#ifdef UBL_NOR

// General type include
#include "tistdtypes.h"

// Device specific module
#include "device.h"

// Debug I/O module
//#include "debug.h"

// Misc utility module
#include "util.h"

// Main UBL module
#include "ubl.h"

// NOR driver fucntions
#include "nor.h"

// This module's header file
#include "norboot.h"


/************************************************************
* Explicit External Declarations                            *
************************************************************/

extern __FAR__ Uint32 DDRStart;
extern __FAR__ Uint32 DDRSize;

Uint32 gEntryPoint;


/************************************************************
* Local Macro Declarations                                  *
************************************************************/


/************************************************************
* Local Typedef Declarations                                *
************************************************************/


/************************************************************
* Local Function Declarations                               *
************************************************************/


/************************************************************
* Local Variable Definitions                                *
\***********************************************************/


/************************************************************
* Global Variable Definitions                               *
************************************************************/
Uint32 EMIFStart = DEVICE_NOR_BASE_ADDR;

/************************************************************
* Global Function Definitions                               *
************************************************************/

// Function to find out where the Application is and copy to RAM
Uint32 NORBOOT_copy(void)
{
  NOR_InfoHandle hNorInfo = NULL;
  volatile NORBOOT_HeaderHandle	hNorHeader = 0;
  VUint32 *norPtr = NULL;
  VUint32	*ramPtr = NULL;
  Uint32 count = 0, blkSize, blkAddress;

  // Nor Initialization
  hNorInfo = NOR_open((Uint32)&EMIFStart, 2 /* 16 Bit */ );
  if (hNorInfo == NULL)
    return E_FAIL;
	    
  NOR_getBlockInfo( hNorInfo, hNorInfo->flashBase, &blkSize, &blkAddress );

  // Block 0 has DSP UBL
  hNorHeader = (NORBOOT_HeaderHandle) (blkAddress);

  // Set the Start Address
  norPtr = (Uint32 *)(((Uint8*)hNorHeader));

  ramPtr = (Uint32 *) 0x80000000;

  // Copy data to RAM
  for(count = 0; count < (0x2000/4); count ++)
  {
    ramPtr[count] = norPtr[count];
  }
  gEntryPoint = 0x80000000;

  // Since our entry point is set, just return success
  return E_PASS;

}



/************************************************************
* Local Function Definitions                                *
************************************************************/


/************************************************************
* End file                                                  *
************************************************************/
#endif  // #ifdef UBL_NOR
