/*
 * TI Booting and Flashing Utilities
 *
 * The UBL has the job to load the application code out of the NOR flash and
 * into DDR RAM, and then configure chip and EVM so that the application
 * can run.  Basically it has to do all the stuff that the GEL would do
 * if the application was being loaded from CCS.
 *
 * Copyright (C) 2009 Texas Instruments Incorporated - http://www.ti.com/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation version 2.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any
 * kind, whether express or implied; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

/* --------------------------------------------------------------------------
  AUTHOR      : Daniel Allred
 --------------------------------------------------------------------------- */

// General type include
#include "tistdtypes.h"

// This module's header file
#include "ubl.h"

// DEVICE module (chip-specific init)
#include "device.h"

#include "nandboot.h"
#include "spiboot.h"



/************************************************************
* Explicit External Declarations                            *
************************************************************/


/************************************************************
* Local Macro Declarations                                  *
************************************************************/


/************************************************************
* Local Typedef Declarations                                *
************************************************************/


/************************************************************
* Local Function Declarations                               *
************************************************************/


/************************************************************
* Local Variable Definitions                                *
\***********************************************************/


/************************************************************
* Global Variable Definitions                               *
************************************************************/

/************************************************************
* Global Function Definitions                               *
************************************************************/

void main(void)
{
  DEVICE_BootMode bootMode;

  // Read boot mode 
  bootMode = DEVICE_bootMode();

  // System init
  if (DEVICE_init(bootMode) != E_PASS)
  {
    return;
  }

  switch(bootMode)
  {
#ifdef UBL_SPI
	case DEVICE_BOOTMODE_SPI0_FLASH:
    {
  		SPIBOOT_copy(0);
		break;
	}

	case DEVICE_BOOTMODE_SPI1_FLASH:
    {
  		SPIBOOT_copy(1);
		break;
	}
#endif

#ifdef UBL_NAND
	case DEVICE_BOOTMODE_NAND_EMIFA_8BIT:
    {
  		NANDBOOT_copy();
		break;
	}
#endif

#ifdef UBL_NOR
	case DEVICE_BOOTMODE_NOR_EMIFA:
    {
  		NORBOOT_copy();
		break;
	}
#endif    
  }

  DEVICE_enable_ARM();
}

/***********************************************************
* End file                                                 *
***********************************************************/

/* --------------------------------------------------------------------------
    HISTORY
        v1.00  -  DJA  -  16-Aug-2007
 	        Initial release 
 ----------------------------------------------------------------------------- */



