/*
 * TI Booting and Flashing Utilities
 *
 * Module to boot the from a NAND flash device by finding the application
 * (usually U-boot) and loading it to RAM.
 *
 * Copyright (C) 2009 Texas Instruments Incorporated - http://www.ti.com/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation version 2.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any
 * kind, whether express or implied; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

/* --------------------------------------------------------------------------
  AUTHOR      : Daniel Allred
 --------------------------------------------------------------------------- */

#ifdef UBL_SPI

// General type include
#include "tistdtypes.h"

#include "device.h"

// Main UBL module
#include "ubl.h"

// SPI driver functions
#include "spi.h"
#include "spi_mem.h"

// This module's header file
#include "spiboot.h"

/************************************************************
* Explicit External Declarations                            *
************************************************************/

/************************************************************
* Local Macro Declarations                                  *
************************************************************/


/************************************************************
* Local Typedef Declarations                                *
************************************************************/


/************************************************************
* Local Function Declarations                               *
************************************************************/


/************************************************************
* Local Variable Definitions                                *
************************************************************/


/************************************************************
* Global Variable Definitions                               *
************************************************************/


/************************************************************
* Global Function Definitions                               *
************************************************************/

// Function to find out where the application is and copy to RAM
Uint32 SPIBOOT_copy(Uint32 spiInstanceNum)
{
  SPI_MemInfoHandle hSPIMemInfo;
 
  hSPIMemInfo = SPI_MEM_open(spiInstanceNum);

  if (hSPIMemInfo == NULL)
    return E_FAIL;
 
  // Load ARM UBL into memory 
  SPI_MEM_readBytes(hSPIMemInfo, DEVICE_SPI_BOOT_ARM_UBL_OFFSET, 
				  DEVICE_SPI_BOOT_ARM_UBL_SIZE,
  				(Uint8*) DEVICE_ARM_UBL_LOAD_ADDR);

  // just return success
  return E_PASS;
}

/************************************************************
* Local Function Definitions                                *
************************************************************/


/***********************************************************
* End file                                                 *
***********************************************************/
#endif  // #ifdef UBL_SPI
