//------------------------------------------------------------------------------
// File main.c
//------------------------------------------------------------------------------
// Copyright (c) 2010 Texas Instruments, Inc.
// All rights reserved
//------------------------------------------------------------------------------

#include "app.h"
#include "edma3.h"

extern cregister volatile unsigned int    ICR;    // interrupt clear register
extern cregister volatile unsigned int    IER;    // interrupt enable register

//-----------------------------------------------------------------------------
// Application Main Function
//-----------------------------------------------------------------------------

int main()
{
    // initialize EVM, EDMA
    EVMC6747_init();
    edmaInit();

    // initialize static semaphores
    SEM_new(&xmt_ping_sem, 0);
    SEM_new(&xmt_pong_sem, 0);
    SEM_new(&rcv_ping_sem, 0);
    SEM_new(&rcv_pong_sem, 0);

    // enable interrupts
    ICR  = (1 << 8);         // clear INT8 (precaution)
    IER |= (1 << 8);         // enable INT8 as CPU interrupt
    IER |= (1 << 11);        // enable RTDX interrupts
    IER |= (1 << 12);        // enable RTDX interrupts

    // exit to static TSK
    LOG_printf(&trace, "[main]: exiting main...");
    return 0;
}

//------------------------------------------------------------------------------
// End of File main.c
//------------------------------------------------------------------------------

