//------------------------------------------------------------------------------
// File edma3.h
//------------------------------------------------------------------------------
// Copyright (c) 2010 Texas Instruments, Inc.
// All rights reserved
//------------------------------------------------------------------------------

#ifndef _EDMA3_H_
#define _EDMA3_H_

#include "tistdtypes.h"
#include "soc_C6747.h"
#include "cslr_edma3cc.h"

#define EDMA_MCASPTXCH       3   // EDMA channel for McASP1 TX
#define EDMA_MCASPRXCH       2   // EDMA channel for McASP1 RX

#define EDMA_XMTPING         32
#define EDMA_XMTPONG         33
#define EDMA_RCVPING         34
#define EDMA_RCVPONG         35

#define EDMA_RCV_PING_TCC    1
#define EDMA_RCV_PONG_TCC    2
#define EDMA_XMT_PING_TCC    3
#define EDMA_XMT_PONG_TCC    4

void edmaInit();
void setup_edma_pingpong_xmt(void *src_ping, void *src_pong, void *dst,
                             Uint32 acnt, Uint32 bcnt);
void setup_edma_pingpong_rcv(void *src, void *dst_ping, void *dst_pong,
                             Uint32 acnt, Uint32 bcnt);
void edmaWritePaRAM(Int ParamNum, CSL_Edma3ccParamSetRegs *ptrParamInfo);
void edmaSetEvent(Int channelNumber);
void EdmaIntClear(Int channelNumber);
void EdmaIntEnable(Int intNumber);
void EdmaIntDisable(Int intNumber);
void EdmaEnableChannel(Int channelNumber, Int QueueNumber);
void EdmaDisableChannel(Int channelNumber);

#endif  // #ifndef _EDMA3_H_

//------------------------------------------------------------------------------
// End of File edma3.h
//------------------------------------------------------------------------------
