/***************************************************************************
 *
 *
 *         **   **    **  ******  ********  ********  ********  **    **    
 *        **    **   **  **   ** ********  ********  ********  **    **
 *       **     *****   **   **    **     **        **        **    **
 *      **       **    ******     **     ****      **        ********
 *     **       **    **  **     **     **        **        **    **
 *    *******  **    **   **    **     ********  ********  **    **
 *   *******  **    **    **   **     ********  ********  **    **  
 *
 *            L Y R T E C H   S I G N A L   P R O C E S S I N G              
 *
 ***************************************************************************
 *                                                                          
 *  Project     : TI EVM
 *  File        : main.c
 *  Description : general test routines.
 *
 *                    Copyright (c) Lyrtech inc. 2007                        
 *
 ***************************************************************************
 *                                                                                          
 * "$Revision: 1.1 $"
 * "$Date: 2007/09/13 16:02:06 $"
 *
 ***************************************************************************/

/****************************************************************************
 *                                 Includes                                 *
 ****************************************************************************/
#include <stdio.h>
#include <stdlib.h>

#include "EVM.h"
#include "mydebug.h"
#include "aic33digloop.h"


/****************************************************************************
 *                        Global constants & Macros                         *
 ****************************************************************************/
#define TRACEBUFFLEN 3072

 
/****************************************************************************
 *                                  Types                                   *
 ****************************************************************************/


/****************************************************************************
 *                             Public Functions                             *
 ****************************************************************************/

void main(void)
{
    char GlobalBuffer[TRACEBUFFLEN];
    char LocalBuffer[TRACEBUFFLEN];

    // Initialize debug trace buffer for myprintf
    SetMyDebugBuffer(GlobalBuffer,LocalBuffer, TRACEBUFFLEN);

    // Do complete test
    do_AIC33_DigLoopBack();
}
