/***************************************************************************
 *
 *
 *         **   **    **  ******  ********  ********  ********  **    **    
 *        **    **   **  **   ** ********  ********  ********  **    **
 *       **     *****   **   **    **     **        **        **    **
 *      **       **    ******     **     ****      **        ********
 *     **       **    **  **     **     **        **        **    **
 *    *******  **    **   **    **     ********  ********  **    **
 *   *******  **    **    **   **     ********  ********  **    **  
 *
 *            L Y R T E C H   S I G N A L   P R O C E S S I N G              
 *
 ***************************************************************************
 *                                                                          
 *  Project     : EVM
 *  File        : mydebug.c
 *  Description : Utility functions for debug
 *
 *                      Copyright (c) Lyrtech inc. 2007                        
 *
 ***************************************************************************
 *                                                                                          
 * "$Revision: 1.3 $"
 * "$Date: 2007/07/13 19:12:15 $"
 *
 ***************************************************************************/

/****************************************************************************
 *                                 Includes                                 *
 ****************************************************************************/

#define MYDEBUG 1

#include "mydebug.h"

/****************************************************************************
 *                             Local constants                              *
 ****************************************************************************/


/****************************************************************************
 *                             Public Functions                             *
 ****************************************************************************/


/**************************************************************************** 
 *
 * NAME  
 *      ClrMyDebugBuffer
 *
 * PURPOSE:
 *      Clear the debug buffers and initialize all buffer variables to receive
 *      debug string information.
 *
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *      void ClrMyDebugBuffer()
 *
 * RETURN VALUE
 *      NONE.
 *
 * REFERENCE
 *
 ****************************************************************************/
void ClrMyDebugBuffer(void)
{
    _myprintfbuf[0]=0;
    _mylprintfbuf[0]=0;
    _myprintfcurrsize=0;
}

/**************************************************************************** 
 *
 * NAME  
 *      GetMyDebugBuffer
 *
 * PURPOSE:
 *      Return a pointer on the debug buffer content.
 *
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *      char *GetMyDebugBuffer(void)
 *
 * RETURN VALUE
 *      Return a pointer to the debug buffer content.
 *
 * REFERENCE
 *
 ****************************************************************************/
char *GetMyDebugBuffer(void)
{
    return(&_myprintfbuf[0]);
}


/**************************************************************************** 
 *
 * NAME  
 *      SetMyDebugBuffer
 *
 * PURPOSE:
 *      Sets the address of both debug buffers. Both buffers must be same size.
 *      There is a global buffer and a local buffer for intermediate results.
 *
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *      void SetMyDebugBuffer(char *GlobalBuffer,char *LocalBuffer, int BufferSize)
 *
 * RETURN VALUE
 *      NONE.
 *
 * REFERENCE
 *
 ****************************************************************************/
void SetMyDebugBuffer(char *GlobalBuffer,char *LocalBuffer, int BufferSize)
{
    _myprintfbuf=GlobalBuffer;
    _mylprintfbuf=LocalBuffer;
    _myprintfbufsize=BufferSize;
    
    // Clears the buffers
    ClrMyDebugBuffer();
}

/**************************************************************************** 
 *
 * NAME  
 *      GetMyDebugCurrSize
 *
 * PURPOSE:
 *      Returns actual size of data in debug buffer.
 *
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *      int GetMyDebugCurrSize(void)
 *
 * RETURN VALUE
 *      Return size of actual content in debug buffer.
 *
 * REFERENCE
 *
 ****************************************************************************/
int GetMyDebugCurrSize(void)
{
    return(_myprintfcurrsize);
}

