/***************************************************************************
 *
 *
 *         **   **    **  ******  ********  ********  ********  **    **    
 *        **    **   **  **   ** ********  ********  ********  **    **
 *       **     *****   **   **    **     **        **        **    **
 *      **       **    ******     **     ****      **        ********
 *     **       **    **  **     **     **        **        **    **
 *    *******  **    **   **    **     ********  ********  **    **
 *   *******  **    **    **   **     ********  ********  **    **  
 *
 *            L Y R T E C H   S I G N A L   P R O C E S S I N G              
 *
 ***************************************************************************
 *                                                                          
 *  Project     : EVM
 *  File        : MCASP_setup.h
 *  Description : Define the default configuration for the McASPs
 *
 *                   Copyright (c) Lyrtech inc. 2007                        
 *
 ***************************************************************************
 *                                                                                          
 * "$Revision: 1.1 $"
 * "$Date: 2007/09/13 16:04:08 $"
 *
 ***************************************************************************/

#ifndef __MCASP_SETUP_H__
#define __MCASP_SETUP_H__

/****************************************************************************
 *                                 Includes                                 *
 ****************************************************************************/

#include "mcasp.h"

/****************************************************************************
 *                             Glocal constants                             *
 ****************************************************************************/

/*
 *  EVM_MCASP0_HWSETUP_DEFAULTS
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *  This configuration can be used to initialize the McASP 0 to access the 
 *  ADCs and the DACs. All the connected serializers are enabled. The application 
 *  needs to disable unwanted serializers.
 */
#define  MY_MCASP0_HWSETUP_DEFAULTS {                                          \
    /* Value to be loaded in global control register (GLBCTL) */               \
    {                                                                          \
        /* Pin function register (PFUNC) */                                    \
        0x00000000,         /* Everything in MCASP */                          \
                                                                               \
        /* Pin direction register (PDIR) */                                    \
          (0<<31)          /* AFSR  : Input */                                 \
        | (0<<30)          /* AHCLKR: Input */                                 \
        | (0<<29)          /* ACLKR : Input */                                 \
        | (0<<28)          /* AFSX  : Input */                                 \
        | (0<<27)          /* AHCLKX: Input */                                 \
        | (0<<26)          /* ACLKX : Input */                                 \
        | (0<<25)          /* AMUTE : Input */                                 \
        | (0<< 9)          /* AXR9  : Input (not used for MCASP) */            \
        | (0<< 8)          /* AXR8  : Input (not used for MCASP) */            \
        | (1<< 7)          /* AXR7  : Output (DAC ch7 & 8) */                  \
        | (1<< 6)          /* AXR6  : Output (DAC ch3 & 4) */                  \
        | (0<< 5)          /* AXR5  : Input  (ADC ch7 & 8) */                  \
        | (0<< 4)          /* AXR4  : Input  (ADC ch3 & 4) */                  \
        | (1<< 3)          /* AXR3  : Output (DAC ch5 & 6) */                  \
        | (1<< 2)          /* AXR2  : Output (DAC ch1 & 2) */                  \
        | (0<< 1)          /* AXR1  : Input  (ADC ch5 & 6) */                  \
        | (0<< 0),         /* AXR0  : Input  (ADC ch1 & 2) */                  \
                                                                               \
        /* Global control register (GBLCTL) */                                 \
        0x00000000,         /* Everything in reset */                          \
                                                                               \
        /* Decides whether McASP operates in DIT mode (DITCTL) */              \
        0x00000000,         /* DIT mode disable */                             \
                                                                               \
        /* Digital loopback mode setup (DLBEN) (DLBCTL) */                     \
        0x00000000,         /* Loopback mode disable */                        \
                                                                               \
        /* Mute control register (AMUTE) */                                    \
        0x00000000,         /* AMUTE pin is disabled */                        \
                                                                               \
        /* Setup serializer control register (SRCTL0-9) */                     \
        0x00000002,         /* Serializer  0 is in rx (ADC ch1 & 2) */         \
        0x00000002,         /* Serializer  1 is in rx (ADC ch5 & 6) */         \
        0x00000001,         /* Serializer  2 is in tx (DAC ch1 & 2) */         \
        0x00000001,         /* Serializer  3 is in tx (DAC ch5 & 6) */         \
        0x00000002,         /* Serializer  4 is in rx (ADC ch3 & 4) */         \
        0x00000002,         /* Serializer  5 is in rx (ADC ch7 & 8) */         \
        0x00000001,         /* Serializer  6 is in tx (DAC ch3 & 4) */         \
        0x00000001,         /* Serializer  7 is in tx (DAC ch7 & 8) */         \
        0x00000000,         /* Serializer  8 is unused */                      \
        0x00000000          /* Serializer  9 is unused */                      \
    },                                                                         \
                                                                               \
    /* Receiver settings */                                                    \
    {                                                                          \
        /* To mask or not to mask (RMASK) */                                   \
        0x0000FFFF,         /* 16 bits mask */                                 \
                                                                               \
        /* Format details as per (RFMT) */                                     \
          ( 1<<16)         /* RDATDLY: Transmit with 1 bit delay */            \
        | ( 1<<15)         /* RRVRS  : MSB first */                            \
        | ( 0<<13)         /* RPAD  : pad with 0 */                            \
        | ( 1<< 3)         /* RBUSEL : Reads form peripheral bus */            \
        | ( 7<< 4)         /* RSSZ   : 16-bit slot size */                     \
        | ( 0<< 0),        /* RROT   : 0 bits rotation (SLOT-WORD) */          \
                                                                               \
        /* Configure the rcv frame sync (AFSRCTL) */                           \
          (2<< 7)          /* RMOD : 2-slot TDM I2S mode */                    \
        | (1<< 4)          /* FRWID: Single word frame sync */                 \
        | (0<< 1)          /* FSRM : Externally-generated rx frame sync */     \
        | (1<< 0),         /* FSRP : Start on falling edge */                  \
                                                                               \
        /* Specifies which TDM slots are active (RTDM) */                      \
        0x00000003,         /* Enable first 2 slots for I2S */                 \
                                                                               \
        /* Controls generation of McASP interrupts (RINTCTL) */                \
        0x00000000,         /* No interrupts */                                \
                                                                               \
        /* Status register (controls writable fields of STAT reg) (RSTAT) */   \
        0x00000000,                                                            \
                                                                               \
        /* Event control register (REVTCTL) */                                 \
        0x00000000,                                                            \
                                                                               \
        /* Clock settings for rcv */                                           \
        {                                                                      \
            /* Clock details (ACLKRCTL) */                                     \
              (1<< 7)          /* CLKXP  : RX on rising edge */                \
            | (0<< 6)          /* Reserved */                                  \
            | (0<< 5)          /* CLKRM  : Ext clk source from codec */        \
            | (0<< 0),         /* CLKRDIV: Div by 1 */                         \
                                                                               \
            /* High clock details (AHCLKRCTL) */                               \
              (0<<15)          /* HCLKRM  : Clock from AHCLKR pin */           \
            | (0<<14)          /* HCLKRP  : Rising edge */                     \
            | (0<< 0),         /* HCLKRDIV: AHCLKR = AUXCLK / 1 */             \
                                                                               \
            /* Config receive/transmit clock failure detection (RCLKCHK) */    \
            0x00FF0000          /* Not used */                                 \
        }                                                                      \
    },                                                                         \
                                                                               \
    /* Transmitter settings */                                                 \
    {                                                                          \
        /* To mask or not to mask (XMASK) */                                   \
        0xFFFFFFFF,         /* no mask */                                      \
                                                                               \
        /* Format details as per (XFMT) */                                     \
          ( 1<<16)         /* XDATDLY: Transmit with 1 bit delay */            \
        | ( 1<<15)         /* XRVRS  : MSB first */                            \
        | ( 1<< 3)         /* XBUSSEL: Writes from peripheral bus */           \
        | ( 7<< 4)         /* XSSZ   : 16-bit slot size */                     \
        | ( 4<< 0),        /* XROT   : 16 bits rotation (WORD)*/               \
                                                                               \
        /* Configure the xmt frame sync (AFSXCTL) */                           \
          (2<< 7)          /* XMOD : 2-slot TDM I2S mode */                    \
        | (1<< 4)          /* FXWID: Single word frame sync */                 \
        | (0<< 1)          /* FSXM : Externally-generated tx frame sync */     \
        | (1<< 0),         /* FSXP : Start on falling edge */                  \
                                                                               \
        /* Specifies which TDM slots are active (XTDM) */                      \
        0x00000003,         /* Enable first 2 slots for I2S */                 \
                                                                               \
        /* Controls generation of McASP interrupts (XINTCTL) */                \
        0x00000000,         /* No interrupts */                                \
                                                                               \
        /* Status register (controls writable fields of STAT reg) (XSTAT) */   \
        0x00000000,                                                            \
                                                                               \
        /* Event control register (XEVTCTL) */                                 \
        0x00000000,                                                            \
                                                                               \
        /* Clock settings for xmt */                                           \
        {                                                                      \
            /* Clock details (ACLKXCTL) */                                     \
              (1<< 7)          /* CLKXP  : TX on falling edge */               \
            | (0<< 6)          /* Reserved */                                  \
            | (0<< 5)          /* CLKXM  : Ext clk source from codec */        \
            | (0<< 0),         /* CLKXDIV: Div by 1*/                          \
                                                                               \
            /* High clock details (AHCLKXCTL) */                               \
              (0<<15)          /* HCLKXM  : Clock from AHCLKX pin */           \
            | (0<<14)          /* HCLKXP  : Rising edge */                     \
            | (0<< 0),         /* HCLKXDIV: AHCLKX = AUXCLK / 1 */             \
                                                                               \
            /* Conf receive/transmit clock failure detection (XCLKCHK) */      \
            0x00FF0000          /* Not used */                                 \
        }                                                                      \
    },                                                                         \
                                                                               \
    /* Power down emulation mode params - PWRDEMU */                           \
    MCASP_PWRDEMU_FREE_ON                                                      \
}


#endif    // __MCASP_SETUP_H__
