/***************************************************************************
 *
 *
 *         **   **    **  ******  ********  ********  ********  **    **    
 *        **    **   **  **   ** ********  ********  ********  **    **
 *       **     *****   **   **    **     **        **        **    **
 *      **       **    ******     **     ****      **        ********
 *     **       **    **  **     **     **        **        **    **
 *    *******  **    **   **    **     ********  ********  **    **
 *   *******  **    **    **   **     ********  ********  **    **  
 *
 *            L Y R T E C H   S I G N A L   P R O C E S S I N G              
 *
 ***************************************************************************
 *                                                                          
 *  Project     : EVM
 *  File        : muxcontrol.h
 *  Description	: Utility functions for mux control
 *
 *                        Copyright (c) Lyrtech inc. 2007                        
 *
 ***************************************************************************
 *                                                                                          
 * "$Revision: 1.1 $"
 * "$Date: 2007/07/19 19:49:32 $"
 *
 ***************************************************************************/

#ifndef __MUXCONTROL_H__
#define __MUXCONTROL_H__

/****************************************************************************
 *                                 Includes                                 *
 ****************************************************************************/
#include <tistdtypes.h>

/****************************************************************************
 *                             Public Functions                             *
 ****************************************************************************/

/**************************************************************************** 
 *
 * NAME  
 *      do_Muxcontrol
 *
 * PURPOSE:
 *      Do a mux control test.
 *      This function shows how to lock evm resource that can be used later.
 *      This process IS NOT NEEDED when the related BSL module is used to
 *      control the needed resource: the BSL will lock all needed reources by
 *      itself. But it can be used for example when the BSL module associated
 *      with the needed peripheral is not used, but controled through another
 *      custom routine, driver, OS or BIOS functions. In this case, the
 *      resource can be locked by the BSL EVM_lockresource function: this will
 *      avoid resource conflicts, will take care of evm muxes and dsp pinmux
 *      initializations.
 *
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *      Int32 do_Muxcontrol(void)
 *
 * RETURN VALUE
 *      0 if OK, !=0 in case of problem
 *
 * REFERENCE
 *
 ****************************************************************************/
Int32 do_Muxcontrol(void);


#endif // __MUXCONTROL_H__
