/***************************************************************************
 *
 *
 *         **   **    **  ******  ********  ********  ********  **    **    
 *        **    **   **  **   ** ********  ********  ********  **    **
 *       **     *****   **   **    **     **        **        **    **
 *      **       **    ******     **     ****      **        ********
 *     **       **    **  **     **     **        **        **    **
 *    *******  **    **   **    **     ********  ********  **    **
 *   *******  **    **    **   **     ********  ********  **    **  
 *
 *            L Y R T E C H   S I G N A L   P R O C E S S I N G              
 *
 ***************************************************************************
 *                                                                          
 *  Project     : EVM
 *  File        : mydebug.h
 *  Description : Utility functions for debug
 *
 *                      Copyright (c) Lyrtech inc. 2007                        
 *
 ***************************************************************************
 *                                                                                          
 * "$Revision: 1.3 $"
 * "$Date: 2007/07/13 19:12:16 $"
 *
 ***************************************************************************/

#ifndef __MYDEBUG_H__
#define __MYDEBUG_H__


/****************************************************************************
 *                                 Includes                                 *
 ****************************************************************************/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>


/****************************************************************************
 *                             Local variables                              *
 ****************************************************************************/

#ifdef MYDEBUG
char *_myprintfbuf;
char *_mylprintfbuf;
int  _myprintfbufsize;
int  _myprintfcurrsize;
int  _myprintftempsize;
#else
extern char *_myprintfbuf;
extern char *_mylprintfbuf;
extern int  _myprintfbufsize;
extern int  _myprintfcurrsize;
extern int  _myprintftempsize;
#endif

/****************************************************************************
 *                             Local constants                              *
 ****************************************************************************/

 // myprintf macro is used to print string in trace buffer...
#define myprintf(format,par1,par2) \
sprintf((char *)_mylprintfbuf,format,par1,par2); \
_myprintftempsize = strlen((char *)_mylprintfbuf) + _myprintfcurrsize; \
if (_myprintftempsize < _myprintfbufsize)    \
{ \
    strcat((char *)_myprintfbuf,(char *)_mylprintfbuf); \
    _myprintfcurrsize = _myprintftempsize; \
} \
printf("%s",_mylprintfbuf);

// Dialog for both text console version and window version
#define ConfirmDialog(text,par1,par2) \
    myprintf(text,par1,par2); \
    getch();

#define YesNoDialog(text,par1,par2,result) \
    myprintf(text,par1,par2); \
    result=getche();

/****************************************************************************
 *                             Public Functions                             *
 ****************************************************************************/


/**************************************************************************** 
 *
 * NAME  
 *      ClrMyDebugBuffer
 *
 * PURPOSE:
 *      Clear the debug buffers and initialize all buffer variables to receive
 *      debug string information.
 *
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *      void ClrMyDebugBuffer()
 *
 * RETURN VALUE
 *      NONE.
 *
 * REFERENCE
 *
 ****************************************************************************/
void ClrMyDebugBuffer(void);


/**************************************************************************** 
 *
 * NAME  
 *      GetMyDebugBuffer
 *
 * PURPOSE:
 *      Return a pointer on the debug buffer content.
 *
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *      char *GetMyDebugBuffer(void)
 *
 * RETURN VALUE
 *      Return a pointer to the debug buffer content.
 *
 * REFERENCE
 *
 ****************************************************************************/
char *GetMyDebugBuffer(void);


/**************************************************************************** 
 *
 * NAME  
 *      SetMyDebugBuffer
 *
 * PURPOSE:
 *      Sets the address of both debug buffers. Both buffers must be same size.
 *      There is a global buffer and a local buffer for intermediate results.
 *
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *      void SetMyDebugBuffer(char *GlobalBuffer,char *LocalBuffer, int BufferSize)
 *
 * RETURN VALUE
 *      NONE.
 *
 * REFERENCE
 *
 ****************************************************************************/
void SetMyDebugBuffer(char *GlobalBuffer,char *LocalBuffer, int BufferSize);


/**************************************************************************** 
 *
 * NAME  
 *      GetMyDebugCurrSize
 *
 * PURPOSE:
 *      Returns actual size of data in debug buffer.
 *
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *      int GetMyDebugCurrSize(void)
 *
 * RETURN VALUE
 *      Return size of actual content in debug buffer.
 *
 * REFERENCE
 *
 ****************************************************************************/
int GetMyDebugCurrSize(void);

#endif //__MYDEBUG_H__
