/***************************************************************************
 *
 *
 *         **   **    **  ******  ********  ********  ********  **    **    
 *        **    **   **  **   ** ********  ********  ********  **    **
 *       **     *****   **   **    **     **        **        **    **
 *      **       **    ******     **     ****      **        ********
 *     **       **    **  **     **     **        **        **    **
 *    *******  **    **   **    **     ********  ********  **    **
 *   *******  **    **    **   **     ********  ********  **    **  
 *
 *            L Y R T E C H   S I G N A L   P R O C E S S I N G              
 *
 ***************************************************************************
 *                                                                          
 *  Project     : EVM
 *  File        : sdvideodigloop.h
 *  Description : Utility functions for SD video
 *
 *                      Copyright (c) Lyrtech inc. 2007                        
 *
 ***************************************************************************
 *                                                                                          
 * "$Revision: 1.3 $"
 * "$Date: 2007/07/13 19:12:16 $"
 *
 ***************************************************************************/

#ifndef __SDVIDEODIGLOOP_H__
#define __SDVIDEODIGLOOP_H__

/****************************************************************************
 *                                 Includes                                 *
 ****************************************************************************/


/****************************************************************************
 *                             Public Functions                             *
 ****************************************************************************/

/**************************************************************************** 
 *
 * NAME  
 *      do_SDvideo_DigLoopBack
 *
 * PURPOSE:
 *      Digital loopback between SD Chx video IN and HD + J13 video OUT.
 *      This example can easily output on J13 in S-video or composite
 *      mode just by defining J13_SVIDEO at top of this file...
 *      This routine required trace buffer being initialized for myprintf.
 *
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *      Int32 do_SDvideo_DigLoopBack(Uint32 ichan)
 *
 *      ichan  - (i) id of desired video channel [0-7]
 *
 * RETURN VALUE
 *      0 if OK, !=0 in case of problem
 *
 * REFERENCE
 *
 ****************************************************************************/
Int32 do_SDvideo_DigLoopBack(Uint32 ichan);


#endif // __SDVIDEODIGLOOP_H__
