/***************************************************************************
 *
 *
 *         **   **    **  ******  ********  ********  ********  **    **    
 *        **    **   **  **   ** ********  ********  ********  **    **
 *       **     *****   **   **    **     **        **        **    **
 *      **       **    ******     **     ****      **        ********
 *     **       **    **  **     **     **        **        **    **
 *    *******  **    **   **    **     ********  ********  **    **
 *   *******  **    **    **   **     ********  ********  **    **  
 *
 *            L Y R T E C H   S I G N A L   P R O C E S S I N G              
 *
 ***************************************************************************
 *                                                                          
 *  Project     : EVM
 *  File        : main.c
 *  Description : general test routines.
 *
 *                      Copyright (c) Lyrtech inc. 2007                        
 *
 ***************************************************************************
 *                                                                                          
 * "$Revision: 1.3 $"
 * "$Date: 2007/07/13 19:12:16 $"
 *
 ***************************************************************************/

/****************************************************************************
 *                                 Includes                                 *
 ****************************************************************************/
#include <stdio.h>
#include <stdlib.h>

#include "mydebug.h"
#include "muxcontrol.h"


/****************************************************************************
 *                        Global constants & Macros                         *
 ****************************************************************************/
#define TRACEBUFFLEN 3072

 
/****************************************************************************
 *                                  Types                                   *
 ****************************************************************************/


/****************************************************************************
 *                             Public Functions                             *
 ****************************************************************************/

main()
{
    char GlobalBuffer[TRACEBUFFLEN];
    char LocalBuffer[TRACEBUFFLEN];

    // Set debug buffers for myprintf
    SetMyDebugBuffer(GlobalBuffer,LocalBuffer, TRACEBUFFLEN);

    // Do mux control test
    do_Muxcontrol();
}

