/***************************************************************************
 *
 *
 *         **   **    **  ******  ********  ********  ********  **    **    
 *        **    **   **  **   ** ********  ********  ********  **    **
 *       **     *****   **   **    **     **        **        **    **
 *      **       **    ******     **     ****      **        ********
 *     **       **    **  **     **     **        **        **    **
 *    *******  **    **   **    **     ********  ********  **    **
 *   *******  **    **    **   **     ********  ********  **    **  
 *
 *            L Y R T E C H   S I G N A L   P R O C E S S I N G              
 *
 ***************************************************************************
 *                                                                          
 *  Project     : EVM
 *  File        : main.c
 *  Description : general test routines.
 *
 *                      Copyright (c) Lyrtech inc. 2007                        
 *
 ***************************************************************************
 *                                                                                          
 * "$Revision: 1.4 $"
 * "$Date: 2007/07/13 20:09:00 $"
 *
 ***************************************************************************/

/****************************************************************************
 *                                 Includes                                 *
 ****************************************************************************/
#include <stdio.h>
#include <stdlib.h>

#include "EVM_I2C.h"
#include "mydebug.h"
#include "sdcolortest.h"


/****************************************************************************
 *                        Global constants & Macros                         *
 ****************************************************************************/
#define TRACEBUFFLEN 3072

 
/****************************************************************************
 *                             Public Functions                             *
 ****************************************************************************/

void main(void)
{
    char GlobalBuffer[TRACEBUFFLEN];
    char LocalBuffer[TRACEBUFFLEN];

    // Initialize debug trace buffer for myprintf
    SetMyDebugBuffer(GlobalBuffer,LocalBuffer, TRACEBUFFLEN);

    // Do complete test
    do_SDvideo_ColorBar();
}

