/***************************************************************************
 *
 *
 *         **   **    **  ******  ********  ********  ********  **    **    
 *        **    **   **  **   ** ********  ********  ********  **    **
 *       **     *****   **   **    **     **        **        **    **
 *      **       **    ******     **     ****      **        ********
 *     **       **    **  **     **     **        **        **    **
 *    *******  **    **   **    **     ********  ********  **    **
 *   *******  **    **    **   **     ********  ********  **    **  
 *
 *            L Y R T E C H   S I G N A L   P R O C E S S I N G              
 *
 ***************************************************************************
 *                                                                          
 *  Project     : EVM
 *  File        : main.c
 *  Description : general test routines.
 *
 *                      Copyright (c) Lyrtech inc. 2007                        
 *
 ***************************************************************************
 *                                                                                          
 * "$Revision: 1.4 $"
 * "$Date: 2007/07/20 15:21:36 $"
 *
 ***************************************************************************/

/****************************************************************************
 *                                 Includes                                 *
 ****************************************************************************/
#include <stdio.h>
#include <stdlib.h>

#include "EVM_I2C.h"
#include "EVM_p5154.h"
#include "mydebug.h"
#include "sdvideodigloop.h"


/****************************************************************************
 *                        Global constants & Macros                         *
 ****************************************************************************/
#define TRACEBUFFLEN 3072

 
/****************************************************************************
 *                             Public Functions                             *
 ****************************************************************************/

void main(void)
{
    char GlobalBuffer[TRACEBUFFLEN];
    char LocalBuffer[TRACEBUFFLEN];
    Uint32 itchan;

    // Initialize debug trace buffer for myprintf
    SetMyDebugBuffer(GlobalBuffer,LocalBuffer, TRACEBUFFLEN);

    // Set video channel to use
    itchan=EVM_P5154_CH1;
    
    // Do digital sd video loopback on selected video channel
    do_SDvideo_DigLoopBack(itchan);
}

