/***************************************************************************
 *
 *
 *         **   **    **  ******  ********  ********  ********  **    **    
 *        **    **   **  **   ** ********  ********  ********  **    **
 *       **     *****   **   **    **     **        **        **    **
 *      **       **    ******     **     ****      **        ********
 *     **       **    **  **     **     **        **        **    **
 *    *******  **    **   **    **     ********  ********  **    **
 *   *******  **    **    **   **     ********  ********  **    **  
 *
 *            L Y R T E C H   S I G N A L   P R O C E S S I N G              
 *
 ***************************************************************************
 *                                                                          
 *  Project     : EVM
 *  File        : EVM_A7105.h
 *  Description : Utility functions for A7105 video DAC
 *
 *                      Copyright (c) Lyrtech inc. 2007                        
 *
 ***************************************************************************
 *                                                                                          
 * "$Revision: 1.3 $"
 * "$Date: 2007/07/13 19:12:16 $"
 *
 ***************************************************************************/

#ifndef __EVM_A7105_H__ 
#define __EVM_A7105_H__

/****************************************************************************
 *                                 Includes                                 *
 ****************************************************************************/
#include <tistdtypes.h>


/****************************************************************************
 *                             Global constants                             *
 ****************************************************************************/
// A7105 functions error status codes 
// ---------------------------------------------------------------------------
#define EVM_A7105_OK                0
#define EVM_A7105_NHANDLE           0x5001  // Cannot get a handle for the device
#define EVM_A7105_DEVICEINUSE       0x5002  // Device is already in use
#define EVM_A7105_INVALIDID         0x5003  // Invalid video channel ID
#define EVM_A7105_INVALIDHANDLE     0x5004  // Invalid handle given
#define EVM_A7105_I2CREADREG        0x5005  // Problem reading device I2C register
#define EVM_A7105_I2CWRITEREG       0x5006  // Problem writing device I2C register
#define EVM_A7105_ERRPWRDNDEVICE    0x5007  // Problem cannot power down device
#define EVM_A7105_ERRREADFIFOCTRL   0x5008  // Problem cannot read fifo control register
#define EVM_A7105_ERRWRITEFIFOCTRL  0x5009  // Problem cannot write fifo control register
#define EVM_A7105_ERRREADSTDCTRLREG 0x500A  // Problem cannot read std control register
#define EVM_A7105_ERRPWRUPDEVICE    0x500B  // Problem cannot power up device
// ---------------------------------------------------------------------------

// Video channel definitions used as ID to get handle
#define EVM_A7105_CH1 0


// Number of Registers to setup for each part in a EVM_A7105_Setup
#define EVM_A7105_SLAVEMODEP1N  2
#define EVM_A7105_SLAVEMODEP2N  1
#define EVM_A7105_DEFAULTSETP1N 13
#define EVM_A7105_DEFAULTSETP2N 14
#define EVM_A7105_CURSORTABLEN  257
#define EVM_A7105_COLORBARN     1
#define EVM_A7105_VIDEODISPLP1N 0xA3
#define EVM_A7105_VIDEODISPLP2N 1
#define EVM_A7105_VIDEODISPLP3N 1
#define EVM_A7105_SYNC_NREGS    6


// Index definitions for setup matrix
#define EVM_A7105_REG_IND  0
#define EVM_A7105_REG_VAL  1


// A7105 default setups default registers structures (EVM_A7105_Setup)
// There are 6 sections (parts) in the setup with fix size.

// A7105 SDTV 480i setup (needs a CLKIN of 27MHz = 2 X Pclk) ~BT656 input format
// Setup : 704x480x60Hz - 15.734khz - 13.5MHz interlaced (525i) (NTSC)
// Output is Svideo, Sync with BT656 embedded sync code
// Register format for each group: {regoff, value1, ..., valuen}
// N.B. When more than one value is given for a specified register offset (regoff),
// this means that the following values autoincrement reg offset or ram offset
#define EVM_A7105_SDTV480I_YCBCR704X480X60_SVIDEO {                                                                                         \
    /* Slave mode */                                                                                                                        \
    {0x96,0x20,0x00},                                                                                                                       \
    {0x84,0x75},                                                                                                                            \
    /* Default setup */                                                                                                                     \
    {0xd0,0x00,0x00,0x00,0x00,0x02,0x00,0x10,0x00,0x00,0x01,0x0c,0x00,0x0d},                                                                \
    {0xf0,0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd3},                                                           \
    /* Cursor table */                                                                                                                      \
    {0xfe,0x00,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa},                                                           \
    /* Color bar config */                                                                                                                  \
    {0x3a,0x0d},                                                                                                                            \
    /* Video Display settings */                                                                                                            \
    {0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1b,0x1b,0x1f,0x70,\
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x3f,0x19,0x1d,0xff,0xff,0x0f,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
     0x00,0x00,0x1a,0x1a,0x19,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
     0x00,0x00,0x00,0x02,0xff,0xbf,0xfe,0xff,0xff,0x33,0x7b,0xae,0x3a,0x2e,0x2e,0x00,0x01,0x3f,0x1f,0x7c,0xf0,0x21,0xff,0xff,0xff,0xff,0x00,\
     0x02,0x04,0x80,0x11,0x10,0xb0,0x61,0x54,0x02,0x00,0x06,0x10,0x05,0x10,0x0d,0x02,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x75,0x08,0x00,\
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd0,0x0e,0x0e,0x08,0xf5,0x20,0x00,0xb3,0x36,0x00,0x00,0x08,0x64,0x64,0x00,0x00,0x00,\
     0x0a,0x80},                                                                                                                            \
    {0xfd,0xd3},                                                                                                                            \
    {0x2d,0xb0},                                                                                                                            \
    /* Syncmode settings */                                                                                                                 \
    {{0x3a,0x19},                                                                                                                           \
    {0x99,0x36},                                                                                                                            \
    {0x90,0x00},                                                                                                                            \
    {0x94,0x08},                                                                                                                            \
    {0x6c,0x02},                                                                                                                            \
    {0x6d,0x04}}                                                                                                                            \
}


// A7105 SDTV 576i setup (needs a CLKIN of 27MHz = 2 X Pclk) ~BT656 input format
// Setup : 704x576x50Hz - 15.625khz - 13.5MHz interlaced (625i) (PAL)
// Output is Svideo, Sync with BT656 embedded sync code
// Register format for each group: {regoff, value1, ..., valuen}
#define EVM_A7105_SDTV576I_YCBCR704X576X50_SVIDEO {                                                                                         \
    /* Slave mode */                                                                                                                        \
    {0x96,0x20,0x00},                                                                                                                       \
    {0x84,0x75},                                                                                                                            \
    /* Default setup */                                                                                                                     \
    {0xd0,0x00,0x00,0x00,0x00,0x02,0x00,0x10,0x00,0x00,0x01,0x0c,0x00,0x0d},                                                                \
    {0xf0,0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd3},                                                           \
    /* Cursor table */                                                                                                                      \
    {0xfe,0x00,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa},                                                           \
    /* Color bar config */                                                                                                                  \
    {0x3a,0x0d},                                                                                                                            \
    /* Video Display settings */                                                                                                            \
    {0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1b,0x1b,0x1f,0x70,\
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x3f,0x21,0x1d,0xff,0xff,0x0f,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
     0x00,0x00,0x1a,0x1a,0x19,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
     0x00,0x00,0x00,0x02,0xff,0xbf,0xfe,0xff,0xff,0x6b,0x7b,0xae,0x3a,0x2e,0x2e,0x00,0x02,0x2d,0xcb,0x8a,0x09,0x2a,0xff,0xff,0xff,0xff,0x00,\
     0x02,0x00,0x00,0x11,0x18,0xb8,0x61,0x54,0x02,0x00,0x06,0x10,0x05,0x10,0x15,0x37,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x75,0x08,0x00,\
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd0,0x13,0x13,0x08,0x22,0x21,0x00,0xbf,0x36,0x00,0x00,0x08,0x64,0x64,0x00,0x00,0x00,\
     0x0a,0x80},                                                                                                                            \
    {0xfd,0xd3},                                                                                                                            \
    {0x2d,0xb0},                                                                                                                            \
    /* Syncmode settings */                                                                                                                 \
    {{0x3a,0x19},                                                                                                                           \
    {0x99,0x36},                                                                                                                            \
    {0x90,0x00},                                                                                                                            \
    {0x94,0x08},                                                                                                                            \
    {0x6c,0x02},                                                                                                                            \
    {0x6d,0x00}}                                                                                                                            \
}


// A7105 SDTV 480i setup (needs a CLKIN of 27MHz = 2 X Pclk) ~BT656 input format
// Setup : 704x480x60Hz - 15.734khz - 13.5MHz interlaced (525i) (NTSC)
// Output is Composite video, Sync with BT656 embedded sync code
// Register format for each group: {regoff, value1, ..., valuen}
#define EVM_A7105_SDTV480I_YCBCR704X480X60_COMP {                                                                                           \
    /* Slave mode */                                                                                                                        \
    {0x96,0x20,0x00},                                                                                                                       \
    {0x84,0x75},                                                                                                                            \
    /* Default setup */                                                                                                                     \
    {0xd0,0x00,0x00,0x00,0x00,0x02,0x00,0x10,0x00,0x00,0x01,0x0c,0x00,0x0d},                                                                \
    {0xf0,0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd3},                                                           \
    /* Cursor table */                                                                                                                      \
    {0xfe,0x00,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa},                                                           \
    /* Color bar config */                                                                                                                  \
    {0x3a,0x0d},                                                                                                                            \
    /* Video Display settings */                                                                                                            \
    {0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1b,0x1b,0x1f,0x70,\
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x3f,0x19,0x1d,0xff,0xff,0x0f,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
     0x00,0x00,0x1a,0x1a,0x19,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
     0x00,0x00,0x00,0x02,0xff,0xbf,0xfe,0xff,0xff,0x33,0x7b,0xae,0x3a,0x2e,0x2e,0x00,0x01,0x3f,0x1f,0x7c,0xf0,0x21,0xff,0xff,0xff,0xff,0x00,\
     0x02,0x04,0x80,0x11,0x10,0xb0,0x61,0x54,0x02,0x00,0x06,0x10,0x05,0x10,0x0d,0x02,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x75,0x08,0x00,\
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd0,0x0e,0x0e,0x08,0xf5,0x20,0x00,0xb3,0x36,0x00,0x00,0x08,0x64,0x64,0x00,0x00,0x00,\
     0x0a,0x80},                                                                                                                            \
    {0xfd,0xd3},                                                                                                                            \
    {0x2d,0x62},                                                                                                                            \
    /* Syncmode settings */                                                                                                                 \
    {{0x3a,0x19},                                                                                                                           \
    {0x99,0x36},                                                                                                                            \
    {0x90,0x00},                                                                                                                            \
    {0x94,0x08},                                                                                                                            \
    {0x6c,0x02},                                                                                                                            \
    {0x6d,0x04}}                                                                                                                            \
}


// A7105 SDTV 576i setup (needs a CLKIN of 27MHz = 2 X Pclk) ~BT656 input format
// Setup : 704x576x50Hz - 15.625khz - 13.5MHz interlaced (625i) (PAL)
// Output is Composite video, Sync with BT656 embedded sync code
// Register format for each group: {regoff, value1, ..., valuen}
#define EVM_A7105_SDTV576I_YCBCR704X576X50_COMP {                                                                                           \
    /* Slave mode */                                                                                                                        \
    {0x96,0x20,0x00},                                                                                                                       \
    {0x84,0x75},                                                                                                                            \
    /* Default setup */                                                                                                                     \
    {0xd0,0x00,0x00,0x00,0x00,0x02,0x00,0x10,0x00,0x00,0x01,0x0c,0x00,0x0d},                                                                \
    {0xf0,0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd3},                                                           \
    /* Cursor table */                                                                                                                      \
    {0xfe,0x00,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,\
     0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa},                                                           \
    /* Color bar config */                                                                                                                  \
    {0x3a,0x0d},                                                                                                                            \
    /* Video Display settings */                                                                                                            \
    {0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1b,0x1b,0x1f,0x70,\
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x3f,0x21,0x1d,0xff,0xff,0x0f,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
     0x00,0x00,0x1a,0x1a,0x19,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,\
     0x00,0x00,0x00,0x02,0xff,0xbf,0xfe,0xff,0xff,0x6b,0x7b,0xae,0x3a,0x2e,0x2e,0x00,0x02,0x2d,0xcb,0x8a,0x09,0x2a,0xff,0xff,0xff,0xff,0x00,\
     0x02,0x00,0x00,0x11,0x18,0xb8,0x61,0x54,0x02,0x00,0x06,0x10,0x05,0x10,0x15,0x37,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x75,0x08,0x00,\
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd0,0x13,0x13,0x08,0x22,0x21,0x00,0xbf,0x36,0x00,0x00,0x08,0x64,0x64,0x00,0x00,0x00,\
     0x0a,0x80},                                                                                                                            \
    {0xfd,0xd3},                                                                                                                            \
    {0x2d,0x62},                                                                                                                            \
    /* Syncmode settings */                                                                                                                 \
    {{0x3a,0x19},                                                                                                                           \
    {0x99,0x36},                                                                                                                            \
    {0x90,0x00},                                                                                                                            \
    {0x94,0x08},                                                                                                                            \
    {0x6c,0x02},                                                                                                                            \
    {0x6d,0x00}}                                                                                                                            \
}

/****************************************************************************
 *                             Data Definitions                             *
 ****************************************************************************/
//  Handle
typedef Int32 EVM_A7105_Handle;

// Register structure
typedef struct
{
    Uint8 slavemodeP1[EVM_A7105_SLAVEMODEP1N+1];
    Uint8 slavemodeP2[EVM_A7105_SLAVEMODEP2N+1];
    Uint8 defaultsetP1[EVM_A7105_DEFAULTSETP1N+1];
    Uint8 defaultsetP2[EVM_A7105_DEFAULTSETP2N+1];
    Uint8 cursortable[EVM_A7105_CURSORTABLEN+1];
    Uint8 colorbar[EVM_A7105_COLORBARN+1];
    Uint8 videodisplP1[EVM_A7105_VIDEODISPLP1N+1];
    Uint8 videodisplP2[EVM_A7105_VIDEODISPLP2N+1];
    Uint8 videodisplP3[EVM_A7105_VIDEODISPLP3N+1];
    Uint8 syncmode[EVM_A7105_SYNC_NREGS][2];
} EVM_A7105_Setup;


/****************************************************************************
 *                             Public Functions                             *
 ****************************************************************************/

/**************************************************************************** 
 *
 * NAME  
 *      EVM_A7105_open
 *
 * PURPOSE:
 *      Open an A7105 SD video DAC device and return a handle.
 *      At opening, the A7105 video DAC is initialized according to
 *      the specified setup matrix. When the device is not used, the device must
 *      be closed by EVM_A7105_close. 
 *
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *      EVM_A7105_Handle EVM_A7105_open( Uint32 id, EVM_A7105_Setup *setup )
 *
 *      id    - (i) id of desired A7105 [EVM_A7105_CH1]
 *      setup - (i) A7105 setup structure
 *
 * RETURN VALUE
 *      Handle value, >= EVM_A7105_NHANDLE in case of problem
 *
 * REFERENCE
 *
 ****************************************************************************/
EVM_A7105_Handle EVM_A7105_open( Uint32 id, EVM_A7105_Setup *setup );


/**************************************************************************** 
 *
 * NAME  
 *      EVM_A7105_close
 *
 * PURPOSE:
 *      Close a video device previously opened by EVM_A7105_open.
 *
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *      Int32 EVM_A7105_close( EVM_A7105_Handle *A7105handle )
 *
 *      A7105handle - (i) handle of the A7105 returned when opened.
 *
 * RETURN VALUE
 *      EVM_A7105_OK if OK, !=EVM_A7105_OK if problems
 *
 * REFERENCE
 *
 ****************************************************************************/
Int32 EVM_A7105_close( EVM_A7105_Handle *A7105handle );


/**************************************************************************** 
 *
 * NAME  
 *      EVM_A7105_setup
 *
 * PURPOSE:
 *      Setup the current A7105 SD video display channel with default register values.
 *      A setup structure is given for this purpose.
 *
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *      Int32 EVM_A7105_setup( EVM_A7105_Handle A7105handle, EVM_A7105_Setup *setup )
 *
 *      A7105handle - (i) handle of the A7105 returned when opened.
 *
 *      setup       - (i) A7105 setup data structure.
 *
 * RETURN VALUE
 *      EVM_A7105_OK if OK, !=EVM_A7105_OK if problems
 *
 * REFERENCE
 *
 ****************************************************************************/
Int32 EVM_A7105_setup( EVM_A7105_Handle A7105handle, EVM_A7105_Setup *setup );


/**************************************************************************** 
 *
 * NAME  
 *      EVM_A7105_rget
 *
 * PURPOSE:
 *      Read specified register(s) of the current A7105 video handle.
 *      The register(s) will be read from the A7105 associated with the current
 *      handle, starting at the specified offset position, for number of bytes
 *      specified. If more than one byte is read, the offset will autoincrement.
 *
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *      Int32 EVM_A7105_rget( EVM_A7105_Handle A7105handle,  Uint8 regnum, Uint8* regval, Uint16 nbytes )
 *
 *      A7105handle - (i) handle of the A7105 returned when opened.
 *
 *      regnum      - (i) starting register offset (8 bits).
 *
 *      regval      - (o) register(s) value read (8 bits buffer).
 *
 *      nbytes      - (o) number of register values to read in the buffer.
 *
 * RETURN VALUE
 *      EVM_A7105_OK if OK, !=EVM_A7105_OK if problems
 *
 * REFERENCE
 *
 ****************************************************************************/
Int32 EVM_A7105_rget( EVM_A7105_Handle A7105handle,  Uint8 regnum, Uint8* regval, Uint16 nbytes );


/**************************************************************************** 
 *
 * NAME  
 *      EVM_A7105_rset
 *
 * PURPOSE:
 *      Write register(s) with specified value(s) for the A7105 of this handle.
 *      The register(s) will be written from the A7105 associated with the current
 *      handle, starting at the specified offset position, for number of bytes
 *      specified. If more than one byte is written, the offset will autoincrement.
 *
 * USAGE
 *      This routine is C-callable and can be called as:
 *
 *      Int32 EVM_A7105_rset( EVM_A7105_Handle A7105handle, Uint8 regnum, Uint8 *regbufval, Uint16 nbytes )
 *
 *      A7105handle - (i) handle of the A7105 returned when opened.
 *
 *      regnum      - (i) starting register offset (8 bits).
 *
 *      regbufval   - (i) register(s) value read (8 bits byte buffer).
 *
 *      nbytes      - (i) number of bytes in regbufval buffer to be written.
 *
 * RETURN VALUE
 *      0 if OK, >0 if problems
 *
 * REFERENCE
 *
 ****************************************************************************/
Int32 EVM_A7105_rset( EVM_A7105_Handle A7105handle, Uint8 regnum, Uint8 *regbufval, Uint16 nbytes );


#endif // __EVM_A7105_H__
