/***************************************************************************
 *
 *
 *         **   **    **  ******  ********  ********  ********  **    **    
 *        **    **   **  **   ** ********  ********  ********  **    **
 *       **     *****   **   **    **     **        **        **    **
 *      **       **    ******     **     ****      **        ********
 *     **       **    **  **     **     **        **        **    **
 *    *******  **    **   **    **     ********  ********  **    **
 *   *******  **    **    **   **     ********  ********  **    **  
 *
 *            L Y R T E C H   S I G N A L   P R O C E S S I N G              
 *
 ***************************************************************************
 *                                                                          
 *  Project     : EVM
 *  File        : EVMupdaterb.cmd
 *  Description : Linker Command File
 *
 *                    Copyright (c) Lyrtech inc. 2007                        
 *
 ***************************************************************************
 *                                                                                          
 * "$Revision: 1.1 $"
 * "$Date: 2007/09/05 19:47:28 $"
 *
 ***************************************************************************/
-l rts64plus.lib
-l ..\..\bsl\lib\bsl.lib

-stack          0x00004000      /* Stack Size */
-heap           0x00040000      /* Heap Size */

/* MODULE MEM */
/* The IRAM_LOADERx+IRAM_PARAMS memory sections must be 0x2000 total len */
/* Warning: there must be identical size matching section in internal L2 and flash */
MEMORY
{
    IRAM_LOADER : origin = 0x00A00000,  len = 0x0400
    IRAM_PARAMS : origin = 0x00A00400,  len = 0x0180
    IRAM_LOADER2: origin = 0x00A00580,  len = 0x0080
    IRAM_LOADER3: origin = 0x00A00600,  len = 0x1a00
    IRAM        : origin = 0x00A02000,  len = 0x7e000
    FLSH_LOADER : origin = 0xA0000000,  len = 0x0400
    FLSH_PARAMS : origin = 0xA0000400,  len = 0x0180
    FLSH_LOADER2: origin = 0xA0000580,  len = 0x0080
    FLSH_LOADER3: origin = 0xA0000600,  len = 0x1a00
    FLSH        : origin = 0xA0002000,  len = 0x7e000
    DDR2        : origin = 0xE0000000,  len = 0x10000000
}

SECTIONS
{
    .boot:  load = IRAM_LOADER,  run = FLSH_LOADER, START(_start_loader), SIZE(_size_loader)
    .avar:  run = IRAM_LOADER2,  START(_start_loader2), SIZE(_size_loader2)
    .boot2: load = IRAM_LOADER3, START(_start_loader3), SIZE(_size_loader3)

    .favar:  load = FLSH_LOADER2
       {  _start_floader2=.;}
    .fboot2: load = FLSH_LOADER3
       {  _start_floader3=.;}
    .fsupd:  load = FLSH
       {_start_fupdater=.;}
    .supd:   load = IRAM
       {_start_updater=.;}
    .params: load = IRAM_PARAMS
       {}
    UNION: run = DDR2
    {
    .bigvar:
    .esrcdata:
    }
}

SECTIONS
{
    .text       >   IRAM
    .bss        >   IRAM
    .cinit      >   IRAM
    .cio        >   IRAM
    .const      >   IRAM
    .data       >   IRAM
    .far        >   IRAM
    .stack      >   IRAM
    .switch     >   IRAM
    .sysmem     >   IRAM
}
