/* =============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006.
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *  ============================================================================
 */

/** ============================================================================
 *   @file  csl_rac_regs.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  API header for RAC COMMON CSL
 *
 */
 
/* =============================================================================
 *  Revision History
 *  ================
 *  31-May-2005   RDefosseux     File Created.
 *
 * =============================================================================
 */
 
#ifndef _CSL_RAC_REGS_H_
#define _CSL_RAC_REGS_H_

#include <csl.h>
#include <cslr_rac_cfg.h>
#include <cslr_gccp_cfg.h>
#include <cslr_rac_data.h>

#ifndef _RACFL_TESTBENCH_HOST_BUILD_
#include <soc.h>
#else
/**
 * do not include soc64plus.h for racoh testbench if running on HOST
 * 
 * must define the following in testbench code for RAC CSL to work
 * 
 * volatile CSL_Rac_cfgRegs CSL_RAC_REGS_MEM;
 * volatile CSL_Rac_cfgRegs * CSL_RAC_REGS = &CSL_RAC_REGS_MEM;
 * 
 * volatile CSL_Gccp_cfgRegs CSL_GCCP_REGS_MEM;
 * volatile CSL_Gccp_cfgRegs * CSL_GCCP_REGS = &CSL_GCCP_REGS_MEM;
 * 
 * volatile CSL_Rac_dataRegs CSL_RAC_DATA_MEM;
 * volatile CSL_Rac_dataRegs * CSL_RAC_DATA = &CSL_RAC_DATA_MEM;
 * 
 */ 
 
extern volatile CSL_Rac_cfgRegs * CSL_RAC_REGS;
extern volatile CSL_Gccp_cfgRegs * CSL_GCCP_REGS;
extern volatile CSL_Rac_dataRegs * CSL_RAC_DATA;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************* 
 *  RAC Macros
 ******************************************************************************/

/******************************************************************************* 
 *  VCP global typedef declarations 
 ******************************************************************************/

/** 
 *  Handle to access RAC registers accessible through config bus. 
 */
#define hRacRegs      ((CSL_Rac_cfgRegs*)CSL_RAC_REGS)
#define hGccpRegs     ((CSL_Gccp_cfgRegs*)CSL_GCCP_REGS)
#define hRacData      ((CSL_Rac_dataRegs*)CSL_RAC_DATA)

/** 
 *  Handle to access RAC registers accessible through EDMA bus. 
 */

/* Macros inspired by CSL original macros */
/* the Field WRIte macro */
#define CSL_FWRI(reg, PER_REG_FIELD, val)                                   \
    ((reg) = CSL_FMK(PER_REG_FIELD, val))

/* the Field WRIte (Token) macro */
#define CSL_FWRIT(reg, PER_REG_FIELD, TOKEN)                                \
    CSL_FWRI((reg), PER_REG_FIELD, CSL_##PER_REG_FIELD##_##TOKEN)


#ifdef __cplusplus
}
#endif

#endif



