/* =============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *  ============================================================================
 */

/** ============================================================================
 *   @file  csl_rac_regsBETypes.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains all the RAC CSL specific data types and enumeration
 *          types. 
 */
 
/* =============================================================================
 *  Revision History
 *  ================
 *  31-May-2005   RDefosseux     File Created.
 * =============================================================================
 */


#ifndef _CSL_RAC_BE_TYPES_H_
#define _CSL_RAC_BE_TYPES_H_

#include <csl_types.h>

/** 
 *  @name    CSL_RAC_BETI_statusBit
 *
 *  @desc    Enumeration for specifying getBETIStatus output.
 * 
 *  @field   CSL_RAC_BETI_statusBit_Disable
 *               BETI is disabled.
 * 
 *  @field   CSL_RAC_BETI_statusBit_Enable
 *               BETI is enabled.
 * 
 *  @see    
 *  
 */
typedef enum
{
    CSL_RAC_BETI_statusBit_Disable, 
    CSL_RAC_BETI_statusBit_Enable
} CSL_RAC_BETI_statusBit;

/** 
 *  @name    CSL_RAC_BETI_wdInterruptStatus
 *
 *  @desc    Enumeration for specifying getWatchDogInterruptStatus output.
 * 
 *  @field   CSL_RAC_BETI_wdInterruptStatus_NoInt
 *               No interrupt has been generated.
 * 
 *  @field   CSL_RAC_BETI_wdInterruptStatus_Int
 *               An interrupt has been generated and forwarded to the BEII.
 * 
 *  @see    
 *  
 */
typedef enum
{
	CSL_RAC_BETI_wdInterruptStatus_NoInt = 0,
	CSL_RAC_BETI_wdInterruptStatus_Int   = 1
} CSL_RAC_BETI_wdInterruptStatus;

/** 
 *  @name    CSL_RAC_BETI_odbtStatusBit
 *
 *  @desc    Enumeration for specifying getOdbtStatus output.
 * 
 *  @field   CSL_RAC_BETI_odbtStatusBit_noNewObd
 *               No new Output Block Descriptor has been generated.
 * 
 *  @field   CSL_RAC_BETI_odbtStatusBit_newObd
 *               A new Output Block Descriptor has been written to the buffer.
 * 
 *  @see    
 *  
 */
typedef enum 
{
    CSL_RAC_BETI_odbtStatusBit_noNewObd = 0, 
    CSL_RAC_BETI_odbtStatusBit_newObd   = 1
} CSL_RAC_BETI_odbtStatusBit;

/** 
 *  @name    CSL_RAC_BEII_interrupt
 *
 *  @desc    Enumeration for specifying interrupt enables.
 * 
 *  @field   CSL_RAC_BEII_interrupt_Disable
 *               No interrupt forwarded.
 * 
 *  @field   CSL_RAC_BEII_interrupt_Enable
 *               Interrupt forwarded.
 * 
 *  @see    
 *  
 */
typedef enum
{
    CSL_RAC_BEII_interrupt_Disable = 0, 
    CSL_RAC_BEII_interrupt_Enable  = 1
} CSL_RAC_BEII_interrupt;

/* 
 *  @name    CSL_RAC_BETI_readParamsUpdateStatus
 *
 *  @desc    Enumeration for specifying getReadParamsUpdateStatus.
 * 
 *  @field   CSL_RAC_BETI_readParamsUpdateStatus_Idle
 *               No pending request. A new request can be sent.
 * 
 *  @field   CSL_RAC_BETI_readParamsUpdateStatus_Pending
 *               A current request is still pending. No new request can
 *               be sent.
 * 
 *  @see    
 *  
 */
typedef enum
{
    CSL_RAC_BETI_readParamsUpdateStatus_Idle    = 0, 
    CSL_RAC_BETI_readParamsUpdateStatus_Pending = 1
} CSL_RAC_BETI_readParamsUpdateStatus;

/**
 *  @name    CSL_RAC_BEII_interruptStatus
 *
 *  @desc    This descriptor specifies the parameters obtained from the
 *           interrupt status register. 
 * 
 *  @field   gccp1WdStat
 *               Denotes the GCCP1 Watchdog status.
 *
 *  @field   gccp0WdStat
 *               Denotes the GCCP0 Watchdog status.
 *
 *  @field   feWdStat
 *               Denotes the Front-end Watchdog status. 
 *
 *  @field   odbtRdPtrStat
 *               Denotes the BETI ODBT read pointer crossing status.  
 *
 *  @field   obbtRdPtrStat
 *               Denotes the BETI OBBT read pointer crossing status.  
 *
 *  @field   eotStat
 *               Denotes the BETI 'end-of-transfer' status.  
 *
 *  @field   gccp1SeqStat
 *               Denotes the GCCP1 Sequencer Idle status. 
 *
 *  @field   gccp1FifoOverStat
 *               Denotes the GCCP1 FIFO Overflow status.  
 *
 *  @field   gccp1CycOverStat
 *               Denotes the GCCP#1 Cycle Overflow status.  
 *
 *  @field   gccp0SeqStat
 *               Denotes the GCCP0 Sequencer Idle status. 
 *
 *  @field   gccp0FifoOverStat
 *               Denotes the GCCP0 FIFO Overflow status.  
 *
 *  @field   gccp0CycOverStat
 *               Denotes the GCCP0 Cycle Overflow status.  
 *
 *  @field   oddWWAC
 *               Gives the current value of the even copy of the WWAC. 
 *
 *  @see
 *
 */
typedef struct _CSL_RAC_BEII_interruptStatus
{
	Uint8 gccp1WdStat;
	Uint8 gccp0WdStat;
	Uint8 feWdStat;
	Uint8 odbtRdPtrStat;
	Uint8 obbtRdPtrStat;
	Uint8 eotStat;
	Uint8 gccp1SeqStat;
	Uint8 gccp1FifoOverStat;
	Uint8 gccp1CycOverStat;
	Uint8 gccp0SeqStat;
	Uint8 gccp0FifoOverStat;
	Uint8 gccp0CycOverStat;
} CSL_RAC_BEII_interruptStatus;

#endif

